/*
 * Decompiled with CFR 0.152.
 */
package de.javasoft.syntheticaaddons.ui;

import de.javasoft.plaf.synthetica.SyntheticaLookAndFeel;
import de.javasoft.plaf.synthetica.SyntheticaState;
import de.javasoft.plaf.synthetica.util.DropShadow;
import de.javasoft.syntheticaaddons.ui.painter.TitledPanelPainter;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.image.BufferedImage;
import javax.swing.JComponent;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.border.Border;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.synth.Region;
import javax.swing.plaf.synth.SynthContext;
import javax.swing.plaf.synth.SynthLookAndFeel;
import javax.swing.plaf.synth.SynthStyle;
import org.jdesktop.swingx.JXTitledPanel;
import org.jdesktop.swingx.painter.Painter;
import org.jdesktop.swingx.plaf.basic.BasicTitledPanelUI;

public class TitledPanelUI
extends BasicTitledPanelUI {
    public static ComponentUI createUI(JComponent c) {
        return new TitledPanelUI();
    }

    protected void installDefaults(final JXTitledPanel titledPanel) {
        super.installDefaults(titledPanel);
        Color color = SyntheticaLookAndFeel.getColor((String)"JXTitledPanel.title.foreground", (Component)titledPanel);
        if (color != null) {
            this.installProperty((JComponent)titledPanel, "titleForeground", color);
        }
        Painter<Object> painter = new Painter<Object>(){

            public void paint(Graphics2D g, Object o, int width, int height) {
                TitledPanelPainter.getInstance().paintTitledPanelTitleBackground((JComponent)titledPanel, new SyntheticaState(), g, 0, 0, width, height);
            }
        };
        this.installProperty((JComponent)titledPanel, "titlePainter", painter);
    }

    protected void installComponents(JXTitledPanel titledPanel) {
        this.topPanel.add((Component)this.caption, (Object)new GridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 18, 2, this.getCaptionInsets(), 0, 0));
        if (titledPanel.getClientProperty((Object)"JXTitledPanel.rightDecoration") instanceof JComponent) {
            this.setRightDecoration((JComponent)titledPanel.getClientProperty((Object)"JXTitledPanel.rightDecoration"));
        }
        if (titledPanel.getClientProperty((Object)"JXTitledPanel.leftDecoration") instanceof JComponent) {
            this.setLeftDecoration((JComponent)titledPanel.getClientProperty((Object)"JXTitledPanel.leftDecoration"));
        }
        if (!(titledPanel.getLayout() instanceof BorderLayout)) {
            titledPanel.setLayout((LayoutManager)new BorderLayout());
        }
        titledPanel.add((Component)this.topPanel, (Object)"North");
        if (titledPanel.getBorder() == null || titledPanel.getBorder() instanceof UIResource) {
            titledPanel.setBorder((Border)new TitledPanelBorder());
        }
        titledPanel.setOpaque(false);
    }

    protected JLabel createAndConfigureCaption(final JXTitledPanel titledPanel) {
        JLabel caption = new JLabel(titledPanel.getTitle()){
            private static final long serialVersionUID = 8009445903086457759L;

            @Override
            public void updateUI() {
                super.updateUI();
                this.setForeground(titledPanel.getTitleForeground());
                this.setFont(titledPanel.getTitleFont());
            }

            @Override
            protected void paintComponent(Graphics g) {
                JInternalFrame iFrame = new JInternalFrame();
                SynthStyle ss = SynthLookAndFeel.getStyle(iFrame, Region.INTERNAL_FRAME_TITLE_PANE);
                SynthContext sc = new SynthContext(iFrame, Region.INTERNAL_FRAME_TITLE_PANE, ss, 0);
                String title = this.getText();
                Insets insets = this.getInsets();
                int tx = insets.left;
                int ty = insets.top;
                if (SyntheticaLookAndFeel.getBoolean((String)"Synthetica.titledPanel.dropShadow.enabled", (Component)titledPanel)) {
                    FontMetrics fm = this.getFontMetrics(this.getFont());
                    BufferedImage image = new BufferedImage(TitledPanelUI.this.topPanel.getWidth(), TitledPanelUI.this.topPanel.getHeight(), 2);
                    Graphics2D g2 = image.createGraphics();
                    g2.setFont(g.getFont());
                    ((Graphics)g2).drawString(this.getText(), tx, ty + fm.getAscent());
                    g2.dispose();
                    DropShadow ds = new DropShadow(image);
                    ds.setDistance(SyntheticaLookAndFeel.getInt((String)"Synthetica.titledPanel.dropShadow.distance", (Component)titledPanel, (int)-5));
                    if (SyntheticaLookAndFeel.getColor((String)"Synthetica.titledPanel.dropShadow.color", (Component)titledPanel) != null) {
                        ds.setShadowColor(SyntheticaLookAndFeel.getColor((String)"Synthetica.titledPanel.dropShadow.color", (Component)titledPanel));
                    }
                    if (SyntheticaLookAndFeel.get((String)"Synthetica.titledPanel.dropShadow.highQuality", (Component)titledPanel) != null) {
                        ds.setQuality(SyntheticaLookAndFeel.getBoolean((String)"Synthetica.titledPanel.dropShadow.highQuality", (Component)titledPanel));
                    }
                    ds.paintShadow(g, 0, 0);
                }
                if (SyntheticaLookAndFeel.getBoolean((String)"Synthetica.titledPanel.title.etchedTop", (Component)titledPanel)) {
                    g.setColor(Color.BLACK);
                    ss.getGraphicsUtils(sc).paintText(sc, g, title, tx, ty - 1, -2);
                }
                if (SyntheticaLookAndFeel.getBoolean((String)"Synthetica.titledPanel.title.etchedBottom", (Component)titledPanel)) {
                    g.setColor(Color.WHITE);
                    ss.getGraphicsUtils(sc).paintText(sc, g, title, tx, ty + 1, -2);
                }
                super.paintComponent(g);
            }
        };
        return caption;
    }

    protected Insets getCaptionInsets() {
        return SyntheticaLookAndFeel.getInsets((String)"Synthetica.titledPanel.title.insets", null, (boolean)false, (boolean)true);
    }

    private static class TitledPanelBorder
    implements Border,
    UIResource {
        private TitledPanelBorder() {
        }

        @Override
        public void paintBorder(Component c, Graphics g, int x, int y, int w, int h) {
            JXTitledPanel tPanel = (JXTitledPanel)c;
            Container topPanel = ((BasicTitledPanelUI)tPanel.getUI()).getTitleBar();
            int top = this.getBorderInsets((Component)c).top;
            SyntheticaState state = new SyntheticaState();
            TitledPanelPainter.getInstance().paintTitledPanelTitleBorder((JComponent)tPanel, state, g, x, y, w, topPanel.getHeight() + top);
            TitledPanelPainter.getInstance().paintTitledPanelBorder((JComponent)tPanel, state, g, x, y + topPanel.getHeight() + top, w, h - topPanel.getHeight() - top);
        }

        @Override
        public Insets getBorderInsets(Component c) {
            Insets insets = SyntheticaLookAndFeel.getInsets((String)"Synthetica.titledPanel.border.insets", (Component)c, (boolean)false, (boolean)true);
            if (SyntheticaLookAndFeel.get((String)"Synthetica.titledPanel.title.background.insets", (Component)c) != null) {
                insets.top = SyntheticaLookAndFeel.getInsets((String)"Synthetica.titledPanel.title.background.insets", (Component)c, (boolean)false, (boolean)true).top;
            }
            return insets;
        }

        @Override
        public boolean isBorderOpaque() {
            return false;
        }
    }
}

