/*
 * Decompiled with CFR 0.152.
 */
package de.javasoft.syntheticaaddons.ui;

import de.javasoft.plaf.synthetica.SyntheticaLookAndFeel;
import de.javasoft.plaf.synthetica.SyntheticaState;
import de.javasoft.syntheticaaddons.SyntheticaAddonsUtilities;
import de.javasoft.syntheticaaddons.ui.painter.MonthViewPainter;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.CellRendererPane;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JSpinner;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.plaf.ComponentUI;
import javax.swing.text.JTextComponent;
import org.jdesktop.swingx.JXHyperlink;
import org.jdesktop.swingx.plaf.basic.BasicMonthViewUI;
import org.jdesktop.swingx.plaf.basic.CalendarHeaderHandler;
import org.jdesktop.swingx.plaf.basic.CalendarState;

public class MonthViewUI
extends BasicMonthViewUI {
    public static ComponentUI createUI(JComponent c) {
        return new MonthViewUI();
    }

    public void installDefaults() {
        super.installDefaults();
        if (UIManager.getLookAndFeel() instanceof SyntheticaLookAndFeel) {
            LookAndFeel.installProperty((JComponent)this.monthView, "opaque", SyntheticaLookAndFeel.getBoolean((String)"Synthetica.monthView.opaque", (Component)this.monthView, (boolean)Boolean.FALSE));
        } else {
            LookAndFeel.installProperty((JComponent)this.monthView, "opaque", Boolean.TRUE);
        }
        this.installDelegate();
        this.updateCalendarHeader();
    }

    public void installUI(JComponent c) {
        super.installUI(c);
        this.updateCalendarHeader();
    }

    private void updateCalendarHeader() {
        CalendarHeaderHandler handler = this.getCalendarHeaderHandler();
        if (handler != null && handler.getHeaderComponent() != null && (this.isZoomable() || SyntheticaLookAndFeel.getBoolean((String)"JXDatePicker.forceZoomable", null))) {
            JComponent header = handler.getHeaderComponent();
            SyntheticaAddonsUtilities.updateChildrenUI(header);
            Color foreground = UIManager.getColor("JXMonthView.monthStringForeground");
            Component[] componentArray = header.getComponents();
            int n = componentArray.length;
            int n2 = 0;
            while (n2 < n) {
                Component c = componentArray[n2];
                c.setForeground(foreground);
                if (c instanceof JComponent) {
                    ((JComponent)c).setBorder(null);
                }
                if (c instanceof JSpinner) {
                    SyntheticaLookAndFeel.findComponent(JTextComponent.class, (Container)((JSpinner)c)).setForeground(new Color(foreground.getRGB()));
                    ((JSpinner)c).setBorder(SyntheticaLookAndFeel.getInstance().createEmptyBorder(1, 0, 1, 0, true));
                }
                ++n2;
            }
            Insets insets = SyntheticaLookAndFeel.getInsets((String)"JXMonthView.calendarHeader.insets", null, (Insets)new Insets(3, 3, 3, 3), (boolean)true);
            header.setBorder(new EmptyBorder(insets));
            header.setOpaque(false);
            header.setBackground(new Color(0, 0, 0, 0));
            this.updateActionIcon("previousMonth", this.monthDownImage);
            this.updateActionIcon("nextMonth", this.monthUpImage);
        }
    }

    private void updateActionIcon(String key, Icon icon) {
        Action action = this.monthView.getActionMap().get(key);
        if (action != null) {
            action.putValue("SmallIcon", icon);
        }
    }

    public void uninstallUI(JComponent c) {
        super.uninstallUI(c);
    }

    protected void installDelegate() {
        this.isLeftToRight = this.monthView.getComponentOrientation().isLeftToRight();
        if (UIManager.getLookAndFeel() instanceof SyntheticaLookAndFeel) {
            this.monthDownImage = SyntheticaLookAndFeel.loadIcon((String)"JXMonthView.monthDownFileName", (Component)this.monthView, (boolean)true);
            this.monthUpImage = SyntheticaLookAndFeel.loadIcon((String)"JXMonthView.monthUpFileName", (Component)this.monthView, (boolean)true);
        } else {
            this.monthDownImage = UIManager.getIcon("JXMonthView.monthDownFileName");
            this.monthUpImage = UIManager.getIcon("JXMonthView.monthUpFileName");
        }
        this.setFirstDisplayedDay(this.monthView.getFirstDisplayedDay());
    }

    protected void paintDaysOfWeekSeparator(Graphics g, Calendar month) {
        Rectangle r = this.getSeparatorBounds(month, 0, 1);
        if (r != null) {
            g.setColor(SyntheticaLookAndFeel.getColor((String)"JXMonthView.daysOfWeekSeparator.foreground", (Component)this.monthView, (Color)this.monthView.getForeground()));
            g.fillRect(r.x, r.y, r.width, r.height);
        }
    }

    protected void paintWeekOfYearSeparator(Graphics g, Calendar month) {
        Rectangle r = this.getSeparatorBounds(month, 1, 0);
        if (r != null) {
            g.setColor(SyntheticaLookAndFeel.getColor((String)"JXMonthView.weekOfYearSeparator.foreground", (Component)this.monthView, (Color)this.monthView.getForeground()));
            g.fillRect(r.x, r.y, r.width, r.height);
        }
    }

    private Rectangle getSeparatorBounds(Calendar month, int row, int column) {
        Rectangle separator = this.getDayBoundsInMonth(month.getTime(), row, column);
        if (separator == null) {
            return null;
        }
        int size = SyntheticaLookAndFeel.getInstance().scaleInteger(Integer.valueOf(1));
        if (column == 0) {
            separator.height *= 6;
            separator.y -= size;
            if (this.isLeftToRight) {
                separator.x += separator.width - size;
            }
            separator.width = size;
        } else if (row == 0) {
            int oldWidth = separator.width;
            separator.width *= 7;
            if (!this.isLeftToRight) {
                separator.x -= separator.width - oldWidth;
            }
            separator.y += separator.height - size;
            separator.height = size;
        }
        return separator;
    }

    protected void paintMonthHeader(Graphics g, Calendar month) {
        if (UIManager.getLookAndFeel() instanceof SyntheticaLookAndFeel) {
            Rectangle r = new Rectangle(this.getMonthHeaderBounds(month.getTime(), false));
            MonthViewPainter.getInstance().paintMonthViewMonthBackground((JComponent)this.monthView, new SyntheticaState(), g, r.x, r.y, r.width, r.height);
            if (this.monthView.isTraversable() && !this.isZoomable()) {
                int arrowPaddingX = 3;
                int arrowPaddingY = 0;
                r.y = r.y + (r.height - this.monthDownImage.getIconHeight()) / 2 + arrowPaddingY;
                this.monthDownImage.paintIcon(null, g, r.x + arrowPaddingX, r.y);
                this.monthUpImage.paintIcon(null, g, r.x + r.width - this.monthUpImage.getIconWidth() - arrowPaddingX, r.y);
            }
        }
        if (!this.isZoomable()) {
            super.paintMonthHeader(g, month);
        }
    }

    protected void paintDayOfMonth(Graphics g, Rectangle bounds, Calendar calendar, CalendarState state) {
        if (UIManager.getLookAndFeel() instanceof SyntheticaLookAndFeel) {
            Date hoverDate;
            boolean opaque;
            long time = calendar.getTime().getTime();
            JComponent comp = this.getRenderingHandler().prepareRenderingComponent(this.monthView, calendar, state);
            boolean bl = opaque = (state == CalendarState.IN_MONTH || state == CalendarState.TODAY) && this.monthView.getSelection().size() > 0 && time >= ((Date)this.monthView.getSelection().first()).getTime() && time <= ((Date)this.monthView.getSelection().last()).getTime();
            if (SyntheticaLookAndFeel.getBoolean((String)"Synthetica.monthView.opaqueDayHighlighterSupport", (Component)this.monthView, (boolean)false)) {
                opaque = state != CalendarState.TITLE && state != CalendarState.WEEK_OF_YEAR && state != CalendarState.DAY_OF_WEEK;
            }
            boolean hover = (hoverDate = (Date)SyntheticaLookAndFeel.getClientProperty((String)"MOUSE_OVER_DATE", (JComponent)this.monthView, null)) != null && hoverDate.equals(calendar.getTime()) && (state == CalendarState.IN_MONTH || state == CalendarState.TODAY);
            comp.setOpaque(hover || opaque);
            CellRendererPane rendererPane = (CellRendererPane)this.monthView.getComponent(0);
            rendererPane.paintComponent(g, comp, (Container)this.monthView, bounds.x, bounds.y, bounds.width, bounds.height, true);
        } else {
            super.paintDayOfMonth(g, bounds, calendar, state);
        }
    }

    protected int getTraversableGridPositionAtLocation(int x, int y) {
        int pos = super.getTraversableGridPositionAtLocation(x, y);
        if (this.monthView.isZoomable()) {
            JSpinner spinner;
            pos = -1;
            ArrayList list = new ArrayList();
            SyntheticaLookAndFeel.findComponents(JXHyperlink.class, (Container)this.monthView, list);
            if (list.size() == 2) {
                if (((JXHyperlink)list.get(0)).getBounds().contains(x, y)) {
                    return 1;
                }
                if (((JXHyperlink)list.get(1)).getBounds().contains(x, y)) {
                    return 2;
                }
            }
            if ((spinner = (JSpinner)SyntheticaLookAndFeel.findComponent(JSpinner.class, (Container)this.monthView)) != null && spinner.getBounds().contains(x, y)) {
                AbstractButton b = (AbstractButton)SyntheticaLookAndFeel.findComponent((String)"Spinner.nextButton", (Container)spinner);
                Point p = SwingUtilities.convertPoint((Component)this.monthView, new Point(x, y), spinner);
                if (b.getBounds().contains(p)) {
                    this.nextYear();
                    return -1;
                }
                b = (AbstractButton)SyntheticaLookAndFeel.findComponent((String)"Spinner.previousButton", (Container)spinner);
                p = SwingUtilities.convertPoint((Component)this.monthView, new Point(x, y), spinner);
                if (b.getBounds().contains(p)) {
                    this.previousYear();
                    return -1;
                }
            }
        }
        return pos;
    }

    private void nextYear() {
        Date upperBound = this.monthView.getUpperBound();
        if (upperBound == null || upperBound.after(this.getLastDisplayedDay())) {
            Calendar cal = this.getCalendar();
            cal.add(1, 1);
            this.monthView.setFirstDisplayedDay(cal.getTime());
        }
    }

    private void previousYear() {
        Date lowerBound = this.monthView.getLowerBound();
        if (lowerBound == null || lowerBound.before(this.getFirstDisplayedDay())) {
            Calendar cal = this.getCalendar();
            cal.add(1, -1);
            this.monthView.setFirstDisplayedDay(cal.getTime());
        }
    }
}

