/*
 * Decompiled with CFR 0.152.
 */
package de.javasoft.syntheticaaddons.table;

import de.javasoft.syntheticaaddons.table.AbstractTableCellEditor;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.BoundedRangeModel;
import javax.swing.DefaultBoundedRangeModel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.table.TableCellEditor;

public class SliderTableCellEditor
extends AbstractTableCellEditor<JSlider> {
    public SliderTableCellEditor(TableCellEditor defaultEditor) {
        super(defaultEditor);
    }

    @Override
    public JSlider createEditorComponent() {
        JSlider c = new JSlider();
        c.putClientProperty("Synthetica.paintFocus", false);
        return c;
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        this.setCellEditorValue(value);
        JPanel p = new JPanel(new BorderLayout());
        p.setOpaque(false);
        p.add(this.editorComponent);
        p.setBorder(this.getEditorComponentBorder(table, value, isSelected, row, column));
        ((JSlider)this.editorComponent).setBounds(table.getCellRect(row, column, false));
        ((JSlider)this.editorComponent).updateUI();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ((JSlider)SliderTableCellEditor.this.editorComponent).requestFocusInWindow();
            }
        });
        return p;
    }

    @Override
    public void setCellEditorValue(Object value) {
        this.modelDriven = value instanceof BoundedRangeModel;
        DefaultBoundedRangeModel m = new DefaultBoundedRangeModel();
        if (this.modelDriven) {
            BoundedRangeModel model = (BoundedRangeModel)value;
            m.setRangeProperties(model.getValue(), model.getExtent(), model.getMinimum(), model.getMaximum(), false);
        } else {
            BoundedRangeModel model = ((JSlider)this.editorComponent).getModel();
            m.setRangeProperties((Integer)value, model.getExtent(), model.getMinimum(), model.getMaximum(), false);
        }
        ((JSlider)this.editorComponent).setModel(m);
    }

    @Override
    public Object getCellEditorValue() {
        if (this.modelDriven) {
            return ((JSlider)this.editorComponent).getModel();
        }
        return ((JSlider)this.editorComponent).getValue();
    }
}

