/*
 * Decompiled with CFR 0.152.
 */
package de.javasoft.syntheticaaddons.table;

import de.javasoft.plaf.synthetica.SyntheticaLookAndFeel;
import de.javasoft.syntheticaaddons.table.AbstractTableCellEditor;
import java.awt.Component;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.table.TableCellEditor;

class MultiLineTableCellEditor
extends AbstractTableCellEditor<JTextArea> {
    public MultiLineTableCellEditor(TableCellEditor defaultEditor) {
        super(defaultEditor);
    }

    @Override
    public JTextArea createEditorComponent() {
        JTextArea c = new JTextArea();
        c.putClientProperty("Synthetica.opaque", false);
        c.setLineWrap(true);
        c.setWrapStyleWord(true);
        c.setBorder(SyntheticaLookAndFeel.getInstance().createEmptyBorder(0, 0, 0, 0, true));
        return c;
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        Component c = super.getTableCellEditorComponent(table, value, isSelected, row, column);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ((JTextArea)MultiLineTableCellEditor.this.editorComponent).requestFocusInWindow();
            }
        });
        return c;
    }

    @Override
    public Object getCellEditorValue() {
        return ((JTextArea)this.editorComponent).getText();
    }

    @Override
    public void setCellEditorValue(Object value) {
        ((JTextArea)this.editorComponent).setText(value == null ? "" : value.toString());
    }
}

