/*
 * Decompiled with CFR 0.152.
 */
package de.javasoft.syntheticaaddons.systemmonitor;

import de.javasoft.syntheticaaddons.systemmonitor.Collector;
import de.javasoft.syntheticaaddons.systemmonitor.ModelChangedEvent;
import de.javasoft.syntheticaaddons.systemmonitor.ModelChangedListener;
import de.javasoft.syntheticaaddons.systemmonitor.RingBuffer;
import java.awt.Color;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;

public class SystemMonitorModel {
    private ArrayList<String> ids = new ArrayList();
    private HashMap<String, RingBuffer<Float>> buffers = new HashMap();
    private HashMap<String, CollectorThread> collectors = new HashMap();
    private HashMap<String, Color> colors = new HashMap();
    private HashMap<String, Double> lastValues = new HashMap();
    private HashMap<String, Double> lastMaxValues = new HashMap();
    private HashMap<String, Boolean> visibility = new HashMap();
    private ArrayList<ModelChangedListener> valueListeners = new ArrayList();
    private ArrayList<ModelChangedListener> nonValueListeners = new ArrayList();

    public void addModelChangedListener(ModelChangedListener listener, int ... eventTypes) {
        if (eventTypes.length == 0) {
            this.nonValueListeners.add(listener);
            return;
        }
        int[] nArray = eventTypes;
        int n = eventTypes.length;
        int n2 = 0;
        while (n2 < n) {
            int type = nArray[n2];
            if (type == 0 || type == 1) {
                this.valueListeners.add(listener);
            } else {
                this.nonValueListeners.add(listener);
            }
            ++n2;
        }
    }

    public void removeModelChangedListener(ModelChangedListener listener) {
        this.valueListeners.remove(listener);
        this.nonValueListeners.remove(listener);
    }

    protected synchronized void fireModelChangedEvent(ModelChangedEvent<?> evt) {
        int type = evt.getType();
        if (type == 0 || type == 1) {
            for (ModelChangedListener listener : this.valueListeners) {
                listener.modelChanged(evt);
            }
        } else {
            for (ModelChangedListener listener : this.nonValueListeners) {
                listener.modelChanged(evt);
            }
        }
    }

    public void addCollector(String id, int bufferSize, int delay, Collector collector) {
        this.ids.add(id);
        this.buffers.put(id, new RingBuffer(bufferSize));
        this.collectors.put(id, new CollectorThread(id, delay, collector));
        this.lastValues.put(id, collector.getValue());
        this.lastMaxValues.put(id, collector.getMaxValue());
    }

    public void removeCollector(String id) {
        this.ids.remove(id);
        this.buffers.remove(id);
        this.collectors.get(id).interrupt();
        this.lastValues.remove(id);
        this.lastMaxValues.remove(id);
    }

    public void removeAll() {
        HashSet<String> ids = new HashSet<String>(this.buffers.keySet());
        for (String id : ids) {
            this.removeCollector(id);
        }
    }

    public List<Float> getValues(String id) {
        return this.buffers.get(id).getValues();
    }

    public int getBufferSize(String id) {
        return this.buffers.get(id).getSize();
    }

    public List<String> getIds() {
        return this.ids;
    }

    public double getLastValue(String id) {
        return this.lastValues.get(id);
    }

    public double getLastMaxValue(String id) {
        return this.lastMaxValues.get(id);
    }

    public void setColor(String id, Color color) {
        this.colors.put(id, color);
        this.fireModelChangedEvent(new ModelChangedEvent<Color>(this, 2, id, color));
    }

    public Color getColor(String id) {
        return this.colors.get(id);
    }

    public void setVisible(String id, Boolean visible) {
        this.visibility.put(id, visible);
        this.fireModelChangedEvent(new ModelChangedEvent<Boolean>(this, 3, id, visible));
    }

    public boolean getVisible(String id) {
        return this.visibility.get(id) == null ? true : this.visibility.get(id);
    }

    private class CollectorThread
    extends Thread {
        private String id;
        private int delay;
        private Collector collector;

        public CollectorThread(String id, int delay, Collector collector) {
            this.id = id;
            this.delay = delay;
            this.collector = collector;
            this.setDaemon(true);
            this.setName(id);
            this.start();
        }

        @Override
        public void run() {
            while (!this.isInterrupted()) {
                try {
                    Thread.sleep(this.delay);
                    if (this.isInterrupted()) continue;
                    double value = this.collector.getValue();
                    double maxValue = this.collector.getMaxValue();
                    double lastValue = (Double)SystemMonitorModel.this.lastValues.get(this.id);
                    double lastMaxValue = (Double)SystemMonitorModel.this.lastMaxValues.get(this.id);
                    SystemMonitorModel.this.lastValues.put(this.id, value);
                    SystemMonitorModel.this.lastMaxValues.put(this.id, maxValue);
                    if (SystemMonitorModel.this.buffers.get(this.id) != null) {
                        ((RingBuffer)SystemMonitorModel.this.buffers.get(this.id)).put(Float.valueOf((float)(value / maxValue)));
                    }
                    if (SystemMonitorModel.this.valueListeners.size() > 0 && value != lastValue) {
                        SystemMonitorModel.this.fireModelChangedEvent(new ModelChangedEvent<Double>(SystemMonitorModel.this, 0, this.id, lastValue));
                    }
                    if (SystemMonitorModel.this.valueListeners.size() <= 0 || maxValue == lastMaxValue) continue;
                    SystemMonitorModel.this.fireModelChangedEvent(new ModelChangedEvent<Double>(SystemMonitorModel.this, 1, this.id, lastMaxValue));
                }
                catch (InterruptedException e) {
                    this.interrupt();
                }
            }
            SystemMonitorModel.this.collectors.remove(this.id);
        }
    }
}

