/*
 * Decompiled with CFR 0.152.
 */
package de.javasoft.syntheticaaddons.systemmonitor;

import de.javasoft.syntheticaaddons.systemmonitor.Collector;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryPoolMXBean;
import java.util.HashMap;
import java.util.List;
import javax.management.MBeanServerConnection;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.openmbean.CompositeDataSupport;

public class CollectorFactory {
    private static final CollectorFactory instance = new CollectorFactory();
    private MBeanServerConnection mbs = ManagementFactory.getPlatformMBeanServer();
    private ObjectName sysName = null;
    private ObjectName memName = null;
    private ObjectName threadName = null;

    static {
        $SWITCH_TABLE$de$javasoft$syntheticaaddons$systemmonitor$CollectorFactory$CollectorID = CollectorFactory.$SWITCH_TABLE$de$javasoft$syntheticaaddons$systemmonitor$CollectorFactory$CollectorID();
    }

    private CollectorFactory() {
        try {
            this.sysName = new ObjectName("java.lang:type=OperatingSystem");
            this.memName = new ObjectName("java.lang:type=Memory");
            this.threadName = new ObjectName("java.lang:type=Threading");
        }
        catch (MalformedObjectNameException e) {
            throw new RuntimeException(e);
        }
    }

    public static CollectorFactory getFactory() {
        return instance;
    }

    public Collector createCollector(String id) {
        switch (CollectorID.getCollectorID(id)) {
            case CPU_USAGE: {
                return this.createCPUUsageCollector();
            }
            case THREADS: {
                return this.createThreadsCollector();
            }
            case PHYSICAL_MEMORY_USAGE: {
                return this.createPhysicalMemoryUsageCollector();
            }
            case NON_HEAP_MEMORY_USAGE: {
                return this.createNonHeapMemoryUsageCollector();
            }
            case HEAP_MEMORY_USAGE: {
                return this.createHeapMemoryUsageCollector();
            }
            case PERM_GEN_MEMORY_USAGE: {
                return this.createPermGenMemoryUsageCollector();
            }
        }
        return null;
    }

    private Collector createCPUUsageCollector() {
        return new Collector(){
            private long time;
            private long ptime;

            @Override
            public double getValue() {
                try {
                    float usage = (Long)CollectorFactory.this.mbs.getAttribute(CollectorFactory.this.sysName, "ProcessCpuTime") - this.ptime;
                    this.time = System.nanoTime();
                    this.ptime = (Long)CollectorFactory.this.mbs.getAttribute(CollectorFactory.this.sysName, "ProcessCpuTime");
                    return usage /= (float)(System.nanoTime() - this.time);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }

            @Override
            public double getMaxValue() {
                return 1.0;
            }
        };
    }

    private Collector createThreadsCollector() {
        return new Collector(){

            @Override
            public double getValue() {
                try {
                    return ((Integer)CollectorFactory.this.mbs.getAttribute(CollectorFactory.this.threadName, "ThreadCount")).intValue();
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }

            @Override
            public double getMaxValue() {
                try {
                    return ((Integer)CollectorFactory.this.mbs.getAttribute(CollectorFactory.this.threadName, "PeakThreadCount")).intValue();
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        };
    }

    private Collector createPhysicalMemoryUsageCollector() {
        return new Collector(){

            @Override
            public double getValue() {
                try {
                    double free = (double)((Long)CollectorFactory.this.mbs.getAttribute(CollectorFactory.this.sysName, "FreePhysicalMemorySize")).longValue() / 1024.0 / 1024.0;
                    return this.getMaxValue() - free;
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }

            @Override
            public double getMaxValue() {
                try {
                    return (double)((Long)CollectorFactory.this.mbs.getAttribute(CollectorFactory.this.sysName, "TotalPhysicalMemorySize")).longValue() / 1024.0 / 1024.0;
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        };
    }

    private Collector createHeapMemoryUsageCollector() {
        return new Collector(){

            @Override
            public double getValue() {
                try {
                    return (double)((Long)((CompositeDataSupport)CollectorFactory.this.mbs.getAttribute(CollectorFactory.this.memName, "HeapMemoryUsage")).get("used")).longValue() / 1024.0 / 1024.0;
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }

            @Override
            public double getMaxValue() {
                try {
                    return (double)((Long)((CompositeDataSupport)CollectorFactory.this.mbs.getAttribute(CollectorFactory.this.memName, "HeapMemoryUsage")).get("committed")).longValue() / 1024.0 / 1024.0;
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        };
    }

    private Collector createNonHeapMemoryUsageCollector() {
        return new Collector(){

            @Override
            public double getValue() {
                try {
                    return (double)((Long)((CompositeDataSupport)CollectorFactory.this.mbs.getAttribute(CollectorFactory.this.memName, "NonHeapMemoryUsage")).get("used")).longValue() / 1024.0 / 1024.0;
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }

            @Override
            public double getMaxValue() {
                try {
                    return (double)((Long)((CompositeDataSupport)CollectorFactory.this.mbs.getAttribute(CollectorFactory.this.memName, "NonHeapMemoryUsage")).get("committed")).longValue() / 1024.0 / 1024.0;
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        };
    }

    private Collector createPermGenMemoryUsageCollector() {
        MemoryPoolMXBean permGenBean = null;
        List<MemoryPoolMXBean> list = ManagementFactory.getMemoryPoolMXBeans();
        for (MemoryPoolMXBean bean : list) {
            if (!bean.getName().equals("Perm Gen")) continue;
            permGenBean = bean;
        }
        final MemoryPoolMXBean permGen = permGenBean;
        return new Collector(){

            @Override
            public double getValue() {
                try {
                    return (double)permGen.getUsage().getUsed() / 1024.0 / 1024.0;
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }

            @Override
            public double getMaxValue() {
                try {
                    return (double)permGen.getUsage().getCommitted() / 1024.0 / 1024.0;
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        };
    }

    public static enum CollectorID {
        CPU_USAGE("CPU_USAGE"),
        THREADS("THREADS"),
        PHYSICAL_MEMORY_USAGE("PHYSICAL_MEMORY_USAGE"),
        HEAP_MEMORY_USAGE("HEAP_MEMORY_USAGE"),
        NON_HEAP_MEMORY_USAGE("NON_HEAP_MEMORY_USAGE"),
        PERM_GEN_MEMORY_USAGE("PERM_GEN_MEMORY_USAGE");

        public final String id;
        private static HashMap<String, CollectorID> collectorIDs;

        static {
            collectorIDs = new HashMap();
            CollectorID[] collectorIDArray = CollectorID.values();
            int n = collectorIDArray.length;
            int n2 = 0;
            while (n2 < n) {
                CollectorID cid = collectorIDArray[n2];
                collectorIDs.put(cid.id, cid);
                ++n2;
            }
        }

        private CollectorID(String id) {
            this.id = id;
        }

        private static CollectorID getCollectorID(String id) {
            return collectorIDs.get(id);
        }
    }
}

