/*
 * Decompiled with CFR 0.152.
 */
package de.javasoft.syntheticaaddons;

import de.javasoft.plaf.synthetica.SyntheticaLookAndFeel;
import de.javasoft.plaf.synthetica.painter.SyntheticaBasicIconPainter;
import de.javasoft.syntheticaaddons.DropDownButton;
import de.javasoft.syntheticaaddons.SimpleDropDownButton;
import de.javasoft.syntheticaaddons.SyntheticaAddonsUtilities;
import java.awt.Color;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.GeneralPath;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.DefaultButtonModel;
import javax.swing.Icon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JSeparator;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.synth.SynthContext;

public class ToolBar
extends JToolBar {
    private static final long serialVersionUID = 6512375619025421868L;
    private static final String TOOLBAR_VISIBILITY = "ToolBar.Visibility";
    private static final String TOOLBAR_PREFERRED_COMPONENT_SIZE = "ToolBar.PrefComponentSize";
    private static final String TOOLBAR_PREFERRED_COMPONENT_SIZE_SET = "ToolBar.PrefComponentSizeSet";
    private JToolBar popupButtonBar;
    private PopupButton popupButton = new PopupButton(this);
    private int popupButtonIndex;
    private VisibilityListener visibilityListener;

    public ToolBar() {
        this.popupButtonBar = new JToolBar(){

            @Override
            public boolean isOpaque() {
                return false;
            }
        };
        this.popupButtonBar.setMargin(SyntheticaLookAndFeel.getInstance().scaleInsets(0, 0, 0, 0));
        this.popupButtonBar.putClientProperty("Synthetica.opaque", false);
        this.popupButtonBar.setFloatable(false);
        this.popupButtonBar.setBorder(SyntheticaLookAndFeel.getInstance().createEmptyBorder(0, 0, 0, 0, true));
        this.popupButtonBar.add(Box.createHorizontalGlue());
        this.popupButtonBar.add(this.popupButton);
        this.visibilityListener = new VisibilityListener();
        this.addContainerListener(new ContainerListener(){

            @Override
            public void componentRemoved(ContainerEvent evt) {
                evt.getChild().removeComponentListener(ToolBar.this.visibilityListener);
            }

            @Override
            public void componentAdded(ContainerEvent evt) {
                Component c = evt.getChild();
                c.addComponentListener(ToolBar.this.visibilityListener);
                if (c instanceof JComponent) {
                    ToolBar.this.updateComponentSize((JComponent)c);
                }
            }
        });
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent evt) {
                ToolBar.this.updateToolBar();
            }
        });
    }

    private void updateToolBar() {
        this.removePopupButton();
        int components = this.getComponentCount();
        int index = -1;
        int i = 0;
        while (i < components) {
            JComponent c = (JComponent)this.getComponent(i);
            boolean isOnToolBar = this.isOnToolBar(this, c);
            if (c.isVisible() || ((Boolean)SyntheticaLookAndFeel.getClientProperty((String)TOOLBAR_VISIBILITY, (JComponent)c, (Object)false)).booleanValue()) {
                this.setComponentVisible(c, isOnToolBar);
            }
            if (i < components - 1 && isOnToolBar && !this.isOnToolBar(this, this.getComponent(i + 1))) {
                index = i + 1;
            }
            ++i;
        }
        if (index > 0) {
            this.popupButtonBar.setOrientation(this.getOrientation());
            this.addPopupButton(index);
        }
        this.popupButton.setComponentOrientation(this.getComponentOrientation());
    }

    private void updateComponentSize(JComponent c) {
        if (((Boolean)SyntheticaLookAndFeel.getClientProperty((String)TOOLBAR_VISIBILITY, (JComponent)c, (Object)false)).booleanValue()) {
            return;
        }
        if (c.isVisible()) {
            Boolean prefSizeSet = (Boolean)c.getClientProperty(TOOLBAR_PREFERRED_COMPONENT_SIZE_SET);
            Dimension prefSize = (Dimension)c.getClientProperty(TOOLBAR_PREFERRED_COMPONENT_SIZE);
            if (prefSize != null) {
                c.setPreferredSize(prefSizeSet != false ? prefSize : null);
                c.putClientProperty(TOOLBAR_PREFERRED_COMPONENT_SIZE, null);
                this.updateToolBar();
            }
        } else {
            Dimension prefSize = (Dimension)SyntheticaLookAndFeel.getClientProperty((String)TOOLBAR_PREFERRED_COMPONENT_SIZE, (JComponent)c, null);
            if (prefSize == null) {
                c.putClientProperty(TOOLBAR_PREFERRED_COMPONENT_SIZE_SET, c.isPreferredSizeSet());
                c.putClientProperty(TOOLBAR_PREFERRED_COMPONENT_SIZE, c.getPreferredSize());
                c.setPreferredSize(new Dimension(0, 0));
                this.updateToolBar();
            }
        }
    }

    private void setComponentVisible(JComponent c, boolean visible) {
        c.setVisible(visible);
        if (visible) {
            c.putClientProperty(TOOLBAR_VISIBILITY, null);
        } else {
            c.putClientProperty(TOOLBAR_VISIBILITY, true);
        }
    }

    @Override
    public void updateUI() {
        if (this.popupButton != null) {
            this.removePopupButton();
            this.popupButton.updateUI();
        }
        super.updateUI();
        if (this.popupButton != null) {
            this.dispatchEvent(new ComponentEvent(this, 101));
        }
    }

    public AbstractButton getPopupButton() {
        return this.popupButton;
    }

    protected void addPopupButton(int index) {
        this.popupButtonIndex = index;
        this.add((Component)this.popupButtonBar, index);
    }

    protected void removePopupButton() {
        this.popupButtonIndex = -1;
        this.remove(this.popupButtonBar);
    }

    private boolean isOnToolBar(JToolBar toolBar, Component comp) {
        int x = 0;
        int y = 0;
        int w = comp.getPreferredSize().width;
        int h = comp.getPreferredSize().height;
        int buttonWidth = this.popupButton.getMinimumSize().width;
        int buttonHeight = this.popupButton.getMinimumSize().height;
        Component[] componentArray = toolBar.getComponents();
        int n = componentArray.length;
        int n2 = 0;
        while (n2 < n) {
            Component c = componentArray[n2];
            if (c == comp) break;
            x += c.getPreferredSize().width;
            y += c.getPreferredSize().height;
            ++n2;
        }
        if (toolBar.getOrientation() == 0) {
            if (comp == toolBar.getComponent(toolBar.getComponentCount() - 1) && this.popupButtonIndex < 0) {
                buttonWidth = 0;
            }
            return (double)(x + w + buttonWidth) <= toolBar.getVisibleRect().getWidth();
        }
        if (comp == toolBar.getComponent(toolBar.getComponentCount() - 1) && this.popupButtonIndex < 0) {
            buttonHeight = 0;
        }
        return (double)(y + h + buttonHeight) <= toolBar.getVisibleRect().getHeight();
    }

    private static class PopupButton
    extends JToggleButton
    implements ActionListener {
        private static final long serialVersionUID = 112096722125942373L;
        private ToolBar toolBar;

        private PopupButton(ToolBar toolBar) {
            this.toolBar = toolBar;
            this.addActionListener(this);
            this.setFocusPainted(false);
        }

        @Override
        public void updateUI() {
            super.updateUI();
            Icon icon = this.getIcon();
            if ((icon == null || icon instanceof UIResource) && UIManager.getLookAndFeel() instanceof SyntheticaLookAndFeel) {
                String key = "Synthetica.arrow.down";
                if (SyntheticaLookAndFeel.get((String)"ToolBar.arrowIcon", (Component)this) != null) {
                    key = "ToolBar.arrowIcon";
                }
                this.setIcon(SyntheticaLookAndFeel.loadIcon((String)key, (Component)this, (boolean)true));
                if (SyntheticaLookAndFeel.get((String)"ToolBar.arrowIcon.hover", (Component)this) != null) {
                    key = "ToolBar.arrowIcon.hover";
                    icon = SyntheticaLookAndFeel.loadIcon((String)key, (Component)this, (boolean)true);
                    this.setRolloverIcon(icon);
                    this.setPressedIcon(icon);
                    this.setSelectedIcon(icon);
                }
                if (SyntheticaLookAndFeel.get((String)"ToolBar.arrowIcon.pressed", (Component)this) != null) {
                    key = "ToolBar.arrowIcon.pressed";
                    icon = SyntheticaLookAndFeel.loadIcon((String)key, (Component)this, (boolean)true);
                    this.setPressedIcon(icon);
                    this.setSelectedIcon(icon);
                }
            } else if (icon == null || icon instanceof UIResource) {
                icon = new SyntheticaBasicIconPainter(null, 9, 4){

                    public void paint2D(SynthContext sc, Graphics2D g2, float x, float y, float w, float h) {
                        g2.setPaint(Color.BLACK);
                        y = 0.0f;
                        x = 0.0f;
                        GeneralPath path = new GeneralPath();
                        path.moveTo(x, y);
                        path.lineTo(x + w / 2.0f, y + h);
                        path.lineTo(x + w, y);
                        g2.fill(path);
                    }
                };
                this.setIcon(icon);
            }
        }

        @Override
        public Dimension getMaximumSize() {
            Insets insets = this.toolBar.getInsets();
            if (this.toolBar.getOrientation() == 0) {
                return new Dimension(super.getMaximumSize().width, this.toolBar.getHeight() - insets.top);
            }
            return new Dimension(this.toolBar.getWidth() - insets.left - insets.right, super.getMaximumSize().height);
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            JPopupMenu popup = new JPopupMenu();
            Component[] componentArray = this.toolBar.getComponents();
            int n = componentArray.length;
            int n2 = 0;
            while (n2 < n) {
                Component c = componentArray[n2];
                if (!c.isVisible() && ((Boolean)SyntheticaLookAndFeel.getClientProperty((String)ToolBar.TOOLBAR_VISIBILITY, (JComponent)((JComponent)c), (Object)false)).booleanValue()) {
                    if (c instanceof JSeparator) {
                        popup.addSeparator();
                    } else {
                        this.addItems((Container)c, popup);
                    }
                }
                ++n2;
            }
            popup.addPopupMenuListener(new PopupMenuListener(){

                @Override
                public void popupMenuWillBecomeInvisible(PopupMenuEvent evt) {
                    this.setSelected(false);
                    final JPopupMenu popup = (JPopupMenu)evt.getSource();
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            this.releaseMenuItems(popup);
                        }
                    });
                }

                @Override
                public void popupMenuCanceled(PopupMenuEvent evt) {
                }

                @Override
                public void popupMenuWillBecomeVisible(PopupMenuEvent evt) {
                }
            });
            ComponentOrientation o = this.getComponentOrientation();
            popup.applyComponentOrientation(o);
            int xPosition = o.isLeftToRight() ? 0 : this.getWidth() - popup.getPreferredSize().width;
            popup.show(this, xPosition, this.getHeight());
        }

        private void releaseMenuItems(Container container) {
            Component[] componentArray = container.getComponents();
            int n = componentArray.length;
            int n2 = 0;
            while (n2 < n) {
                Component c = componentArray[n2];
                if (c instanceof AbstractButton) {
                    ((AbstractButton)c).setModel(new DefaultButtonModel());
                }
                if (c instanceof JMenu) {
                    this.releaseMenuItems(((JMenu)c).getPopupMenu());
                }
                ++n2;
            }
        }

        private void addItems(Container srcContainer, Container destContainer) {
            if (srcContainer instanceof SimpleDropDownButton) {
                SimpleDropDownButton button = (SimpleDropDownButton)srcContainer;
                JMenu menu = new JMenu(button.getText());
                menu.setIcon(PopupButton.resizeIcon(button.getIcon()));
                menu.setEnabled(button.isEnabled());
                this.addItems(button.getPopupMenu(), menu);
                this.addEmulatedActionToMenu(menu, button);
                destContainer.add(menu);
            } else if (srcContainer instanceof DropDownButton) {
                DropDownButton button = (DropDownButton)srcContainer;
                JMenu menu = new JMenu(button.getMainButton().getText());
                menu.setIcon(PopupButton.resizeIcon(button.getMainButton().getIcon()));
                menu.setEnabled(button.isEnabled());
                this.addItems(button.getPopupMenu(), menu);
                this.addEmulatedActionToMenu(menu, button);
                destContainer.add(menu);
            } else if (srcContainer instanceof JComboBox) {
                JComboBox combo = (JComboBox)srcContainer;
                destContainer.add(new JMenuItem(combo.getSelectedItem().toString()));
            } else if (srcContainer instanceof JMenu) {
                JMenu m = (JMenu)srcContainer;
                JMenu menu = new JMenu(m.getText());
                menu.setIcon(m.getIcon());
                menu.setEnabled(m.isEnabled());
                Component[] componentArray = m.getMenuComponents();
                int n = componentArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Component c = componentArray[n2];
                    this.addItems((Container)c, menu);
                    ++n2;
                }
                destContainer.add(menu);
            } else if (srcContainer instanceof AbstractButton && !"ScrollBar.button".equals(srcContainer.getName())) {
                AbstractButton button = (AbstractButton)srcContainer;
                if (button.getAction() != null && destContainer instanceof JPopupMenu) {
                    ((JPopupMenu)destContainer).add(button.getAction());
                } else {
                    JMenuItem b = null;
                    b = button instanceof JRadioButtonMenuItem ? new JRadioButtonMenuItem(button.getText(), button.getIcon()) : (button instanceof JCheckBoxMenuItem ? new JCheckBoxMenuItem(button.getText(), button.getIcon()) : new JMenuItem(button.getText(), PopupButton.resizeIcon(button.getIcon())));
                    ((AbstractButton)b).setModel(button.getModel());
                    destContainer.add(b);
                }
            } else {
                Component[] componentArray = srcContainer.getComponents();
                int n = componentArray.length;
                int n3 = 0;
                while (n3 < n) {
                    Component c = componentArray[n3];
                    this.addItems((Container)c, destContainer);
                    ++n3;
                }
            }
        }

        private void addEmulatedActionToMenu(JMenu menu, final AbstractButton button) {
            menu.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent evt) {
                    Action a = button.getAction();
                    if (a != null && button.isEnabled()) {
                        a.actionPerformed(new ActionEvent(evt.getSource(), evt.getID(), null));
                    }
                }
            });
        }

        private static Icon resizeIcon(Icon icon) {
            if (icon == null) {
                return null;
            }
            int size = 16;
            if (icon.getIconWidth() == size && icon.getIconHeight() == size) {
                return icon;
            }
            return SyntheticaAddonsUtilities.resizeIcon(icon, size, size);
        }
    }

    private static class VisibilityListener
    extends ComponentAdapter {
        private VisibilityListener() {
        }

        @Override
        public void componentShown(ComponentEvent evt) {
            if (!(evt.getSource() instanceof JComponent)) {
                return;
            }
            JComponent c = (JComponent)evt.getSource();
            ToolBar toolbar = (ToolBar)c.getParent();
            toolbar.updateComponentSize(c);
        }

        @Override
        public void componentHidden(ComponentEvent evt) {
            if (!(evt.getSource() instanceof JComponent)) {
                return;
            }
            JComponent c = (JComponent)evt.getComponent();
            ToolBar toolbar = (ToolBar)c.getParent();
            toolbar.updateComponentSize(c);
        }
    }
}

