/*
 * Decompiled with CFR 0.152.
 */
package de.javasoft.syntheticaaddons;

import de.javasoft.plaf.synthetica.GraphicsUtils;
import de.javasoft.syntheticaaddons.Version;
import de.javasoft.util.IVersion;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.net.URI;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.UIManager;

public class SyntheticaAddonsUtilities {
    public static IVersion getVersion() {
        return Version.getInstance();
    }

    public static ImageIcon createAlphaIcon(Icon icon, float alpha) {
        return SyntheticaAddonsUtilities.createAlphaIcon(null, icon, alpha);
    }

    public static ImageIcon createAlphaIcon(Component c, Icon icon, float alpha) {
        BufferedImage bi = new BufferedImage(icon.getIconWidth(), icon.getIconHeight(), 2);
        Graphics2D g2d = (Graphics2D)bi.getGraphics();
        AlphaComposite alphaComp = AlphaComposite.getInstance(3, alpha);
        g2d.setComposite(alphaComp);
        icon.paintIcon(c, g2d, 0, 0);
        g2d.dispose();
        return new ImageIcon(bi);
    }

    public static Icon resizeIcon(Icon icon, int w, int h) {
        return new ImageIcon(SyntheticaAddonsUtilities.resizeImage((BufferedImage)GraphicsUtils.iconToImage(null, (Icon)icon), w, h));
    }

    public static BufferedImage resizeImage(BufferedImage img, int w, int h) {
        int type = img.getTransparency() == 1 ? 1 : 2;
        BufferedImage bi = new BufferedImage(w, h, type);
        Graphics2D g2 = bi.createGraphics();
        g2.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        g2.drawImage(img, 0, 0, w, h, null);
        g2.dispose();
        return bi;
    }

    public static void openInBrowser(String url) {
        try {
            Desktop.getDesktop().browse(new URI(url));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static boolean isDefaultTextBackgroundDark() {
        Color color = UIManager.getColor("TextField.background");
        return (double)Color.RGBtoHSB(color.getRed(), color.getGreen(), color.getBlue(), new float[3])[2] < 0.5;
    }

    public static void updateChildrenUI(JComponent c) {
        c.updateUI();
        Component[] componentArray = c.getComponents();
        int n = componentArray.length;
        int n2 = 0;
        while (n2 < n) {
            Component c_ = componentArray[n2];
            if (c_ instanceof JComponent) {
                SyntheticaAddonsUtilities.updateChildrenUI((JComponent)c_);
            }
            ++n2;
        }
    }
}

