/*
 * Decompiled with CFR 0.152.
 */
package de.javasoft.syntheticaaddons;

import de.javasoft.plaf.synthetica.SyntheticaLookAndFeel;
import de.javasoft.plaf.synthetica.painter.SyntheticaBasicIconPainter;
import de.javasoft.syntheticaaddons.SyntheticaAddonsUtilities;
import java.awt.Color;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.GeneralPath;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.MenuSelectionManager;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.plaf.InsetsUIResource;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.metal.MetalLookAndFeel;
import javax.swing.plaf.synth.SynthContext;

public class SimpleDropDownButton
extends JButton
implements PropertyChangeListener,
PopupMenuListener,
ChangeListener {
    private static final long serialVersionUID = 9122091784625141251L;
    public static final String uiClassID = "SimpleDropDownButtonUI";
    private static Object HIDE_POPUP_KEY = new JComboBox().getClientProperty("doNotCancelPopup");
    protected JPopupMenu popup;
    private int arrowIconSpace;
    private boolean useLargeArrowIcon = false;
    private Icon arrowIcon = null;
    private Border originalBorder;
    private int hPos = 4;
    private int vPos = 0;
    private boolean openPopupByArrow = false;
    private boolean arrowVisible = true;
    private int horizontalPopupMenuPosition = 2;
    private int verticalPopupMenuPosition = 3;
    private boolean initDone;
    private boolean rolloverEnabled;

    public SimpleDropDownButton() {
        this.init();
    }

    public SimpleDropDownButton(Action a) {
        super(a);
        this.init();
    }

    public SimpleDropDownButton(String text) {
        super(text);
        this.init();
    }

    public SimpleDropDownButton(Icon icon) {
        super(icon);
        this.init();
    }

    public SimpleDropDownButton(String text, Icon icon) {
        super(text, icon);
        this.init();
    }

    private void init() {
        this.updateArrowIcon();
        this.setArrowIconSpace(SyntheticaLookAndFeel.getInt((String)"SimpleDropDownButton.arrowIconGap", (Component)this, (int)4, (boolean)true));
        this.putClientProperty("doNotCancelPopup", HIDE_POPUP_KEY);
        this.addPropertyChangeListener(this);
        this.getModel().addChangeListener(this);
        this.getInputMap().put(KeyStroke.getKeyStroke(40, 512), "openPopup");
        this.getActionMap().put("openPopup", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                if (SimpleDropDownButton.this.getPopupMenu().isVisible()) {
                    SimpleDropDownButton.this.popup.setVisible(false);
                } else if (!SimpleDropDownButton.this.getOpenPopupByArrow() || SimpleDropDownButton.this.getOpenPopupByArrow() && SimpleDropDownButton.this.isMouseInArrowArea()) {
                    int x;
                    JComponent c = (JComponent)evt.getSource();
                    MenuSelectionManager.defaultManager().clearSelectedPath();
                    c.requestFocusInWindow();
                    if (SyntheticaLookAndFeel.isToplevelPopupMenu((JPopupMenu)SimpleDropDownButton.this.popup)) {
                        SimpleDropDownButton.this.popup.updateUI();
                    }
                    SimpleDropDownButton.this.popup.addPopupMenuListener(SimpleDropDownButton.this);
                    boolean leftAligned = SimpleDropDownButton.this.horizontalPopupMenuPosition == 2;
                    boolean startAligned = !(c.getComponentOrientation().isLeftToRight() ^ leftAligned);
                    int n = x = startAligned ? 0 : SimpleDropDownButton.this.getWidth() - SimpleDropDownButton.this.popup.getPreferredSize().width;
                    if (SimpleDropDownButton.this.horizontalPopupMenuPosition == 0) {
                        x = SimpleDropDownButton.this.getWidth() / 2 - SimpleDropDownButton.this.popup.getPreferredSize().width / 2;
                    }
                    int y = SwingUtilities.convertPoint((Component)c, (int)0, (int)c.getHeight(), (Component)SimpleDropDownButton.this).y;
                    if (SimpleDropDownButton.this.verticalPopupMenuPosition == 1) {
                        y -= c.getHeight() + SimpleDropDownButton.this.popup.getPreferredSize().height;
                    }
                    int xOffset = SyntheticaLookAndFeel.getInt((String)"DropDownButton.popup.xOffset", (Component)SimpleDropDownButton.this, (int)0, (boolean)true);
                    int yOffset = SyntheticaLookAndFeel.getInt((String)"DropDownButton.popup.yOffset", (Component)SimpleDropDownButton.this, (int)0, (boolean)true);
                    SimpleDropDownButton.this.popup.show(SimpleDropDownButton.this, x + (startAligned ? xOffset : -xOffset), y + yOffset);
                }
            }
        });
        this.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SimpleDropDownButton.this.getActionMap().get("openPopup").actionPerformed(evt);
            }
        });
        this.initDone = true;
    }

    public void setPreferredHorizontalPopupMenuPosition(int position) {
        this.horizontalPopupMenuPosition = position;
    }

    public int getPreferredHorizontalPopupMenuPosition() {
        return this.horizontalPopupMenuPosition;
    }

    public void setPreferredVerticalPopupMenuPosition(int position) {
        this.verticalPopupMenuPosition = position;
    }

    public int getPreferredVerticalPopupMenuPosition() {
        return this.verticalPopupMenuPosition;
    }

    public boolean isMouseInArrowArea() {
        Point p = MouseInfo.getPointerInfo().getLocation();
        SwingUtilities.convertPointFromScreen(p, this);
        return this.isMouseInArrowArea(p);
    }

    private boolean isMouseInArrowArea(Point mousePosition) {
        Rectangle innerRect = SwingUtilities.calculateInnerArea(this, null);
        if (innerRect.contains(mousePosition)) {
            return false;
        }
        Border border = this.getArrowBorder();
        if (border != null) {
            Insets arrowInsets = border.getBorderInsets(this);
            innerRect.x -= arrowInsets.left;
            innerRect.y -= arrowInsets.top;
            innerRect.width += arrowInsets.left + arrowInsets.right;
            innerRect.height += arrowInsets.top + arrowInsets.bottom;
            return innerRect.contains(mousePosition);
        }
        return false;
    }

    @Override
    public void updateUI() {
        super.updateUI();
        if (this.initDone) {
            SyntheticaAddonsUtilities.updateChildrenUI(this.getPopupMenu());
        }
        this.updateArrowIcon();
        this.originalBorder = this.getBorder();
        if (this.isArrowVisible()) {
            this.installBorder(this.isToolBarButton());
        }
    }

    private boolean isToolBarButton() {
        return this.getParent() != null && this.getParent() instanceof JToolBar;
    }

    private void installBorder(boolean isToolBarButton) {
        Border border = this.originalBorder;
        border = UIManager.getLookAndFeel() instanceof MetalLookAndFeel && isToolBarButton && border instanceof CompoundBorder ? new CompoundArrowBorder(new CompoundBorder(((CompoundBorder)border).getOutsideBorder(), SyntheticaLookAndFeel.getInstance().createEmptyBorder(3, 3, 3, 3, true)), new ArrowBorder()) : ("Windows".equals(UIManager.getLookAndFeel().getID()) && isToolBarButton ? new CompoundArrowBorder(SyntheticaLookAndFeel.getInstance().createEmptyBorder(3, 3, 3, 3, true), new ArrowBorder()) : new CompoundArrowBorder(border, new ArrowBorder()));
        Insets margin = SyntheticaLookAndFeel.getInsets((String)"SimpleDropDownButton.margin", (Component)this, (boolean)true);
        if (margin != null) {
            this.setMargin(new InsetsUIResource(margin.top, margin.left, margin.bottom, margin.right));
        }
        this.setBorder(border);
    }

    private Border getArrowBorder() {
        Border border = this.getBorder();
        if (border instanceof CompoundArrowBorder) {
            return ((CompoundArrowBorder)border).getInsideBorder();
        }
        return null;
    }

    private void updateArrowIcon() {
        Icon icon = this.getArrowIcon();
        if ((icon == null || icon instanceof UIResource) && UIManager.getLookAndFeel() instanceof SyntheticaLookAndFeel) {
            boolean isToolBarChild = this.getParent() instanceof JToolBar;
            String key = "Synthetica.arrow.down";
            if (!isToolBarChild && this.getModel().isPressed() && SyntheticaLookAndFeel.get((String)"DropDownButton.pressed.arrowIcon", (Component)this) != null) {
                key = "DropDownButton.pressed.arrowIcon";
            } else if (!isToolBarChild && this.getModel().isRollover() && SyntheticaLookAndFeel.get((String)"DropDownButton.hover.arrowIcon", (Component)this) != null) {
                key = "DropDownButton.hover.arrowIcon";
            } else if (isToolBarChild && this.getModel().isPressed() && SyntheticaLookAndFeel.get((String)"DropDownButton.pressed.toolBarArrowIcon", (Component)this) != null) {
                key = "DropDownButton.pressed.toolBarArrowIcon";
            } else if (isToolBarChild && this.getModel().isRollover() && SyntheticaLookAndFeel.get((String)"DropDownButton.hover.toolBarArrowIcon", (Component)this) != null) {
                key = "DropDownButton.hover.toolBarArrowIcon";
            } else if (isToolBarChild && SyntheticaLookAndFeel.get((String)"DropDownButton.toolBarArrowIcon", (Component)this) != null) {
                key = "DropDownButton.toolBarArrowIcon";
            } else if (SyntheticaLookAndFeel.get((String)"DropDownButton.arrowIcon", (Component)this) != null) {
                key = "DropDownButton.arrowIcon";
            } else if (this.getUseSmallArrowIcon() && UIManager.getString("Synthetica.arrow.8x8.down") != null) {
                key = "Synthetica.arrow.8x8.down";
            }
            icon = SyntheticaLookAndFeel.loadIcon((String)key, (Component)this, (boolean)true);
        } else if (icon == null || icon instanceof UIResource) {
            icon = new SyntheticaBasicIconPainter(null, SyntheticaLookAndFeel.getInstance().scaleInteger(Integer.valueOf(9)), SyntheticaLookAndFeel.getInstance().scaleInteger(Integer.valueOf(4))){

                public void paint2D(SynthContext sc, Graphics2D g2, float x, float y, float w, float h) {
                    if (SimpleDropDownButton.this.isEnabled()) {
                        g2.setPaint(Color.BLACK);
                    } else {
                        g2.setPaint(Color.GRAY);
                    }
                    y = 0.0f;
                    x = 0.0f;
                    GeneralPath path = new GeneralPath();
                    path.moveTo(x, y);
                    path.lineTo(x + w / 2.0f, y + h);
                    path.lineTo(x + w, y);
                    g2.fill(path);
                }
            };
        }
        this.arrowIcon = icon;
    }

    public JPopupMenu getPopupMenu() {
        if (this.popup == null) {
            this.popup = this.createPopupMenu();
        }
        return this.popup;
    }

    public void setPopupMenu(JPopupMenu popup) {
        this.popup = popup;
    }

    protected JPopupMenu createPopupMenu() {
        return new JPopupMenu();
    }

    public void setArrowVisible(boolean visible) {
        this.arrowVisible = visible;
        if (visible) {
            this.installBorder(this.isToolBarButton());
        } else {
            this.setBorder(this.originalBorder);
        }
    }

    public boolean isArrowVisible() {
        return this.arrowVisible;
    }

    public void setOpenPopupByArrow(boolean value) {
        this.openPopupByArrow = value;
    }

    public boolean getOpenPopupByArrow() {
        return this.openPopupByArrow;
    }

    public void setUseSmallArrowIcon(boolean value) {
        boolean oldValue = !this.useLargeArrowIcon;
        this.useLargeArrowIcon = !value;
        this.firePropertyChange("useSmallArrowIcon", oldValue, value);
    }

    public boolean getUseSmallArrowIcon() {
        return !this.useLargeArrowIcon;
    }

    public void setArrowIcon(Icon icon) {
        Icon oldValue = this.arrowIcon;
        this.arrowIcon = icon;
        this.firePropertyChange("arrowIcon", oldValue, icon);
    }

    public Icon getArrowIcon() {
        return this.arrowIcon;
    }

    public void setArrowIconSpace(int space) {
        this.arrowIconSpace = space;
    }

    public int getArrowIconSpace() {
        return this.arrowIconSpace;
    }

    public void setHorizontalArrowPosition(int position) {
        int oldValue = this.hPos;
        this.hPos = position;
        this.firePropertyChange("arrowPosition", oldValue, position);
    }

    public int getHorizontalArrowPosition() {
        return this.hPos;
    }

    public void setVerticalArrowPosition(int position) {
        int oldValue = this.vPos;
        this.vPos = position;
        this.firePropertyChange("arrowPosition", oldValue, position);
    }

    public int getVerticalArrowPosition() {
        return this.vPos;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        String name = evt.getPropertyName();
        if (name.equals("useSmallArrowIcon") || name.equals("arrowIcon")) {
            this.updateArrowIcon();
            return;
        }
        if (name.equals("arrowPosition")) {
            return;
        }
        if (name.equals("ancestor")) {
            this.updateArrowIcon();
            if (this.isArrowVisible()) {
                this.installBorder(((Component)evt.getSource()).getParent() instanceof JToolBar);
            }
            return;
        }
        if (name.equals("componentOrientation")) {
            this.getPopupMenu().applyComponentOrientation((ComponentOrientation)evt.getNewValue());
            return;
        }
        if (name.equals("name")) {
            if (this.getBorder() instanceof UIResource) {
                this.setBorder(null);
                this.updateUI();
            }
            return;
        }
    }

    @Override
    public void stateChanged(ChangeEvent evt) {
        this.updateArrowIcon();
    }

    @Override
    public void popupMenuWillBecomeVisible(PopupMenuEvent evt) {
        this.rolloverEnabled = this.isRolloverEnabled();
        this.setRolloverEnabled(false);
        if (this.rolloverEnabled) {
            this.getModel().setRollover(true);
        }
    }

    @Override
    public void popupMenuWillBecomeInvisible(PopupMenuEvent evt) {
        this.setRolloverEnabled(true);
        if (this.rolloverEnabled) {
            this.getModel().setRollover(false);
        }
        ((JPopupMenu)evt.getSource()).removePopupMenuListener(this);
        this.setRolloverEnabled(this.rolloverEnabled);
    }

    @Override
    public void popupMenuCanceled(PopupMenuEvent evt) {
    }

    private class ArrowBorder
    implements Border {
        private ArrowBorder() {
        }

        @Override
        public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
            this.paintArrow(g, x, y, width, height);
        }

        private void paintArrow(Graphics g, int x, int y, int w, int h) {
            int arrowX = 0;
            int arrowY = 0;
            switch (SimpleDropDownButton.this.getHorizontalArrowPosition()) {
                case 4: {
                    arrowX = x + w - SimpleDropDownButton.this.getArrowIcon().getIconWidth();
                    break;
                }
                case 0: {
                    arrowX = x + (w - SimpleDropDownButton.this.getArrowIcon().getIconWidth()) / 2;
                    break;
                }
                default: {
                    arrowX = x;
                }
            }
            switch (SimpleDropDownButton.this.getVerticalArrowPosition()) {
                case 3: {
                    arrowY = y + h - SimpleDropDownButton.this.getArrowIcon().getIconHeight();
                    break;
                }
                case 0: {
                    arrowY = y + (h - SimpleDropDownButton.this.getArrowIcon().getIconHeight()) / 2;
                    break;
                }
                default: {
                    arrowY = y;
                }
            }
            int offset = SyntheticaLookAndFeel.getInt((String)"Button.textShiftOffset", (Component)SimpleDropDownButton.this);
            if (!SimpleDropDownButton.this.getModel().isArmed() || !SimpleDropDownButton.this.getModel().isPressed()) {
                offset = 0;
            }
            SimpleDropDownButton.this.getArrowIcon().paintIcon(SimpleDropDownButton.this, g, arrowX + offset, arrowY + offset);
        }

        @Override
        public Insets getBorderInsets(Component c) {
            if (SimpleDropDownButton.this.hPos == 2) {
                return new Insets(0, SimpleDropDownButton.this.getArrowIcon().getIconWidth() + SimpleDropDownButton.this.getArrowIconSpace(), 0, 0);
            }
            if (SimpleDropDownButton.this.hPos == 4) {
                return new Insets(0, 0, 0, SimpleDropDownButton.this.getArrowIcon().getIconWidth() + SimpleDropDownButton.this.getArrowIconSpace());
            }
            if (SimpleDropDownButton.this.vPos == 1) {
                return new Insets(SimpleDropDownButton.this.getArrowIcon().getIconHeight() + SimpleDropDownButton.this.getArrowIconSpace(), 0, 0, 0);
            }
            if (SimpleDropDownButton.this.vPos == 3) {
                return new Insets(0, 0, SimpleDropDownButton.this.getArrowIcon().getIconHeight() + SimpleDropDownButton.this.getArrowIconSpace(), 0);
            }
            return new Insets(0, 0, 0, 0);
        }

        @Override
        public boolean isBorderOpaque() {
            return false;
        }
    }

    private static class CompoundArrowBorder
    extends CompoundBorder
    implements UIResource {
        private static final long serialVersionUID = -7456112460542420750L;

        public CompoundArrowBorder(Border outsideBorder, Border insideBorder) {
            super(outsideBorder, insideBorder);
        }
    }
}

