/*
 * Decompiled with CFR 0.152.
 */
package de.javasoft.syntheticaaddons;

import de.javasoft.plaf.synthetica.SyntheticaLookAndFeel;
import de.javasoft.syntheticaaddons.SyntheticaAddons;
import de.javasoft.syntheticaaddons.ui.MultiLevelBarUI;
import de.javasoft.syntheticaaddons.ui.addons.MultiLevelBarAddon;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jdesktop.swingx.plaf.AbstractComponentAddon;
import org.jdesktop.swingx.plaf.ComponentAddon;
import org.jdesktop.swingx.plaf.LookAndFeelAddons;

public class MultiLevelBar
extends JPanel {
    private static final long serialVersionUID = 7397679706123802445L;
    public static final String uiClassID = "MultiLevelBarUI";
    private ArrayList<BarLevel> levels = new ArrayList();
    private String text;
    private Insets textInsets = SyntheticaLookAndFeel.getInstance().scaleInsets(4, 4, 4, 4);
    private int verticalAlignment = 0;
    private int horizontalAlignment = 0;
    private boolean useTextDropShadow;
    protected static AbstractComponentAddon addon = new MultiLevelBarAddon();

    static {
        SyntheticaAddons.contribute((ComponentAddon)addon);
    }

    public MultiLevelBar(String text, String imagePath, Class<?> resourceBase, Insets insets, int maxLevel, boolean useTextDropShadow) {
        this.text = text;
        this.useTextDropShadow = useTextDropShadow;
        this.addBar(this.getClass().getName(), imagePath, resourceBase, insets, maxLevel);
        this.setPreferredSize(SyntheticaLookAndFeel.getInstance().scaleDimension(146, 24));
    }

    @Override
    public String getUIClassID() {
        return uiClassID;
    }

    @Override
    public void updateUI() {
        this.setUI(LookAndFeelAddons.getUI((JComponent)this, MultiLevelBarUI.class));
        if (this.getLevels() != null) {
            for (BarLevel barLevel : this.getLevels()) {
                SyntheticaLookAndFeel.getInstance().registerImageResourceBase(barLevel.getResourceBase(), barLevel.getImagePath());
            }
        }
    }

    public void addBar(String levelName, String imagePath, Class<?> resourceBase, Insets insets, int level) {
        this.levels.add(new BarLevel(levelName, imagePath, resourceBase, insets, level));
    }

    public void setValue(String levelName, int level) {
        this.getLevelByName(levelName).level = level;
    }

    public BarLevel getLevelByName(String name) {
        for (BarLevel bl : this.levels) {
            if (!bl.name.equals(name)) continue;
            return bl;
        }
        return null;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    public Insets getTextInsets() {
        return this.textInsets;
    }

    public void setTextInsets(Insets textInsets) {
        this.textInsets = SyntheticaLookAndFeel.getInstance().scaleInsets(textInsets);
    }

    public int getHorizontalAlignment() {
        return this.horizontalAlignment;
    }

    public void setHorizontalAlignment(int alignment) {
        this.horizontalAlignment = alignment;
    }

    public int getVerticalAlignment() {
        return this.verticalAlignment;
    }

    public void setVerticalAlignment(int alignment) {
        this.verticalAlignment = alignment;
    }

    public boolean getUseTextDropShadow() {
        return this.useTextDropShadow;
    }

    public void setUseTextDropShadow(boolean useTextDropShadow) {
        this.useTextDropShadow = useTextDropShadow;
    }

    public List<BarLevel> getLevels() {
        return this.levels;
    }

    public static class BarLevel {
        private String name;
        private String imagePath;
        Class<?> resourceBase;
        private Insets insets;
        private int level;

        BarLevel(String levelName, String imagePath, Class<?> resourceBase, Insets insets, int level) {
            this.name = levelName;
            this.imagePath = imagePath;
            this.resourceBase = resourceBase;
            this.insets = SyntheticaLookAndFeel.getInstance().scaleInsets(insets);
            this.level = level;
            SyntheticaLookAndFeel.getInstance().registerImageResourceBase(resourceBase, imagePath);
        }

        public String getImagePath() {
            return this.imagePath;
        }

        public void setImagePath(String imagePath) {
            this.imagePath = imagePath;
        }

        public Class<?> getResourceBase() {
            return this.resourceBase;
        }

        public void setResourceBase(Class<?> resourceBase) {
            this.resourceBase = resourceBase;
        }

        public Insets getInsets() {
            return this.insets;
        }

        public void setInsets(Insets insets) {
            this.insets = SyntheticaLookAndFeel.getInstance().scaleInsets(insets);
        }

        public int getLevel() {
            return this.level;
        }

        public void setLevel(int level) {
            this.level = level;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }
    }
}

