/*
 * Decompiled with CFR 0.152.
 */
package de.javasoft.syntheticaaddons;

import de.javasoft.plaf.synthetica.SyntheticaLookAndFeel;
import de.javasoft.plaf.synthetica.painter.SyntheticaBasicIconPainter;
import de.javasoft.syntheticaaddons.SyntheticaAddons;
import de.javasoft.syntheticaaddons.SyntheticaAddonsUtilities;
import de.javasoft.syntheticaaddons.ui.DropDownButtonUI;
import de.javasoft.syntheticaaddons.ui.addons.DropDownButtonAddon;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.geom.GeneralPath;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.reflect.Method;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.JToolBar;
import javax.swing.UIManager;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.plaf.ButtonUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.synth.SynthContext;
import org.jdesktop.swingx.plaf.AbstractComponentAddon;
import org.jdesktop.swingx.plaf.ComponentAddon;
import org.jdesktop.swingx.plaf.LookAndFeelAddons;

public class DropDownButton
extends JButton
implements PopupMenuListener,
PropertyChangeListener {
    private static final long serialVersionUID = 1285169006195587840L;
    public static final String uiClassID = "DropDownButtonUI";
    private static Object HIDE_POPUP_KEY = new JComboBox().getClientProperty("doNotCancelPopup");
    private JButton mainButton;
    private JButton arrowButton;
    protected JPopupMenu popup;
    private int arrowIconSpace;
    private boolean useLargeArrowIcon = false;
    private Icon arrowIcon = null;
    private int horizontalPopupMenuPosition = 2;
    private int verticalPopupMenuPosition = 3;
    private MouseListener mainButtonMouseListener;
    private MouseListener arrowButtonMouseListener;
    private boolean initDone;
    protected static AbstractComponentAddon addon = new DropDownButtonAddon();

    static {
        SyntheticaAddons.contribute((ComponentAddon)addon);
    }

    public DropDownButton(Action a) {
        super(a);
        this.init();
    }

    public DropDownButton(String text) {
        this.getMainButton().setText(text);
        this.init();
    }

    public DropDownButton(Icon icon) {
        this.getMainButton().setIcon(icon);
        this.init();
    }

    public DropDownButton(String text, Icon icon) {
        this.getMainButton().setText(text);
        this.getMainButton().setIcon(icon);
        this.init();
    }

    private void init() {
        this.getArrowButton().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                if (DropDownButton.this.getPopupMenu().isVisible()) {
                    DropDownButton.this.popup.setVisible(false);
                } else {
                    int x;
                    if (DropDownButton.this.getMainButton().getModel().isArmed() && DropDownButton.this.getMainButton().getModel().isPressed()) {
                        return;
                    }
                    if (SyntheticaLookAndFeel.isToplevelPopupMenu((JPopupMenu)DropDownButton.this.popup)) {
                        DropDownButton.this.popup.updateUI();
                    }
                    DropDownButton.this.popup.addPopupMenuListener(DropDownButton.this);
                    boolean leftAligned = DropDownButton.this.horizontalPopupMenuPosition == 2;
                    boolean startAligned = !(DropDownButton.this.getComponentOrientation().isLeftToRight() ^ leftAligned);
                    int n = x = startAligned ? 0 : DropDownButton.this.getWidth() - DropDownButton.this.popup.getPreferredSize().width;
                    if (DropDownButton.this.horizontalPopupMenuPosition == 0) {
                        x = DropDownButton.this.getWidth() / 2 - DropDownButton.this.popup.getPreferredSize().width / 2;
                    }
                    int y = DropDownButton.this.getHeight();
                    if (DropDownButton.this.verticalPopupMenuPosition == 1) {
                        y -= DropDownButton.this.getHeight() + DropDownButton.this.popup.getPreferredSize().height;
                    }
                    int xOffset = SyntheticaLookAndFeel.getInt((String)"DropDownButton.popup.xOffset", (Component)DropDownButton.this, (int)0, (boolean)true);
                    int yOffset = SyntheticaLookAndFeel.getInt((String)"DropDownButton.popup.yOffset", (Component)DropDownButton.this, (int)0, (boolean)true);
                    DropDownButton.this.popup.show(DropDownButton.this, x + (startAligned ? xOffset : -xOffset), y + yOffset);
                }
            }
        });
        this.getArrowButton().putClientProperty("doNotCancelPopup", HIDE_POPUP_KEY);
        this.addPropertyChangeListener(this);
        this.initDone = true;
    }

    @Override
    public String getUIClassID() {
        return uiClassID;
    }

    @Override
    public void updateUI() {
        this.setUI((ButtonUI)LookAndFeelAddons.getUI((JComponent)this, DropDownButtonUI.class));
        if (this.initDone) {
            SyntheticaAddonsUtilities.updateChildrenUI(this.getPopupMenu());
        }
    }

    @Override
    public void addActionListener(ActionListener l) {
        this.getMainButton().addActionListener(l);
    }

    @Override
    public void removeActionListener(ActionListener l) {
        this.getMainButton().removeActionListener(l);
    }

    @Override
    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    @Override
    public Dimension getPreferredSize() {
        if (this.isPreferredSizeSet()) {
            return super.getPreferredSize();
        }
        Dimension dim1 = this.getMainButton().getPreferredSize();
        Dimension dim2 = this.getArrowButton().getPreferredSize();
        return new Dimension(dim1.width + dim2.width, Math.max(dim1.height, dim2.height));
    }

    public JButton getMainButton() {
        if (this.mainButton == null) {
            this.mainButton = new JButton(){
                private static final long serialVersionUID = 1983457115217812336L;

                @Override
                public void updateUI() {
                    this.removeMouseListener(DropDownButton.this.getMainButtonMouseListener());
                    super.updateUI();
                    this.addMouseListener(DropDownButton.this.getMainButtonMouseListener());
                }
            };
            this.mainButton.putClientProperty("JButton.segmentPosition", "first");
        }
        return this.mainButton;
    }

    public JButton getArrowButton() {
        if (this.arrowButton == null) {
            this.arrowButton = new JButton(){
                private static final long serialVersionUID = -1258068774098394796L;

                @Override
                public void updateUI() {
                    this.removeMouseListener(DropDownButton.this.getArrowButtonMouseListener());
                    super.updateUI();
                    this.addMouseListener(DropDownButton.this.getArrowButtonMouseListener());
                    if (DropDownButton.this.arrowButton != null) {
                        DropDownButton.this.updateArrowButton(DropDownButton.this.arrowButton);
                    }
                }
            };
            this.setArrowIconSpace(SyntheticaLookAndFeel.getInt((String)"DropDownButton.arrowIconGap", (Component)this, (int)4, (boolean)true));
            this.installArrowIcon(this.arrowButton);
            this.arrowButton.putClientProperty("JButton.segmentPosition", "last");
        }
        return this.arrowButton;
    }

    public JPopupMenu getPopupMenu() {
        if (this.popup == null) {
            this.popup = this.createPopupMenu();
        }
        return this.popup;
    }

    protected JPopupMenu createPopupMenu() {
        return new JPopupMenu();
    }

    private void updateArrowButton(JButton arrowButton) {
        this.installArrowIcon(arrowButton);
        Insets insets = SyntheticaLookAndFeel.getInsets((String)"DropDownButton.margin", (Component)this, (boolean)false, (boolean)true);
        if (!this.getComponentOrientation().isLeftToRight()) {
            insets = new Insets(insets.top, insets.right, insets.bottom, insets.left);
        }
        arrowButton.setMargin(insets);
        arrowButton.setPreferredSize(new Dimension(this.getArrowIconWidth(), this.getMainButton().getPreferredSize().height));
        arrowButton.setMaximumSize(new Dimension(this.getArrowIconWidth(), this.getMainButton().getPreferredSize().height));
    }

    private void installArrowIcon(JButton arrowButton) {
        Icon defaultIcon = this.getArrowIcon();
        Icon arrowIcon = defaultIcon;
        if ((arrowIcon == null || arrowIcon instanceof UIResource) && UIManager.getLookAndFeel() instanceof SyntheticaLookAndFeel) {
            String key = "Synthetica.arrow.down";
            if (this.getParent() instanceof JToolBar && SyntheticaLookAndFeel.get((String)"DropDownButton.toolBarArrowIcon", (Component)this) != null) {
                key = "DropDownButton.toolBarArrowIcon";
            } else if (SyntheticaLookAndFeel.get((String)"DropDownButton.arrowIcon", (Component)this) != null) {
                key = "DropDownButton.arrowIcon";
            } else if (this.getUseSmallArrowIcon() && UIManager.getString("Synthetica.arrow.8x8.down") != null) {
                key = "Synthetica.arrow.8x8.down";
            }
            arrowIcon = SyntheticaLookAndFeel.loadIcon((String)key, (Component)this, (boolean)true);
        } else if (arrowIcon == null || arrowIcon instanceof UIResource) {
            arrowIcon = new SyntheticaBasicIconPainter(null, SyntheticaLookAndFeel.getInstance().scaleInteger(Integer.valueOf(9)), SyntheticaLookAndFeel.getInstance().scaleInteger(Integer.valueOf(4))){

                public void paint2D(SynthContext sc, Graphics2D g2, float x, float y, float w, float h) {
                    if (DropDownButton.this.isEnabled()) {
                        g2.setPaint(Color.BLACK);
                    } else {
                        g2.setPaint(Color.GRAY);
                    }
                    y = 0.0f;
                    x = 0.0f;
                    GeneralPath path = new GeneralPath();
                    path.moveTo(x, y);
                    path.lineTo(x + w / 2.0f, y + h);
                    path.lineTo(x + w, y);
                    g2.fill(path);
                }
            };
        }
        arrowButton.setIcon(arrowIcon);
        Icon hoverIcon = this.getRolloverIcon();
        if (arrowIcon instanceof UIResource && (hoverIcon == null || hoverIcon instanceof UIResource) && UIManager.getLookAndFeel() instanceof SyntheticaLookAndFeel) {
            if (this.getParent() instanceof JToolBar) {
                if (SyntheticaLookAndFeel.get((String)"DropDownButton.hover.toolBarArrowIcon", (Component)this) != null) {
                    hoverIcon = SyntheticaLookAndFeel.loadIcon((String)"DropDownButton.hover.toolBarArrowIcon", (Component)this, (boolean)true);
                    arrowButton.setRolloverIcon(hoverIcon);
                }
            } else if (SyntheticaLookAndFeel.get((String)"DropDownButton.hover.arrowIcon", (Component)this) != null) {
                hoverIcon = SyntheticaLookAndFeel.loadIcon((String)"DropDownButton.hover.arrowIcon", (Component)this, (boolean)true);
                arrowButton.setRolloverIcon(hoverIcon);
            }
        } else if (hoverIcon == null || hoverIcon instanceof UIResource) {
            arrowButton.setRolloverIcon(null);
        }
        Icon pressedIcon = this.getPressedIcon();
        if (arrowIcon instanceof UIResource && (pressedIcon == null || pressedIcon instanceof UIResource) && UIManager.getLookAndFeel() instanceof SyntheticaLookAndFeel) {
            if (this.getParent() instanceof JToolBar) {
                if (SyntheticaLookAndFeel.get((String)"DropDownButton.pressed.toolBarArrowIcon", (Component)this) != null) {
                    pressedIcon = SyntheticaLookAndFeel.loadIcon((String)"DropDownButton.pressed.toolBarArrowIcon", (Component)this, (boolean)true);
                    arrowButton.setPressedIcon(pressedIcon);
                }
            } else if (SyntheticaLookAndFeel.get((String)"DropDownButton.pressed.arrowIcon", (Component)this) != null) {
                pressedIcon = SyntheticaLookAndFeel.loadIcon((String)"DropDownButton.pressed.arrowIcon", (Component)this, (boolean)true);
                arrowButton.setPressedIcon(pressedIcon);
            }
        } else if (pressedIcon == null || pressedIcon instanceof UIResource) {
            arrowButton.setPressedIcon(null);
        }
    }

    public void setPreferredHorizontalPopupMenuPosition(int position) {
        this.horizontalPopupMenuPosition = position;
    }

    public int getPreferredHorizontalPopupMenuPosition() {
        return this.horizontalPopupMenuPosition;
    }

    public void setPreferredVerticalPopupMenuPosition(int position) {
        this.verticalPopupMenuPosition = position;
    }

    public int getPreferredVerticalPopupMenuPosition() {
        return this.verticalPopupMenuPosition;
    }

    private MouseListener getMainButtonMouseListener() {
        if (this.mainButtonMouseListener == null) {
            this.mainButtonMouseListener = new MouseAdapter(){

                @Override
                public void mouseEntered(MouseEvent evt) {
                    DropDownButton.this.getArrowButton().getModel().setRollover(true);
                }

                @Override
                public void mouseExited(MouseEvent evt) {
                    if (DropDownButton.this.getPopupMenu().isVisible()) {
                        DropDownButton.this.getMainButton().getModel().setRollover(true);
                        DropDownButton.this.getArrowButton().getModel().setRollover(true);
                        return;
                    }
                    DropDownButton.this.getArrowButton().getModel().setArmed(false);
                    DropDownButton.this.getArrowButton().getModel().setRollover(false);
                }

                @Override
                public void mousePressed(MouseEvent evt) {
                    DropDownButton.this.getArrowButton().getModel().setArmed(true);
                    DropDownButton.this.getArrowButton().getModel().setPressed(true);
                }

                @Override
                public void mouseReleased(MouseEvent evt) {
                    if (DropDownButton.this.getPopupMenu().isVisible()) {
                        return;
                    }
                    DropDownButton.this.getArrowButton().getModel().setArmed(false);
                    DropDownButton.this.getArrowButton().getModel().setPressed(false);
                }
            };
        }
        return this.mainButtonMouseListener;
    }

    private MouseListener getArrowButtonMouseListener() {
        if (this.arrowButtonMouseListener == null) {
            this.arrowButtonMouseListener = new MouseAdapter(){

                @Override
                public void mouseEntered(MouseEvent evt) {
                    DropDownButton.this.getMainButton().getModel().setRollover(true);
                }

                @Override
                public void mouseExited(MouseEvent evt) {
                    if (DropDownButton.this.getPopupMenu().isVisible()) {
                        DropDownButton.this.getMainButton().getModel().setRollover(true);
                        DropDownButton.this.getArrowButton().getModel().setRollover(true);
                    } else {
                        DropDownButton.this.getMainButton().getModel().setRollover(false);
                    }
                }

                @Override
                public void mousePressed(MouseEvent evt) {
                    DropDownButton.this.getMainButton().getModel().setRollover(true);
                }

                @Override
                public void mouseReleased(MouseEvent evt) {
                }
            };
        }
        return this.arrowButtonMouseListener;
    }

    public void setUseSmallArrowIcon(boolean value) {
        boolean oldValue = !this.useLargeArrowIcon;
        this.useLargeArrowIcon = !value;
        this.firePropertyChange("useSmallArrowIcon", oldValue, value);
    }

    public boolean getUseSmallArrowIcon() {
        return !this.useLargeArrowIcon;
    }

    public void setArrowIcon(Icon icon) {
        Icon oldValue = this.arrowIcon;
        this.arrowIcon = icon;
        this.firePropertyChange("arrowIcon", oldValue, icon);
    }

    public Icon getArrowIcon() {
        return this.arrowIcon;
    }

    public int getArrowIconWidth() {
        JButton b = this.getArrowButton();
        if (b.getIcon() == null) {
            return 0;
        }
        int w = b.getIcon().getIconWidth() + b.getMargin().left + b.getMargin().right;
        return Math.max(SyntheticaLookAndFeel.getInstance().scaleInteger(Integer.valueOf(14)), w + this.arrowIconSpace);
    }

    public void setArrowIconSpace(int space) {
        this.arrowIconSpace = space;
    }

    public int getArrowIconSpace() {
        return this.arrowIconSpace;
    }

    @Override
    public void popupMenuWillBecomeVisible(PopupMenuEvent evt) {
        this.getMainButton().getModel().setRollover(true);
        this.getArrowButton().getModel().setRollover(true);
    }

    @Override
    public void popupMenuWillBecomeInvisible(PopupMenuEvent evt) {
        this.getMainButton().getModel().setRollover(false);
        this.getArrowButton().getModel().setRollover(false);
        ((JPopupMenu)evt.getSource()).removePopupMenuListener(this);
    }

    @Override
    public void popupMenuCanceled(PopupMenuEvent evt) {
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        String name = evt.getPropertyName();
        DropDownButton dropDownButton = (DropDownButton)evt.getSource();
        JButton mainButton = this.getMainButton();
        JButton arrowButton = this.getArrowButton();
        if (name.equals("ancestor")) {
            if (dropDownButton.getParent() instanceof JToolBar) {
                JToolBar tb = new JToolBar(){

                    @Override
                    public boolean isOpaque() {
                        return false;
                    }
                };
                tb.setName("DropDownButton.toolBar");
                tb.setFloatable(false);
                tb.setBorder(SyntheticaLookAndFeel.getInstance().createEmptyBorder(0, 0, 0, 0, true));
                tb.add(mainButton);
                tb.add(arrowButton);
                tb.putClientProperty("Synthetica.opaque", false);
                Component c = SyntheticaLookAndFeel.findComponent(JToolBar.class, (Container)dropDownButton);
                if (c != null) {
                    dropDownButton.remove(c);
                }
                dropDownButton.add(tb);
            } else {
                dropDownButton.setLayout(new BorderLayout(){

                    @Override
                    public Dimension maximumLayoutSize(Container target) {
                        return this.preferredLayoutSize(target);
                    }
                });
                dropDownButton.add(mainButton);
                dropDownButton.add((Component)arrowButton, "After");
            }
            this.updateArrowButton(arrowButton);
            return;
        }
        if (name.equals("useSmallArrowIcon") || name.equals("arrowIcon")) {
            this.updateArrowButton(arrowButton);
            return;
        }
        if (name.equals("componentOrientation")) {
            ComponentOrientation co = (ComponentOrientation)evt.getNewValue();
            this.getPopupMenu().applyComponentOrientation(co);
            mainButton.applyComponentOrientation(co);
            arrowButton.applyComponentOrientation(co);
            boolean rtl = !co.isLeftToRight();
            mainButton.putClientProperty("Synthetica.flipHorizontal", rtl);
            arrowButton.putClientProperty("Synthetica.flipHorizontal", rtl);
            this.updateArrowButton(arrowButton);
            return;
        }
        if (name.equals("Synthetica.style") || name.equals("name")) {
            mainButton.setName("" + evt.getNewValue());
            arrowButton.setName("" + evt.getNewValue());
        } else if (name.equals("JButton.segmentPosition")) {
            return;
        }
        Object value = evt.getNewValue();
        String methodName = "set" + name.substring(0, 1).toUpperCase() + name.substring(1);
        Class<Object> clazz = Object.class;
        if (value instanceof String) {
            clazz = String.class;
        } else if (value instanceof Action) {
            clazz = Action.class;
        } else if (value instanceof ActionMap) {
            clazz = ActionMap.class;
        } else if (value instanceof Boolean) {
            clazz = Boolean.TYPE;
        } else if (value instanceof Integer) {
            clazz = Integer.TYPE;
        } else if (value instanceof Float) {
            clazz = Float.TYPE;
        } else if (value instanceof Icon) {
            clazz = Icon.class;
        } else if (value instanceof Color) {
            clazz = Color.class;
        } else {
            return;
        }
        try {
            Method method = JButton.class.getMethod(methodName, clazz);
            method.invoke((Object)mainButton, value);
            if (name.equals("borderPainted") || name.equals("contentAreaFilled") || name.equals("focusable") || name.equals("enabled")) {
                method.invoke((Object)arrowButton, value);
            }
        }
        catch (NoSuchMethodException e) {
            return;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

