/*
 * Decompiled with CFR 0.152.
 */
package de.javasoft.syntheticaaddons;

import de.javasoft.syntheticaaddons.SyntheticaAddons;
import de.javasoft.syntheticaaddons.ui.addons.DateComboBoxAddon;
import de.javasoft.syntheticaaddons.ui.datecombobox.DateComboBoxMonthView;
import de.javasoft.syntheticaaddons.ui.datecombobox.DateComboBoxPopup;
import de.javasoft.syntheticaaddons.ui.datecombobox.DateComboBoxUI;
import java.awt.event.ActionListener;
import java.text.DateFormat;
import java.util.Date;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.text.DefaultFormatterFactory;
import org.jdesktop.swingx.calendar.DatePickerFormatter;
import org.jdesktop.swingx.plaf.AbstractComponentAddon;
import org.jdesktop.swingx.plaf.ComponentAddon;
import org.jdesktop.swingx.plaf.LookAndFeelAddons;

public class DateComboBox
extends JComboBox<Object> {
    private static final long serialVersionUID = -7632254110701579290L;
    public static final String uiClassID = "DateComboBoxUI";
    private DateFormat[] dateFormats;
    private DateComboBoxPopup popup;
    protected static AbstractComponentAddon addon = new DateComboBoxAddon();

    static {
        SyntheticaAddons.contribute((ComponentAddon)addon);
    }

    public DateComboBox() {
        this(new Date().getTime());
    }

    public DateComboBox(Date date) {
        this(date.getTime());
    }

    public DateComboBox(Long date) {
        this.setName("DateComboBox");
        this.setDateFormat(DateFormat.getDateInstance(2));
        this.setDate(date);
    }

    @Override
    public String getUIClassID() {
        return uiClassID;
    }

    @Override
    public void updateUI() {
        if (this.popup != null) {
            this.popup.updateUI();
        }
        this.setUI(LookAndFeelAddons.getUI((JComponent)this, DateComboBoxUI.class));
    }

    public void setDate(Date date) {
        if (date == null) {
            this.setDate((Long)null);
        } else {
            this.setDate(date.getTime());
        }
    }

    public void setDate(Long date) {
        if (this.getItemCount() > 0) {
            ActionListener l;
            ActionListener[] listeners;
            ActionListener[] actionListenerArray = listeners = this.getActionListeners();
            int n = listeners.length;
            int n2 = 0;
            while (n2 < n) {
                l = actionListenerArray[n2];
                this.removeActionListener(l);
                ++n2;
            }
            this.removeItemAt(0);
            actionListenerArray = listeners;
            n = listeners.length;
            n2 = 0;
            while (n2 < n) {
                l = actionListenerArray[n2];
                this.addActionListener(l);
                ++n2;
            }
        }
        if (date == null) {
            this.popup.getMonthView().clearSelection();
            this.getDateField().setValue(null);
            this.getDateField().setText("");
            this.addItem((Object)null);
            this.fireActionEvent();
        } else {
            this.getDateField().setValue(new Date(date));
            this.popup.getMonthView().setSelectionInterval(new Date(date), new Date(date));
            ((DateComboBoxMonthView)this.popup.getMonthView()).ensureDateVisible();
            this.addItem(new Date(date));
        }
        this.repaint();
    }

    public Date getDate() {
        if (this.popup.getMonthView().isSelectionEmpty()) {
            return null;
        }
        return (Date)this.popup.getMonthView().getSelection().first();
    }

    public Date getDateTime() {
        if (!this.isEditable) {
            return this.getDate();
        }
        Object val = this.getDateField().getValue();
        if (val instanceof Date) {
            return (Date)val;
        }
        if (val instanceof Long) {
            return new Date((Long)val);
        }
        return null;
    }

    public String getFormattedDate() {
        return this.dateFormats[0].format(this.getDate());
    }

    public void setDateFormat(DateFormat df) {
        this.setDateFormats(new DateFormat[]{df});
    }

    public void setDateFormats(DateFormat[] dateFormats) {
        this.dateFormats = dateFormats;
        this.getDateField().setFormatterFactory(new DefaultFormatterFactory((JFormattedTextField.AbstractFormatter)new DatePickerFormatter(dateFormats)));
    }

    public DateFormat[] getDateFormats() {
        return this.dateFormats;
    }

    private JFormattedTextField getDateField() {
        return (JFormattedTextField)this.getEditor().getEditorComponent();
    }

    public DateComboBoxPopup getPopup() {
        return this.popup;
    }

    public void setPopup(DateComboBoxPopup popup) {
        this.popup = popup;
    }

    @Override
    public void setSelectedIndex(int index) {
    }

    @Override
    public int getSelectedIndex() {
        return 0;
    }

    @Override
    public void addItem(Object o) {
        if (this.getItemCount() == 0) {
            super.addItem(o);
        }
    }

    public boolean isEmpty() {
        return this.popup.getMonthView().isSelectionEmpty();
    }

    @Override
    public Object getSelectedItem() {
        return this.getDateTime();
    }
}

