/*
 * Decompiled with CFR 0.152.
 */
package de.javasoft.table.ui.controls;

import de.javasoft.table.JYTable;
import de.javasoft.table.JYTableHeader;
import de.javasoft.table.ui.controls.IRolloverAware;
import java.awt.event.MouseEvent;
import java.util.logging.Logger;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.event.MouseInputListener;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

public class TableHeaderMouseInputHandler
implements MouseInputListener {
    private static final Logger LOG = Logger.getLogger(TableHeaderMouseInputHandler.class.getName());
    private MouseInputListener delegate;
    private TableColumn cachedResizingColumn;

    public TableHeaderMouseInputHandler(MouseInputListener delegate) {
        this.delegate = delegate;
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (!SwingUtilities.isLeftMouseButton(e)) {
            return;
        }
        if (e.getComponent() instanceof JYTableHeader) {
            this.yTableHeaderClicked((JYTableHeader)((Object)e.getComponent()), e);
        } else {
            this.delegate.mouseClicked(e);
        }
        this.uncacheResizingColumn();
    }

    private void yTableHeaderClicked(JYTableHeader header, MouseEvent e) {
        if (!header.isEnabled()) {
            return;
        }
        if (this.isInResizeArea()) {
            this.doResize(header, e);
            return;
        }
        JTable table = header.getTable();
        if (table instanceof JYTable && e.getClickCount() % 2 == 1) {
            int columnIndex = header.columnAtPoint(e.getPoint());
            if (columnIndex != -1) {
                ((JYTable)((Object)table)).toggleSortOrder(columnIndex, this.isMultipleSort(e));
            }
        } else {
            this.delegate.mouseClicked(e);
        }
    }

    private boolean isMultipleSort(MouseEvent e) {
        return e.getModifiersEx() == 128 || e.getModifiersEx() == 256;
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (!SwingUtilities.isLeftMouseButton(e)) {
            return;
        }
        this.delegate.mousePressed(e);
        this.cacheResizingColumn(e);
    }

    private void cacheResizingColumn(MouseEvent e) {
        TableColumn column = ((JYTableHeader)((Object)e.getComponent())).getResizingColumn();
        if (column != null) {
            this.cachedResizingColumn = column;
        }
    }

    private void uncacheResizingColumn() {
        this.cachedResizingColumn = null;
    }

    private boolean isInResizeArea() {
        return this.cachedResizingColumn != null;
    }

    private void doResize(JYTableHeader header, MouseEvent e) {
        if (e.getClickCount() != 2) {
            return;
        }
        int column = this.getViewIndexForColumn(header, this.cachedResizingColumn);
        if (column >= 0) {
            header.getXTable().packColumn(column, 5);
        }
    }

    private int getViewIndexForColumn(JYTableHeader header, TableColumn aColumn) {
        if (aColumn == null) {
            return -1;
        }
        TableColumnModel cm = header.getColumnModel();
        int column = 0;
        while (column < cm.getColumnCount()) {
            if (cm.getColumn(column) == aColumn) {
                return column;
            }
            ++column;
        }
        return -1;
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (!SwingUtilities.isLeftMouseButton(e)) {
            return;
        }
        this.delegate.mouseReleased(e);
        this.updateRollover(e);
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        if (!SwingUtilities.isLeftMouseButton(e)) {
            return;
        }
        this.delegate.mouseDragged(e);
        this.uncacheResizingColumn();
        this.updateRollover(e);
    }

    private void updateRollover(MouseEvent e) {
        if (((JYTableHeader)((Object)e.getComponent())).getUI() instanceof IRolloverAware) {
            ((IRolloverAware)((Object)((JTableHeader)e.getComponent()).getUI())).updateRolloverState(e);
        }
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        this.delegate.mouseMoved(e);
        this.updateRollover(e);
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        this.delegate.mouseEntered(e);
        this.uncacheResizingColumn();
        this.updateRollover(e);
    }

    @Override
    public void mouseExited(MouseEvent e) {
        this.delegate.mouseExited(e);
        this.uncacheResizingColumn();
        this.updateRollover(e);
    }
}

