/*
 * Decompiled with CFR 0.152.
 */
package de.javasoft.table.ui;

import com.sun.java.swing.plaf.windows.WindowsTableHeaderUI;
import de.javasoft.table.JYTableHeader;
import de.javasoft.table.sort.ISortIconProvider;
import de.javasoft.table.sort.SortIconProvider;
import de.javasoft.table.ui.controls.IRolloverAware;
import de.javasoft.table.ui.controls.TableHeaderMouseInputHandler;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.event.MouseEvent;
import java.util.logging.Logger;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.border.Border;
import javax.swing.event.MouseInputListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import org.jdesktop.swingx.SwingXUtilities;
import org.jdesktop.swingx.util.OS;

public class WindowsJYTableHeaderUI
extends WindowsTableHeaderUI
implements IRolloverAware {
    private static final Logger LOG = Logger.getLogger(WindowsJYTableHeaderUI.class.getName());
    private TableCellRenderer originalHeaderRenderer;
    private TableCellRenderer superxpRenderer;
    private Border emptyBorder;
    private int rolloverColumn;

    public static ComponentUI createUI(JComponent c) {
        return new WindowsJYTableHeaderUI();
    }

    public void installUI(JComponent c) {
        if (!(c instanceof JYTableHeader)) {
            throw new IllegalStateException("expected type is JYTableHeader, was: " + c.getClass().getName());
        }
        JTableHeader header = (JTableHeader)c;
        this.originalHeaderRenderer = header.getDefaultRenderer();
        super.installUI(c);
        this.superxpRenderer = header.getDefaultRenderer();
        if (this.superxpRenderer != this.originalHeaderRenderer) {
            this.grabBorders();
            header.setDefaultRenderer(new WrappingRenderer());
        }
    }

    private void grabBorders() {
        JTable table = new JTable(10, 2);
        table.setAutoCreateRowSorter(true);
        Component comp = this.superxpRenderer.getTableCellRendererComponent(table, "something", false, false, -1, 0);
        this.emptyBorder = ((JComponent)comp).getBorder();
    }

    public void uninstallUI(JComponent c) {
        if (this.header.getDefaultRenderer() instanceof WrappingRenderer) {
            this.header.setDefaultRenderer(this.superxpRenderer);
        }
        super.uninstallUI(c);
    }

    protected JYTableHeader getYTableHeader() {
        return (JYTableHeader)((Object)this.header);
    }

    protected MouseInputListener createMouseInputListener() {
        return new TableHeaderMouseInputHandler(super.createMouseInputListener());
    }

    @Override
    public void updateRolloverState(MouseEvent e) {
    }

    private boolean shouldDisableRollover(MouseEvent e) {
        return e.getID() == 505 && this.getRolloverColumn() >= 0 || e.getID() == 506 && this.header.getReorderingAllowed();
    }

    private static class IconBorder
    implements Border,
    UIResource {
        private final Icon icon;
        private final int top;
        private final int left;
        private final int bottom;
        private final int right;

        public IconBorder(Icon icon, int top, int left, int bottom, int right) {
            this.icon = icon;
            this.top = top;
            this.left = left;
            this.bottom = bottom;
            this.right = right;
        }

        @Override
        public Insets getBorderInsets(Component c) {
            return new Insets(this.icon.getIconHeight() + this.top, this.left, this.bottom, this.right);
        }

        @Override
        public boolean isBorderOpaque() {
            return false;
        }

        @Override
        public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
            this.icon.paintIcon(c, g, x + this.left + (width - this.left - this.right - this.icon.getIconWidth()) / 2, y + this.top);
        }
    }

    private class WrappingRenderer
    implements TableCellRenderer {
        private ISortIconProvider sortIconProvider;

        private WrappingRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Icon icon;
            Component comp = WindowsJYTableHeaderUI.this.superxpRenderer.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            if (!(comp instanceof JLabel)) {
                return comp;
            }
            JLabel label = (JLabel)comp;
            if (OS.isWindowsVista() && SwingXUtilities.isUIInstallable((Object)label.getIcon()) && (icon = this.getSortIconProvider().getSortIcon(table, column, true)) != null) {
                Border border = label.getBorder();
                Insets insets = border.getBorderInsets(label);
                IconBorder ib = new IconBorder(icon, insets.top - icon.getIconHeight(), insets.left, insets.bottom, insets.right);
                label.setBorder(ib);
            }
            if (WindowsJYTableHeaderUI.this.getYTableHeader().isSubHeader()) {
                label.setIcon(null);
                label.setText(null);
                label.setBorder(WindowsJYTableHeaderUI.this.emptyBorder);
            }
            return label;
        }

        private ISortIconProvider getSortIconProvider() {
            if (this.sortIconProvider == null) {
                this.sortIconProvider = new SortIconProvider();
            }
            return this.sortIconProvider;
        }
    }
}

