/*
 * Decompiled with CFR 0.152.
 */
package de.javasoft.table.ui;

import de.javasoft.plaf.synthetica.SyntheticaLookAndFeel;
import de.javasoft.plaf.synthetica.SyntheticaState;
import de.javasoft.table.renderer.DefaultTableHeaderRenderer;
import de.javasoft.table.renderer.JYTableHeaderCell;
import de.javasoft.table.renderer.TableHeaderCellContext;
import de.javasoft.table.renderer.TableHeaderCellProvider;
import de.javasoft.table.ui.BasicJYTableHeaderUI;
import de.javasoft.table.ui.controls.TableHeaderMouseInputHandler;
import de.javasoft.table.ui.painter.JYTablePainter;
import java.awt.Container;
import java.awt.Font;
import java.awt.Graphics;
import java.util.logging.Logger;
import javax.swing.CellRendererPane;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.SortOrder;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.MouseInputListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import org.jdesktop.swingx.SwingXUtilities;

public class SyntheticaJYTableHeaderUI
extends BasicJYTableHeaderUI {
    private static final Logger LOG = Logger.getLogger(SyntheticaJYTableHeaderUI.class.getName());
    private TableCellRenderer originalRenderer;
    private TableCellRenderer replacedRenderer;

    public static ComponentUI createUI(JComponent c) {
        return new SyntheticaJYTableHeaderUI();
    }

    @Override
    protected void installDefaults() {
        this.originalRenderer = this.header.getDefaultRenderer();
        if (SwingXUtilities.isUIInstallable((Object)this.originalRenderer)) {
            this.replacedRenderer = new DefaultTableHeaderRenderer(new SyntheticaProvider());
            this.header.setDefaultRenderer(this.replacedRenderer);
            this.hackCellBorder();
        }
        super.installDefaults();
    }

    private void hackCellBorder() {
        this.installBorder("TableHeader.cellBorder", false);
        this.installBorder("TableHeader.focusCellBorder", true);
    }

    private void installBorder(String borderKey, boolean focused) {
        Border border = UIManager.getBorder(borderKey);
        if (border == null) {
            JTable table = new JTable();
            TableCellRenderer renderer = table.getTableHeader().getDefaultRenderer();
            JComponent comp = (JComponent)renderer.getTableCellRendererComponent(table, null, focused, focused, -1, 0);
            UIManager.getLookAndFeelDefaults().put(borderKey, comp.getBorder());
        }
    }

    @Override
    protected void uninstallDefaults() {
        if (this.header.getDefaultRenderer() == this.replacedRenderer) {
            this.header.setDefaultRenderer(this.originalRenderer);
        }
        this.replacedRenderer = null;
        super.uninstallDefaults();
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        JTable table = ((JTableHeader)c).getTable();
        if (table != null) {
            if (this.getYTableHeader().isSubHeader()) {
                JYTablePainter.getInstance().paintTableSubHeaderBackground(table, new SyntheticaState(), g, 0, 0, c.getWidth(), c.getHeight());
            } else {
                JYTablePainter.getInstance().paintTableHeaderBackground(table, new SyntheticaState(), g, 0, 0, c.getWidth(), c.getHeight());
            }
        }
        super.paint(g, c);
    }

    @Override
    protected MouseInputListener createMouseInputListener() {
        return new TableHeaderMouseInputHandler(super.createMouseInputListener());
    }

    protected class SyntheticaProvider
    extends TableHeaderCellProvider {
        private SortOrder sortOrder;

        public SyntheticaProvider() {
            ((JYTableHeaderCell)this.rendererComponent).setOpaque(false);
        }

        @Override
        protected void formatSortDecoration(TableHeaderCellContext headerContext) {
            super.formatSortDecoration(headerContext);
            this.sortOrder = headerContext.getSortOrder();
        }

        @Override
        protected JYTableHeaderCell createRendererComponent() {
            return new SyntheticaJYTableHeaderCell();
        }

        protected class SyntheticaJYTableHeaderCell
        extends JYTableHeaderCell {
            protected SyntheticaJYTableHeaderCell() {
            }

            @Override
            protected void paintComponent(Graphics g) {
                JTable table = this.getTable();
                if (table != null) {
                    int order;
                    int n = SyntheticaProvider.this.sortOrder == SortOrder.ASCENDING ? 1 : (order = SyntheticaProvider.this.sortOrder == SortOrder.DESCENDING ? 2 : 0);
                    if (SyntheticaJYTableHeaderUI.this.getYTableHeader().isSubHeader()) {
                        JYTablePainter.getInstance().paintTableSubHeaderCellBackground(table, new SyntheticaState(0), g, 0, 0, this.getWidth(), this.getHeight(), order);
                    } else {
                        JYTablePainter.getInstance().paintTableHeaderCellBackground(table, new SyntheticaState(0), g, 0, 0, this.getWidth(), this.getHeight(), order);
                    }
                }
                super.paintComponent(g);
            }

            private JTable getTable() {
                Container parent = this.getParent();
                if (parent instanceof CellRendererPane) {
                    parent = parent.getParent();
                }
                return parent instanceof JTableHeader ? ((JTableHeader)parent).getTable() : null;
            }

            @Override
            protected Font deriveSortMarkerFont(Font font) {
                if (font == null) {
                    return null;
                }
                return font.deriveFont(Float.valueOf(SyntheticaLookAndFeel.getInt((String)"JYTable.header.arrowLabel.fontSize", null, (int)8, (boolean)true)).floatValue());
            }

            @Override
            protected void initSortMarkerProperties() {
                super.initSortMarkerProperties();
                this.getSortMarker().setIconTextGap(0);
            }
        }
    }
}

