/*
 * Decompiled with CFR 0.152.
 */
package de.javasoft.table.ui;

import de.javasoft.table.JYTableHeader;
import de.javasoft.table.renderer.CellLayoutHint;
import de.javasoft.table.ui.JYTableHeaderUI;
import de.javasoft.table.ui.controls.IRolloverAware;
import de.javasoft.table.ui.controls.TableHeaderMouseInputHandler;
import java.awt.event.MouseEvent;
import java.util.logging.Logger;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.event.MouseInputListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.table.JTableHeader;
import org.jdesktop.swingx.SwingXUtilities;

public class BasicJYTableHeaderUI
extends JYTableHeaderUI
implements IRolloverAware {
    private static final Logger LOG = Logger.getLogger(BasicJYTableHeaderUI.class.getName());
    private int rolloverColumn;

    public static ComponentUI createUI(JComponent c) {
        return new BasicJYTableHeaderUI();
    }

    @Override
    public void installUI(JComponent c) {
        if (!(c instanceof JYTableHeader)) {
            throw new IllegalArgumentException("expected table header of type JYTableHeader but was: " + c.getClass());
        }
        super.installUI(c);
    }

    @Override
    protected void installDefaults() {
        CellLayoutHint hint;
        super.installDefaults();
        if (SwingXUtilities.isUIInstallable((Object)this.getYTableHeader().getCellLayoutHint()) && (hint = (CellLayoutHint)UIManager.get("TableHeader.cellLayoutHint")) != null) {
            this.getYTableHeader().setCellLayoutHint(hint);
        }
    }

    @Override
    protected MouseInputListener createMouseInputListener() {
        return new TableHeaderMouseInputHandler(super.createMouseInputListener());
    }

    protected JYTableHeader getYTableHeader() {
        return (JYTableHeader)((Object)this.header);
    }

    @Override
    public void updateRolloverState(MouseEvent e) {
    }

    private boolean shouldDisableRollover(MouseEvent e) {
        return e.getID() == 505 && this.getRolloverColumn() >= 0 || e.getID() == 506 && this.header.getReorderingAllowed();
    }

    protected int getSuperRolloverColumn() {
        return super.getRolloverColumn();
    }

    private int getRolloverOfSiblingHeaders() {
        if (this.getYTableHeader().getXTable() == null) {
            return -1;
        }
        JTableHeader sibling = null;
        if (this.getYTableHeader().isSubHeader()) {
            sibling = this.getYTableHeader().getXTable().getTableHeader();
        } else {
            JComponent filterRow = this.getYTableHeader().getXTable().getFilterRow();
            if (filterRow instanceof JTableHeader) {
                sibling = (JTableHeader)filterRow;
            }
        }
        if (sibling == null || !(sibling.getUI() instanceof BasicJYTableHeaderUI)) {
            return -1;
        }
        BasicJYTableHeaderUI ui = (BasicJYTableHeaderUI)sibling.getUI();
        return ui.getSuperRolloverColumn();
    }
}

