/*
 * Decompiled with CFR 0.152.
 */
package de.javasoft.table.sort;

import de.javasoft.table.sort.Comparators;
import java.util.ArrayList;
import java.util.Collection;
import java.util.logging.Logger;
import javax.swing.RowFilter;
import org.jdesktop.swingx.sort.RowFilters;
import org.jdesktop.swingx.util.Contract;

public class RowFilters {
    private static final Logger LOG = Logger.getLogger(RowFilters.class.getName());

    public static <M, I> RowFilter<M, I> rangeFilter(RangeType type, Comparable<?> lower, Comparable<?> upper, int ... columns) {
        return new RangeFilter(type, lower, upper, columns);
    }

    public static <M, I> RowFilter<M, I> compareToFilter(ComparisonTypeExt type, Comparable<?> comparable, int ... columns) {
        return new ComparableFilter(type, comparable, columns);
    }

    public static <M, I> RowFilter<M, I> equalsFilter(Object compareValue, int ... indices) {
        return new EqualsFilter(compareValue, indices);
    }

    public static class ComparableFilter
    extends RowFilters.GeneralFilter {
        private Comparable comparable;
        private ComparisonTypeExt type;
        private boolean comparableNumber;
        private RowFilter compoundFilter;

        public ComparableFilter(ComparisonTypeExt matchRule, Comparable matchValue, int ... columns) {
            super(columns);
            Contract.asNotNull((Object)((Object)matchRule), (String)"comparisonType must not be null");
            Contract.asNotNull((Object)matchValue, (String)"compare value must not be null");
            this.comparable = matchValue;
            this.comparableNumber = matchValue instanceof Number;
            this.installComparisonType(matchRule, columns);
        }

        private void installComparisonType(ComparisonTypeExt type, int ... columns) {
            this.type = type;
            if (type.getCompoundType() != null) {
                ArrayList<ComparableFilter> rowFilters = new ArrayList<ComparableFilter>();
                rowFilters.add(new ComparableFilter(type.getCompoundType(), this.comparable, columns));
                rowFilters.add(new ComparableFilter(ComparisonTypeExt.EQUAL, this.comparable, columns));
                this.compoundFilter = RowFilter.orFilter(rowFilters);
            }
        }

        public boolean include(RowFilter.Entry<? extends Object, ? extends Object> entry) {
            if (this.compoundFilter != null) {
                return this.compoundFilter.include(entry);
            }
            return super.include(entry);
        }

        protected boolean include(RowFilter.Entry<? extends Object, ? extends Object> entry, int index) {
            Object v = entry.getValue(index);
            if (v instanceof Comparable) {
                if (v.getClass().isAssignableFrom(this.comparable.getClass())) {
                    int compareValue = this.comparable.compareTo(v);
                    return this.checkComparison(compareValue);
                }
                if (this.comparableNumber && v instanceof Number) {
                    int compareValue = Comparators.numberComparator.compare((Number)((Object)this.comparable), (Number)v);
                    return this.checkComparison(compareValue);
                }
            }
            return false;
        }

        private int longCompare(Number o) {
            long diff = ((Number)((Object)this.comparable)).longValue() - o.longValue();
            if (diff < 0L) {
                return -1;
            }
            if (diff > 0L) {
                return 1;
            }
            return 0;
        }

        private boolean checkComparison(int compareResult) {
            switch (this.type) {
                case BEFORE: {
                    return compareResult > 0;
                }
                case AFTER: {
                    return compareResult < 0;
                }
                case EQUAL: {
                    return compareResult == 0;
                }
                case NOT_EQUAL: {
                    return compareResult != 0;
                }
            }
            return false;
        }

        public String toString() {
            if (this.compoundFilter != null) {
                return this.compoundFilter.toString();
            }
            String result = "[RowFilter: ComparisonType = " + (Object)((Object)this.type) + ", comparableValue: " + this.comparable + ", comparableClass: " + this.comparable.getClass() + "]";
            return result;
        }
    }

    public static enum ComparisonTypeExt {
        BEFORE,
        AFTER,
        EQUAL,
        NOT_EQUAL,
        BEFORE_EQUAL(BEFORE),
        AFTER_EQUAL(AFTER);

        ComparisonTypeExt compoundType;

        private ComparisonTypeExt() {
            this(null);
        }

        private ComparisonTypeExt(ComparisonTypeExt compoundType) {
            this.compoundType = compoundType;
        }

        public ComparisonTypeExt getCompoundType() {
            return this.compoundType;
        }
    }

    public static class ContainsFilter
    extends RowFilters.GeneralFilter {
        private Collection<?> values;

        public ContainsFilter(Collection<?> values, int ... columns) {
            super(columns);
            Contract.asNotNull(values, (String)"colllection must not be null");
            this.values = values;
        }

        protected boolean include(RowFilter.Entry<? extends Object, ? extends Object> value, int index) {
            return this.values.contains(value.getValue(index));
        }
    }

    public static class EqualsFilter
    extends RowFilters.GeneralFilter {
        private Object matchValue;

        public EqualsFilter(Object matchValue, int ... columns) {
            super(columns);
            Contract.asNotNull((Object)matchValue, (String)"compare value must not be null");
            this.matchValue = matchValue;
        }

        protected boolean include(RowFilter.Entry<? extends Object, ? extends Object> entry, int index) {
            return this.matchValue.equals(entry.getValue(index));
        }
    }

    public static class RangeFilter
    extends RowFilters.GeneralFilter {
        private Comparable<?> upper;
        private Comparable<?> lower;
        private RowFilter filter;

        public RangeFilter(RangeType type, Comparable<?> lower, Comparable<?> upper, int ... columns) {
            super(columns);
            Contract.asNotNull((Object)((Object)type), (String)"RangeType must not be null");
            Contract.asNotNull(upper, (String)"boundary must not be null");
            Contract.asNotNull(lower, (String)"boundary must not be null");
            this.installBoundaries(lower, upper);
            this.installType(type, columns);
        }

        private void installType(RangeType type, int ... columns) {
            ArrayList<ComparableFilter> rowFilters = new ArrayList<ComparableFilter>();
            rowFilters.add(new ComparableFilter(type.getLowerComparisonType(), this.lower, columns));
            rowFilters.add(new ComparableFilter(type.getUpperComparisonType(), this.upper, columns));
            this.filter = RowFilter.andFilter(rowFilters);
        }

        private void installBoundaries(Comparable min, Comparable max) {
            if (min.compareTo(max) > 0) {
                Comparable temp = min;
                min = max;
                max = temp;
            }
            this.lower = min;
            this.upper = max;
        }

        public boolean include(RowFilter.Entry<? extends Object, ? extends Object> value) {
            return this.filter.include(value);
        }

        protected boolean include(RowFilter.Entry<? extends Object, ? extends Object> value, int index) {
            return false;
        }
    }

    public static enum RangeType {
        ALL_INCLUSIVE(ComparisonTypeExt.AFTER_EQUAL, ComparisonTypeExt.BEFORE_EQUAL),
        FROM_INCLUSIVE(ComparisonTypeExt.AFTER_EQUAL, ComparisonTypeExt.BEFORE),
        TO_INCLUSIVE(ComparisonTypeExt.AFTER, ComparisonTypeExt.BEFORE_EQUAL),
        NONE_INCLUSIVE(ComparisonTypeExt.AFTER, ComparisonTypeExt.BEFORE);

        private ComparisonTypeExt lower;
        private ComparisonTypeExt upper;

        private RangeType(ComparisonTypeExt lowerType, ComparisonTypeExt upperType) {
            this.lower = lowerType;
            this.upper = upperType;
        }

        public ComparisonTypeExt getLowerComparisonType() {
            return this.lower;
        }

        public ComparisonTypeExt getUpperComparisonType() {
            return this.upper;
        }
    }
}

