/*
 * Decompiled with CFR 0.152.
 */
package de.javasoft.table.renderer;

import de.javasoft.table.sort.RowFilters;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.jdesktop.swingx.action.AbstractActionExt;
import org.jdesktop.swingx.plaf.UIManagerExt;
import org.jdesktop.swingx.renderer.LocalizableStringValue;
import org.jdesktop.swingx.renderer.StringValue;

public class StringValues {
    private static Map<Object, String> yesNoLookup = new HashMap<Object, String>();
    private static Map<Object, String> trueFalseLookup;
    private static Map<Object, String> lookup;
    private static Map<Object, String> search;

    static {
        yesNoLookup.put(null, "FilterOption.allText");
        yesNoLookup.put(Boolean.TRUE, "OptionPane.yesButtonText");
        yesNoLookup.put(Boolean.FALSE, "OptionPane.noButtonText");
        trueFalseLookup = new HashMap<Object, String>();
        trueFalseLookup.put(null, "FilterOption.allText");
        trueFalseLookup.put(Boolean.TRUE, "FilterOption.trueText");
        trueFalseLookup.put(Boolean.FALSE, "FilterOption.falseText");
        lookup = new HashMap<Object, String>();
        lookup.put((Object)RowFilters.ComparisonTypeExt.BEFORE, "FilterOption.less");
        lookup.put((Object)RowFilters.ComparisonTypeExt.BEFORE_EQUAL, "FilterOption.lessEqual");
        lookup.put((Object)RowFilters.ComparisonTypeExt.AFTER, "FilterOption.greater");
        lookup.put((Object)RowFilters.ComparisonTypeExt.AFTER_EQUAL, "FilterOption.greaterEqual");
        lookup.put((Object)RowFilters.ComparisonTypeExt.EQUAL, "FilterOption.equal");
        lookup.put((Object)RowFilters.ComparisonTypeExt.NOT_EQUAL, "FilterOption.unequal");
        lookup.put((Object)RowFilters.RangeType.ALL_INCLUSIVE, "FilterOption.allInclusive");
        lookup.put((Object)RowFilters.RangeType.FROM_INCLUSIVE, "FilterOption.fromInclusive");
        lookup.put((Object)RowFilters.RangeType.TO_INCLUSIVE, "FilterOption.toInclusive");
        lookup.put((Object)RowFilters.RangeType.NONE_INCLUSIVE, "FilterOption.noneInclusive");
        lookup.put("contains", "FilterOption.contains");
        lookup.put("endsWith", "FilterOption.endsWith");
        lookup.put("equals", "FilterOption.equals");
        lookup.put("startsWith", "FilterOption.startsWith");
        lookup.put("containsNot", "FilterOption.containsNot");
        search = new HashMap<Object, String>();
        search.put("contains", "Search.contains");
        search.put("endsWith", "Search.endsWith");
        search.put("equals", "Search.equals");
        search.put("startsWith", "Search.startsWith");
    }

    public static LocalizableStringValue createYesNoLookup() {
        return StringValues.createYesNoLookup(null);
    }

    public static LocalizableStringValue createYesNoLookup(Locale locale) {
        return new LocalizableStringValue(yesNoLookup, locale);
    }

    public static LocalizableStringValue createTrueFalseLookup() {
        return StringValues.createTrueFalseLookup(null);
    }

    public static LocalizableStringValue createTrueFalseLookup(Locale locale) {
        return new LocalizableStringValue(trueFalseLookup, locale);
    }

    public static String getMatchRuleTextKey(Object matchRule) {
        String base = search.get(matchRule);
        if (base == null && (base = lookup.get(matchRule)) != null) {
            base = String.valueOf(base) + "Text";
        }
        if (base == null) {
            base = matchRule.toString();
        }
        return base;
    }

    public static String getMatchRuleIconKey(Object matchRule) {
        String base = lookup.get(matchRule);
        if (base == null) {
            base = matchRule.toString();
        }
        return String.valueOf(base) + "Icon";
    }

    public static StringValue createMatchRuleStringValue(List<?> matchRules) {
        HashMap rules = new HashMap();
        for (Object matchRule : matchRules) {
            rules.put(matchRule, StringValues.getMatchRuleTextKey(matchRule));
        }
        return new LocalizableStringValue(rules);
    }

    public static List<AbstractActionExt> createMatchRuleActions(List<?> matchRules, Locale locale) {
        ArrayList<AbstractActionExt> actions = new ArrayList<AbstractActionExt>();
        for (Object rule : matchRules) {
            AbstractActionExt action = StringValues.createMatchRuleAction(rule, locale);
            actions.add(action);
        }
        return actions;
    }

    public static AbstractActionExt createMatchRuleAction(Object rule, Locale locale) {
        String matchRuleTextKey = StringValues.getMatchRuleTextKey(rule);
        String name = UIManagerExt.getString((Object)matchRuleTextKey, (Locale)locale);
        AbstractActionExt action = new AbstractActionExt(name != null ? name : matchRuleTextKey.toString()){

            public void actionPerformed(ActionEvent e) {
            }
        };
        action.setStateAction();
        action.setGroup((Object)"matchRule");
        action.putValue("matchRule", rule);
        return action;
    }

    private StringValues() {
    }
}

