/*
 * Decompiled with CFR 0.152.
 */
package de.javasoft.table.renderer;

import de.javasoft.plaf.synthetica.SyntheticaLookAndFeel;
import de.javasoft.table.renderer.ITableHeaderCell;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JLabel;
import org.jdesktop.swingx.renderer.JRendererLabel;

public class JYTableHeaderCell
extends JLabel
implements ITableHeaderCell {
    private static final Logger LOG = Logger.getLogger(JYTableHeaderCell.class.getName());
    private static final Dimension ZERO = new Dimension(0, 0);
    private static final ITableHeaderCell.SortMarkerPosition DEFAULT_POSITION = ITableHeaderCell.SortMarkerPosition.AFTER_STRUTTED;
    private JLabel title;
    private JLabel sortMarker;
    private boolean sortMarkerVisible;
    private ITableHeaderCell.SortMarkerPosition sortMarkerPosition;

    public JYTableHeaderCell() {
        this.initProperties();
        this.initComponents();
    }

    private void initProperties() {
        this.sortMarkerPosition = DEFAULT_POSITION;
    }

    private void initComponents() {
        BorderLayoutX layout = new BorderLayoutX();
        layout.setHgap(SyntheticaLookAndFeel.getInstance().scaleInteger(Integer.valueOf(3)));
        this.setLayout(layout);
        this.title = new JRendererLabel();
        this.title.setName("TableHeader.renderer");
        Insets insets = this.title.getInsets();
        this.title.setBorder(SyntheticaLookAndFeel.getInstance().createEmptyBorder(insets.top, 0, insets.bottom, 0, false));
        this.sortMarker = new JRendererLabel();
        this.initTitleLabelProperties();
        this.initSortMarkerProperties();
        this.add(this.title);
    }

    protected void initSortMarkerProperties() {
        this.sortMarker.setHorizontalTextPosition(11);
        this.sortMarker.setIconTextGap(2);
        this.sortMarker.setFont(this.getFont());
        this.sortMarker.setOpaque(false);
        this.sortMarker.setBorder(BorderFactory.createEmptyBorder());
    }

    protected void initTitleLabelProperties() {
        this.title.setOpaque(false);
        this.title.setFont(this.getFont());
    }

    @Override
    public void setSortMarkerPosition(ITableHeaderCell.SortMarkerPosition position) {
        if (position == null) {
            position = DEFAULT_POSITION;
        }
        if (this.sortMarkerPosition == position) {
            return;
        }
        this.sortMarkerPosition = position;
        this.updateSortMarker();
    }

    private void updateSortMarker() {
        if (!this.isSortMarkerVisible()) {
            return;
        }
        this.remove(this.sortMarker);
        this.showSortMarker();
    }

    @Override
    public ITableHeaderCell.SortMarkerPosition getSortMarkerPosition() {
        return this.sortMarkerPosition;
    }

    @Override
    public void setSortMarkerVisible(boolean visible) {
        if (visible == this.isSortMarkerVisible()) {
            return;
        }
        this.sortMarkerVisible = visible;
        if (visible) {
            this.showSortMarker();
        } else {
            this.hideMarker();
        }
    }

    private void showSortMarker() {
        ((BorderLayoutX)this.getLayout()).setHorizontalStretch(this.sortMarkerPosition.getHorizontalStretch());
        this.add((Component)this.sortMarker, this.sortMarkerPosition.getConstraint());
        if (this.sortMarkerPosition.isHorizontal()) {
            this.sortMarker.setHorizontalAlignment(0);
            this.sortMarker.setVerticalAlignment(this.getVerticalAlignment());
        } else {
            this.sortMarker.setVerticalAlignment(0);
            if (this.sortMarkerPosition.getHorizontalDock() == ITableHeaderCell.HorizontalDock.DOCKED) {
                this.sortMarker.setHorizontalAlignment(this.getHorizontalAlignment());
            } else {
                this.sortMarker.setHorizontalAlignment(this.sortMarkerPosition.getHorizontalDock().getHorizontalAlignment());
            }
        }
        this.revalidate();
    }

    private void hideMarker() {
        this.remove(this.sortMarker);
        this.revalidate();
    }

    @Override
    public boolean isSortMarkerVisible() {
        return this.sortMarkerVisible;
    }

    @Override
    public void setSortMarker(String text, Icon icon) {
        this.sortMarker.setText(text);
        this.sortMarker.setIcon(icon);
    }

    @Override
    public Icon getSortIcon() {
        return this.sortMarker.getIcon();
    }

    @Override
    public String getSortText() {
        return this.sortMarker.getText();
    }

    @Override
    public void setContent(String sv, Icon icon) {
        this.title.setText(sv);
        this.title.setIcon(icon);
    }

    @Override
    public String getContentText() {
        return this.title != null ? this.title.getText() : null;
    }

    @Override
    public Icon getContentIcon() {
        return this.title.getIcon();
    }

    @Override
    public void setHorizontalAlignment(int align) {
        if (this.title == null) {
            return;
        }
        this.title.setHorizontalAlignment(align);
        this.updateSortMarker();
    }

    @Override
    public int getHorizontalAlignment() {
        return this.title.getHorizontalAlignment();
    }

    @Override
    public void setVerticalAlignment(int align) {
        this.title.setVerticalAlignment(align);
        this.updateSortMarker();
    }

    @Override
    public int getVerticalAlignment() {
        return this.title.getVerticalAlignment();
    }

    @Override
    public void setHorizontalTextPosition(int align) {
    }

    @Override
    public void setVerticalTextPosition(int align) {
    }

    @Override
    public void setFont(Font font) {
        if (this.sortMarker != null) {
            this.sortMarker.setFont(this.deriveSortMarkerFont(font));
            this.title.setFont(font);
        }
        super.setFont(font);
    }

    protected Font deriveSortMarkerFont(Font font) {
        return font;
    }

    @Override
    public void setEnabled(boolean enabled) {
        if (this.sortMarker != null) {
            this.sortMarker.setEnabled(enabled);
            this.title.setEnabled(enabled);
        }
        super.setEnabled(enabled);
    }

    @Override
    public void setForeground(Color color) {
        if (this.sortMarker != null) {
            this.sortMarker.setForeground(color);
            this.title.setForeground(color);
        }
        super.setForeground(color);
    }

    @Override
    public void setText(String text) {
        if (this.title != null) {
            this.title.setText(text);
        }
    }

    @Override
    public String getText() {
        return null;
    }

    @Override
    public void setIcon(Icon icon) {
        if (this.title != null) {
            this.title.setIcon(icon);
        }
    }

    @Override
    public Icon getIcon() {
        return null;
    }

    @Override
    public Dimension getPreferredSize() {
        return this.getLayout() != null ? this.getLayout().preferredLayoutSize(this) : ZERO;
    }

    @Override
    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    @Override
    public Dimension getMaximumSize() {
        return this.getPreferredSize();
    }

    protected JLabel getSortMarker() {
        return this.sortMarker;
    }

    protected JLabel getTitle() {
        return this.title;
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
    }

    private static class BorderLayoutX
    extends BorderLayout {
        private ITableHeaderCell.HorizontalStretch stretch;

        private BorderLayoutX() {
        }

        public void setHorizontalStretch(ITableHeaderCell.HorizontalStretch stretch) {
            this.stretch = stretch;
        }

        public ITableHeaderCell.HorizontalStretch getHorizontalStretch() {
            return this.stretch;
        }

        @Override
        public void layoutContainer(Container target) {
            super.layoutContainer(target);
            if (this.getHorizontalStretch() != ITableHeaderCell.HorizontalStretch.GLUED || !(target instanceof ITableHeaderCell) || this.getLayoutComponent(target, "West") == null && this.getLayoutComponent(target, "East") == null || this.isBelowPreferred(target)) {
                return;
            }
            this.adjustLayout(target);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void adjustLayout(Container target) {
            Object object = target.getTreeLock();
            synchronized (object) {
                ITableHeaderCell cell = (ITableHeaderCell)((Object)target);
                boolean ltr = target.getComponentOrientation().isLeftToRight();
                Component center = this.getLayoutComponent("Center");
                Rectangle centerBounds = center.getBounds();
                int centerPrefWidth = center.getPreferredSize().width;
                int excess = centerBounds.width - centerPrefWidth;
                centerBounds.width -= excess;
                Component west = this.getLayoutComponent(target, "West");
                if (west != null) {
                    Rectangle westBounds = west.getBounds();
                    switch (cell.getHorizontalAlignment()) {
                        case 10: {
                            if (ltr) break;
                            westBounds.x += excess;
                            centerBounds.x += excess;
                            break;
                        }
                        case 0: {
                            westBounds.x += excess / 2;
                            centerBounds.x += excess / 2;
                            break;
                        }
                        case 11: {
                            if (!ltr) break;
                            westBounds.x += excess;
                            centerBounds.x += excess;
                        }
                    }
                    west.setBounds(westBounds);
                    center.setBounds(centerBounds);
                } else {
                    Component east = this.getLayoutComponent(target, "East");
                    Rectangle eastBounds = east.getBounds();
                    switch (cell.getHorizontalAlignment()) {
                        case 10: {
                            if (ltr) {
                                eastBounds.x -= excess;
                                break;
                            }
                            centerBounds.x += excess;
                            break;
                        }
                        case 0: {
                            eastBounds.x -= excess / 2;
                            centerBounds.x += excess / 2;
                            break;
                        }
                        case 11: {
                            if (ltr) {
                                centerBounds.x += excess;
                                break;
                            }
                            eastBounds.x -= excess;
                        }
                    }
                    east.setBounds(eastBounds);
                    center.setBounds(centerBounds);
                }
            }
        }

        private boolean isBelowPreferred(Container target) {
            return target.getSize().width <= target.getPreferredSize().width;
        }
    }
}

