/*
 * Decompiled with CFR 0.152.
 */
package de.javasoft.table.filter;

import de.javasoft.table.filter.ComparableRowFilterModel;
import de.javasoft.table.filter.IRowFilterModel;
import de.javasoft.table.filter.IRowFilterModelFactory;
import de.javasoft.table.filter.PatternRowFilterModel;

public class RowFilterModelFactories {

    public static class ComparableRowFilterModelFactory<M>
    implements IRowFilterModelFactory<M> {
        private Object initialMatchRule;

        public ComparableRowFilterModelFactory() {
            this(null);
        }

        public ComparableRowFilterModelFactory(Object initialMatchRule) {
            this.initialMatchRule = initialMatchRule;
        }

        @Override
        public IRowFilterModel<M> createRowFilterModel(int columnIndex) {
            return new ComparableRowFilterModel(columnIndex, this.initialMatchRule);
        }
    }

    public static class PatternRowFilterModelFactory<M>
    implements IRowFilterModelFactory<M> {
        private Object initialMatchRule;

        public PatternRowFilterModelFactory() {
            this(null);
        }

        public PatternRowFilterModelFactory(Object initialMatchRule) {
            this.initialMatchRule = initialMatchRule;
        }

        @Override
        public IRowFilterModel<M> createRowFilterModel(int columnIndex) {
            return new PatternRowFilterModel(columnIndex, this.initialMatchRule);
        }
    }
}

