/*
 * Decompiled with CFR 0.152.
 */
package de.javasoft.table.filter;

import de.javasoft.searchfield.JYSearchField;
import de.javasoft.table.filter.ColumnFilter;
import de.javasoft.table.filter.IRowFilterModel;
import de.javasoft.table.filter.PatternRowFilterModel;
import de.javasoft.textfield.JYTextField;
import java.util.logging.Logger;
import javax.swing.Action;
import javax.swing.JComponent;

public class PatternColumnFilter<M>
extends ColumnFilter<M> {
    private static final Logger LOG = Logger.getLogger(PatternColumnFilter.class.getName());
    private ColumnFilter.TextFieldSupport textFieldSupport;

    public PatternColumnFilter(int columnIndex) {
        super(columnIndex);
    }

    public PatternColumnFilter(int columnIndex, IRowFilterModel<M> filterModel) {
        super(columnIndex, filterModel);
    }

    public JYSearchField getFilteringComponent() {
        return (JYSearchField)super.getFilteringComponent();
    }

    @Override
    protected void installActivated(JComponent filteringComponent) {
        this.getTextFieldSupport().installMatchRulePopup((JYSearchField)filteringComponent);
        this.matchValueChanged(null, this.getRowFilterModel().getMatchValue());
    }

    @Override
    protected void doRelease() {
        this.uninstallFieldListener(this.getFilteringComponent());
    }

    @Override
    protected IRowFilterModel<? extends M> createRowFilterModel(int columnIndex) {
        return new PatternRowFilterModel(columnIndex);
    }

    @Override
    protected void matchValueChanged() {
        this.getRowFilterModel().setMatchValue(this.getFilteringComponent().getText());
    }

    @Override
    protected void matchValueChanged(Object oldValue, Object newValue) {
        if (this.areEqual(this.getFilteringComponent().getText(), newValue)) {
            return;
        }
        this.getFilteringComponent().setText((String)newValue);
    }

    @Override
    protected void matchRuleChanged(Object oldValue, Object newValue) {
        this.getTextFieldSupport().selectMatchRuleAction(this.getFilteringComponent(), newValue);
    }

    @Override
    protected void updateComponentsAfterMatchRuleChanged(Object rule) {
        Action target = this.getFilteringComponent().getSearchAction();
        target.putValue("ShortDescription", this.getMatchRuleName(rule));
    }

    protected JYSearchField createFilteringComponent() {
        JYSearchField field = new JYSearchField();
        this.installFieldListeners(field);
        return field;
    }

    private void installFieldListeners(JYSearchField field) {
        this.getTextFieldSupport().addTextField((JYTextField)field);
        field.setSearchAction(this.getTextFieldSupport().createSearchAction());
    }

    private void uninstallFieldListener(JYSearchField field) {
        this.getTextFieldSupport().uninstallMatchRulePopup(field);
        this.getTextFieldSupport().removeTextField((JYTextField)field);
        field.setSearchAction(null);
    }

    private ColumnFilter.TextFieldSupport getTextFieldSupport() {
        if (this.textFieldSupport == null) {
            this.textFieldSupport = new ColumnFilter.TextFieldSupport(true);
        }
        return this.textFieldSupport;
    }
}

