/*
 * Decompiled with CFR 0.152.
 */
package de.javasoft.table.filter;

import de.javasoft.syntheticaaddons.DateComboBox;
import de.javasoft.table.filter.AbstractComparableColumnFilter;
import de.javasoft.table.filter.Boundaries;
import de.javasoft.table.filter.FilterContainer;
import de.javasoft.table.filter.IRowFilterModel;
import de.javasoft.table.sort.RowFilters;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionListener;
import java.text.DateFormat;
import java.util.Date;
import java.util.logging.Logger;
import javax.swing.Action;
import javax.swing.JComponent;
import org.jdesktop.swingx.util.Contract;

public class DateColumnFilter<M>
extends AbstractComparableColumnFilter<M> {
    protected DateComboBox filterField;
    protected DateComboBox toField;
    private Action filterFieldActionListener;
    private static final Logger LOG = Logger.getLogger(DateColumnFilter.class.getName());

    public DateColumnFilter(int columnIndex) {
        super(columnIndex);
    }

    public DateColumnFilter(int columnIndex, IRowFilterModel<M> filterModel) {
        super(columnIndex, filterModel);
    }

    public void setDateFormat(DateFormat format) {
        this.setDateFormats(new DateFormat[]{format});
    }

    public void setDateFormats(DateFormat[] dateFormats) {
        Contract.asNotNull((Object)dateFormats, (String)"formatter/factory must not be null");
        this.getFilteringComponent();
        this.filterField.setDateFormats(dateFormats);
        this.toField.setDateFormats(dateFormats);
    }

    @Override
    protected void doRelease() {
        this.filterField.removeActionListener((ActionListener)this.filterFieldActionListener);
        this.toField.removeActionListener((ActionListener)this.filterFieldActionListener);
        super.doRelease();
    }

    @Override
    protected void matchValueChanged() {
        if (this.getRowFilterModel().getMatchRule() instanceof RowFilters.RangeType) {
            this.getRowFilterModel().setMatchValue(new Boundaries(this.getFrom(), this.getTo()));
        } else {
            this.getRowFilterModel().setMatchValue(this.getFrom());
        }
    }

    @Override
    protected void matchValueChanged(Object oldValue, Object newValue) {
        this.getFilteringComponent();
        if (newValue instanceof Boundaries) {
            Boundaries boundaries = (Boundaries)newValue;
            if (!this.areEqual(this.getFrom(), boundaries.from)) {
                this.setFrom((Date)boundaries.from);
            }
            if (!this.areEqual(this.getTo(), boundaries.to)) {
                this.setTo((Date)boundaries.to);
            }
        } else {
            if (this.areEqual(this.getFrom(), newValue)) {
                return;
            }
            this.setFrom((Date)newValue);
        }
    }

    protected Date getFrom() {
        return this.filterField.getDate();
    }

    protected void setFrom(Date date) {
        this.filterField.setDate(date);
    }

    protected Date getTo() {
        return this.toField.getDate();
    }

    protected void setTo(Date date) {
        this.toField.setDate(date);
    }

    @Override
    protected void updateComponentsAfterMatchRuleChanged(Object rule) {
        super.updateComponentsAfterMatchRuleChanged(rule);
        this.toField.setVisible(this.unwrapMatchRule(rule) instanceof RowFilters.RangeType);
        this.getFilteringComponent().revalidate();
    }

    private void installFilterFieldListeners(DateComboBox field) {
        if (this.filterFieldActionListener == null) {
            this.filterFieldActionListener = this.createMatchValueChangedAction();
        }
        field.addActionListener((ActionListener)this.filterFieldActionListener);
    }

    protected DateComboBox createDateComboBox() {
        DateComboBox toField = new DateComboBox(){

            public Dimension getMinimumSize() {
                Dimension dim = super.getMinimumSize();
                dim.width = 0;
                return dim;
            }
        };
        toField.setInheritsPopupMenu(true);
        toField.setEditable(true);
        toField.setDate(null);
        toField.setCursor(toField.getCursor());
        return toField;
    }

    @Override
    protected JComponent createFilteringComponent() {
        this.filterField = this.createDateComboBox();
        this.installFilterFieldListeners(this.filterField);
        this.toField = this.createDateComboBox();
        this.toField.setVisible(false);
        this.installFilterFieldListeners(this.toField);
        FilterContainer panel = new FilterContainer();
        panel.add((Component)this.getMatchRuleComponent());
        panel.add((Component)this.filterField);
        panel.add((Component)this.toField);
        return panel;
    }
}

