/*
 * Decompiled with CFR 0.152.
 */
package de.javasoft.table.filter;

import de.javasoft.searchfield.JYSearchField;
import de.javasoft.searchfield.ui.controls.SearchActionEvent;
import de.javasoft.syntheticaaddons.SimpleDropDownButton;
import de.javasoft.table.filter.IRowFilterModel;
import de.javasoft.table.filter.SimpleRowFilterModel;
import de.javasoft.table.renderer.StringValues;
import de.javasoft.textfield.JYTextField;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;
import javax.swing.MenuElement;
import javax.swing.RowFilter;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.text.Document;
import org.jdesktop.beans.AbstractBean;
import org.jdesktop.swingx.action.AbstractActionExt;
import org.jdesktop.swingx.action.ActionContainerFactory;

public abstract class ColumnFilter<M>
extends AbstractBean {
    private JComponent filteringComponent;
    private boolean incremental;
    private LifeCycle state = LifeCycle.INSTANTIATED;
    private static String POPUP_VISIBLE = "maybeCommit";
    private IRowFilterModel<? extends M> rowFilterModel;
    private PropertyChangeListener filterModelListener;
    private static final Logger LOG = Logger.getLogger(ColumnFilter.class.getName());

    public ColumnFilter(int columnIndex) {
        this(columnIndex, null);
    }

    protected ColumnFilter(int columnIndex, IRowFilterModel<? extends M> filterModel) {
        this.installRowFilterModel(columnIndex, filterModel);
    }

    public int getColumnIndex() {
        return this.rowFilterModel.getColumnIndex();
    }

    public void setIncremental(boolean incremental) {
        if (this.isIncremental() == incremental) {
            return;
        }
        this.incremental = incremental;
        this.updateIncremental();
    }

    protected void updateIncremental() {
    }

    public boolean isIncremental() {
        return this.incremental;
    }

    public RowFilter<? super M, ? super Integer> getRowFilter() {
        if (LifeCycle.RELEASED == this.state) {
            throw new IllegalStateException("filter must not be accessed after release");
        }
        return this.getRowFilterModel().getRowFilter();
    }

    public void clear() {
        this.getRowFilterModel().setMatchValue(null);
    }

    public JComponent getFilteringComponent() {
        if (LifeCycle.RELEASED == this.state) {
            throw new IllegalStateException("filter must not be accessed after release");
        }
        if (LifeCycle.INSTANTIATED == this.state) {
            this.filteringComponent = this.createFilteringComponent();
            this.state = LifeCycle.ACTIVATED;
            this.installActivated(this.filteringComponent);
        }
        return this.filteringComponent;
    }

    protected void installActivated(JComponent filteringComponent) {
    }

    public void release() {
        if (LifeCycle.ACTIVATED != this.state) {
            this.state = LifeCycle.RELEASED;
            return;
        }
        this.doRelease();
        this.uninstallRowFilterModel();
        this.state = LifeCycle.RELEASED;
    }

    protected abstract void doRelease();

    protected abstract JComponent createFilteringComponent();

    public final LifeCycle getLifeCycle() {
        return this.state;
    }

    protected abstract void matchValueChanged();

    protected Action createMatchValueChangedAction() {
        AbstractActionExt action = new AbstractActionExt(){

            public void actionPerformed(ActionEvent e) {
                ColumnFilter.this.matchValueChanged();
            }
        };
        return action;
    }

    protected Action createClearAction() {
        AbstractActionExt action = new AbstractActionExt(){

            public void actionPerformed(ActionEvent e) {
                ColumnFilter.this.clear();
            }
        };
        return action;
    }

    protected List<?> getMatchRules() {
        return this.getRowFilterModel().getMatchRules();
    }

    protected Object getMatchRule() {
        return this.getRowFilterModel().getMatchRule();
    }

    protected void matchRuleChanged(Object rule) {
        this.updateComponentsAfterMatchRuleChanged(rule);
        this.getRowFilterModel().setMatchRule(this.unwrapMatchRule(rule));
    }

    protected void updateComponentsAfterMatchRuleChanged(Object rule) {
    }

    protected String getMatchRuleName(Object rule) {
        if (rule instanceof AbstractActionExt) {
            return ((AbstractActionExt)rule).getName();
        }
        return rule.toString();
    }

    protected Object unwrapMatchRule(Object rule) {
        if (rule instanceof AbstractActionExt) {
            return ((AbstractActionExt)rule).getValue("matchRule");
        }
        return rule;
    }

    public IRowFilterModel<? extends M> getRowFilterModel() {
        return this.rowFilterModel;
    }

    protected IRowFilterModel<? extends M> createRowFilterModel(int columnIndex) {
        return new SimpleRowFilterModel(columnIndex);
    }

    protected void rowFilterChanged(RowFilter<?, ?> oldValue, RowFilter<?, ?> newValue) {
        this.firePropertyChange("rowFilter", oldValue, newValue);
    }

    protected abstract void matchValueChanged(Object var1, Object var2);

    protected void matchRuleChanged(Object oldValue, Object newValue) {
    }

    protected boolean areEqual(Object oneItem, Object anotherItem) {
        if (oneItem == null && anotherItem == null) {
            return true;
        }
        if (anotherItem != null) {
            return anotherItem.equals(oneItem);
        }
        return false;
    }

    protected PropertyChangeListener createRowFilterModelListener() {
        PropertyChangeListener l = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if ("rowFilter".equals(evt.getPropertyName())) {
                    ColumnFilter.this.rowFilterChanged((RowFilter)evt.getOldValue(), (RowFilter)evt.getNewValue());
                } else if ("matchValue".equals(evt.getPropertyName())) {
                    ColumnFilter.this.matchValueChanged(evt.getOldValue(), evt.getNewValue());
                } else if ("matchRule".equals(evt.getPropertyName())) {
                    ColumnFilter.this.matchRuleChanged(evt.getOldValue(), evt.getNewValue());
                }
            }
        };
        return l;
    }

    protected void installRowFilterModel(int columnIndex, IRowFilterModel<? extends M> filterModel) {
        if (filterModel != null && columnIndex != filterModel.getColumnIndex()) {
            throw new IllegalArgumentException("column index of filter must match thecolumn index of the model, but were: " + columnIndex + " / " + filterModel.getColumnIndex());
        }
        this.rowFilterModel = filterModel == null ? this.createRowFilterModel(columnIndex) : filterModel;
        this.rowFilterModel.addPropertyChangeListener(this.getRowFilterModelListener());
    }

    protected void uninstallRowFilterModel() {
        this.rowFilterModel.removePropertyChangeListener(this.getRowFilterModelListener());
        this.rowFilterModel = null;
    }

    protected PropertyChangeListener getRowFilterModelListener() {
        if (this.filterModelListener == null) {
            this.filterModelListener = this.createRowFilterModelListener();
        }
        return this.filterModelListener;
    }

    public static enum LifeCycle {
        INSTANTIATED,
        ACTIVATED,
        RELEASED;

    }

    protected class PopupSupport {
        private PropertyChangeListener actionPropertyChangeListener;

        protected PopupSupport() {
        }

        public void installMatchRulePopup(SimpleDropDownButton dropDown) {
            List<AbstractActionExt> actions = StringValues.createMatchRuleActions(ColumnFilter.this.getMatchRules(), dropDown.getLocale());
            if (actions.size() == 0) {
                return;
            }
            this.installMatchRulePopup(dropDown.getPopupMenu(), actions);
        }

        public void installMatchRulePopup(JYSearchField field) {
            List<AbstractActionExt> actions = StringValues.createMatchRuleActions(ColumnFilter.this.getMatchRules(), field.getLocale());
            if (actions.size() == 0) {
                return;
            }
            JPopupMenu popup = new JPopupMenu();
            field.setSearchPopupButtonEnabled(Boolean.valueOf(true));
            field.setSearchPopupMenu(popup);
            this.installMatchRulePopup(popup, actions);
        }

        protected void installMatchRulePopup(JPopupMenu popup, List<AbstractActionExt> actions) {
            ActionContainerFactory factory = new ActionContainerFactory(null);
            for (AbstractActionExt action : actions) {
                popup.add(factory.createMenuItem((Action)action));
            }
            this.installActionPropertyChangeListener(actions);
            this.selectInitialMatchRule(actions);
        }

        protected void selectInitialMatchRule(List<AbstractActionExt> actions) {
            Object matchRule = ColumnFilter.this.getMatchRule();
            AbstractActionExt initial = null;
            for (AbstractActionExt action : actions) {
                if (!matchRule.equals(action.getValue("matchRule"))) continue;
                initial = action;
                break;
            }
            if (initial == null) {
                initial = actions.get(0);
            }
            initial.setSelected(true);
        }

        public boolean selectMatchRuleAction(JYSearchField popup, Object matchRule) {
            if (popup.getSearchPopupMenu() == null) {
                return false;
            }
            AbstractActionExt action = this.findRuleAction(popup.getSearchPopupMenu(), matchRule);
            if (action == null || action.isSelected()) {
                return false;
            }
            action.setSelected(true);
            return true;
        }

        public boolean selectMatchRuleAction(JPopupMenu popup, Object matchRule) {
            AbstractActionExt action = this.findRuleAction(popup, matchRule);
            if (action == null || action.isSelected()) {
                return false;
            }
            action.setSelected(true);
            return true;
        }

        protected AbstractActionExt findRuleAction(JPopupMenu popup, Object matchRule) {
            MenuElement[] menuElementArray = popup.getSubElements();
            int n = menuElementArray.length;
            int n2 = 0;
            while (n2 < n) {
                Action action;
                MenuElement menu = menuElementArray[n2];
                if (menu instanceof AbstractButton && (action = ((AbstractButton)((Object)menu)).getAction()) instanceof AbstractActionExt && matchRule.equals(action.getValue("matchRule"))) {
                    return (AbstractActionExt)action;
                }
                ++n2;
            }
            return null;
        }

        public void uninstallMatchRulePopup(JPopupMenu popup) {
            if (popup == null) {
                return;
            }
            int i = 0;
            while (i < popup.getComponentCount()) {
                if (popup.getComponent(i) instanceof AbstractButton) {
                    Action action = ((AbstractButton)popup.getComponent(i)).getAction();
                    action.removePropertyChangeListener(this.getActionPropertyChangeListener());
                }
                ++i;
            }
            popup.removeAll();
        }

        protected void installActionPropertyChangeListener(List<AbstractActionExt> actions) {
            for (AbstractActionExt action : actions) {
                action.addPropertyChangeListener(this.getActionPropertyChangeListener());
            }
        }

        protected PropertyChangeListener getActionPropertyChangeListener() {
            if (this.actionPropertyChangeListener == null) {
                this.actionPropertyChangeListener = this.createActionPropertyChangeListener();
            }
            return this.actionPropertyChangeListener;
        }

        protected PropertyChangeListener createActionPropertyChangeListener() {
            PropertyChangeListener l = new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    if (this.isSelectedProperty(evt.getPropertyName()) && Boolean.TRUE.equals(evt.getNewValue())) {
                        ColumnFilter.this.matchRuleChanged((AbstractActionExt)evt.getSource());
                    }
                }

                protected boolean isSelectedProperty(String property) {
                    return "SwingSelectedKey".equals(property);
                }
            };
            return l;
        }
    }

    protected class TextFieldSupport {
        private List<JYTextField> fields;
        private DocumentListener documentListener;
        private PropertyChangeListener propertyChangeListener;
        private boolean matchOnDocumentChange;
        private FocusListener focusListener;
        private PopupSupport popupSupport;
        private PopupMenuListener popupMenuListener;

        public TextFieldSupport() {
            this(false);
        }

        public TextFieldSupport(boolean matchOnDocumentChange) {
            this.matchOnDocumentChange = matchOnDocumentChange;
        }

        public void addTextField(JYTextField field) {
            if (this.getTextFields().contains(this.fields)) {
                return;
            }
            if (this.matchOnDocumentChange) {
                field.addFocusListener(this.getFocusListener());
            } else {
                field.setEmptyFieldCommittedAsNullValue(true);
                field.addPropertyChangeListener(this.getTextFieldPropertyChangeListener());
            }
            field.getDocument().addDocumentListener(this.getDocumentListener());
            field.setInheritsPopupMenu(true);
            field.setName("JYTable.FilterField");
            field.getActionMap().put("reset-field-edit", ColumnFilter.this.createClearAction());
            field.getInputMap().put(KeyStroke.getKeyStroke("ESCAPE"), "reset-field-edit");
            this.getTextFields().add(field);
        }

        public void removeTextField(JYTextField field) {
            if (!this.getTextFields().remove(field)) {
                return;
            }
            field.getDocument().removeDocumentListener(this.getDocumentListener());
            if (this.matchOnDocumentChange) {
                field.removeFocusListener(this.getFocusListener());
            } else {
                field.removePropertyChangeListener(this.getTextFieldPropertyChangeListener());
            }
            field.getActionMap().remove("reset-field-edit");
        }

        protected void maybeCommitEdit(Document document) {
            if (ColumnFilter.this.isIncremental()) {
                if (this.matchOnDocumentChange) {
                    ColumnFilter.this.matchValueChanged();
                } else {
                    this.commit(this.getTextField(document));
                }
            }
        }

        private void commit(JYTextField field) {
            if (field == null) {
                return;
            }
            try {
                field.commitEdit();
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }

        protected final PropertyChangeListener getTextFieldPropertyChangeListener() {
            if (this.propertyChangeListener == null) {
                this.propertyChangeListener = this.createTextFieldPropertyChangeListener();
            }
            return this.propertyChangeListener;
        }

        protected PropertyChangeListener createTextFieldPropertyChangeListener() {
            return new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    if ("value".equals(evt.getPropertyName())) {
                        ColumnFilter.this.matchValueChanged();
                    } else if ("document".equals(evt.getPropertyName())) {
                        TextFieldSupport.this.updateDocumentListener((Document)evt.getOldValue(), (Document)evt.getNewValue());
                    }
                }
            };
        }

        protected void updateDocumentListener(Document remove, Document add) {
            if (remove != null) {
                remove.removeDocumentListener(this.getDocumentListener());
            }
            if (add != null) {
                add.addDocumentListener(this.getDocumentListener());
            }
        }

        protected final DocumentListener getDocumentListener() {
            if (this.documentListener == null) {
                this.documentListener = this.createDocumentListener();
            }
            return this.documentListener;
        }

        protected DocumentListener createDocumentListener() {
            return new DocumentListener(){

                @Override
                public void removeUpdate(DocumentEvent e) {
                    TextFieldSupport.this.maybeCommitEdit(e.getDocument());
                }

                @Override
                public void insertUpdate(DocumentEvent e) {
                    TextFieldSupport.this.maybeCommitEdit(e.getDocument());
                }

                @Override
                public void changedUpdate(DocumentEvent e) {
                }
            };
        }

        protected final FocusListener getFocusListener() {
            if (this.focusListener == null) {
                this.focusListener = this.createFocusListener();
            }
            return this.focusListener;
        }

        protected FocusListener createFocusListener() {
            return new FocusListener(){

                @Override
                public void focusLost(FocusEvent e) {
                    if (e.isTemporary()) {
                        return;
                    }
                    ColumnFilter.this.matchValueChanged();
                }

                @Override
                public void focusGained(FocusEvent e) {
                }
            };
        }

        protected JYTextField getTextField(Document document) {
            for (JYTextField field : this.getTextFields()) {
                if (field.getDocument() != document) continue;
                return field;
            }
            return null;
        }

        protected List<JYTextField> getTextFields() {
            if (this.fields == null) {
                this.fields = new ArrayList<JYTextField>();
            }
            return this.fields;
        }

        public Action createSearchAction() {
            AbstractActionExt searchAction = new AbstractActionExt(){

                public void actionPerformed(ActionEvent e) {
                    if (e instanceof SearchActionEvent) {
                        SearchActionEvent se = (SearchActionEvent)e;
                        if (SearchActionEvent.Initiator.SEARCH_POPUP_BUTTON == se.getInitiator()) {
                            return;
                        }
                        if (!(ColumnFilter.this.isIncremental() || SearchActionEvent.Initiator.SEARCH_BUTTON != se.getInitiator() && SearchActionEvent.Initiator.CLEAR_BUTTON != se.getInitiator())) {
                            TextFieldSupport.this.commit((JYTextField)e.getSource());
                        }
                    }
                    ColumnFilter.this.matchValueChanged();
                }
            };
            return searchAction;
        }

        public void installMatchRulePopup(JYSearchField field) {
            if (!this.getTextFields().contains(field)) {
                throw new IllegalArgumentException("field must be controlled by this, but was: " + field);
            }
            this.getPopupSupport().installMatchRulePopup(field);
            if (field.getSearchPopupMenu() != null) {
                field.getSearchPopupMenu().addPopupMenuListener(this.getPopupMenuListener());
            }
        }

        public boolean selectMatchRuleAction(JYSearchField field, Object matchRule) {
            if (!this.getTextFields().contains(field)) {
                throw new IllegalArgumentException("field must be controlled by this, but was: " + field);
            }
            return this.getPopupSupport().selectMatchRuleAction(field, matchRule);
        }

        protected PopupMenuListener getPopupMenuListener() {
            if (this.popupMenuListener == null) {
                this.popupMenuListener = this.createPopupMenuListener();
            }
            return this.popupMenuListener;
        }

        protected PopupMenuListener createPopupMenuListener() {
            PopupMenuListener l = new PopupMenuListener(){

                @Override
                public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
                    this.getPopupMenu(e).putClientProperty(POPUP_VISIBLE, Boolean.TRUE);
                }

                @Override
                public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
                    if (this.getPopupMenu(e).getClientProperty(POPUP_VISIBLE) != null) {
                        TextFieldSupport.this.maybeCommitEdit(this.getPopupMenu(e));
                    }
                    this.getPopupMenu(e).putClientProperty(POPUP_VISIBLE, null);
                }

                private JPopupMenu getPopupMenu(PopupMenuEvent e) {
                    return (JPopupMenu)e.getSource();
                }

                @Override
                public void popupMenuCanceled(PopupMenuEvent e) {
                    this.getPopupMenu(e).putClientProperty(POPUP_VISIBLE, null);
                }
            };
            return l;
        }

        protected void maybeCommitEdit(JPopupMenu source) {
            if (!ColumnFilter.this.isIncremental()) {
                if (this.matchOnDocumentChange) {
                    ColumnFilter.this.matchValueChanged();
                } else {
                    for (JYTextField field : this.getTextFields()) {
                        this.commit(field);
                    }
                }
            }
        }

        public void uninstallMatchRulePopup(JYSearchField field) {
            if (!this.getTextFields().contains(field)) {
                throw new IllegalArgumentException("field must be controlled by this, but was: " + field);
            }
            if (field.getSearchPopupMenu() != null) {
                field.getSearchPopupMenu().removePopupMenuListener(this.getPopupMenuListener());
            }
            this.getPopupSupport().uninstallMatchRulePopup(field.getSearchPopupMenu());
        }

        protected PopupSupport getPopupSupport() {
            if (this.popupSupport == null) {
                this.popupSupport = this.createPopupSupport();
            }
            return this.popupSupport;
        }

        protected PopupSupport createPopupSupport() {
            return new PopupSupport();
        }
    }
}

