/*
 * Decompiled with CFR 0.152.
 */
package de.javasoft.table.filter;

import de.javasoft.table.filter.ColumnFilter;
import de.javasoft.table.renderer.ObjectWrapper;
import de.javasoft.table.renderer.StringValues;
import java.awt.event.ActionEvent;
import javax.swing.Action;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import org.jdesktop.swingx.action.AbstractActionExt;
import org.jdesktop.swingx.renderer.StringValue;

public class BooleanColumnFilter<M>
extends ColumnFilter<M> {
    private StringValue stringValue;

    public BooleanColumnFilter(int columnIndex) {
        super(columnIndex);
        this.updateFilteringComponentModel();
    }

    public void setStringValue(StringValue sv) {
        this.stringValue = sv;
        this.updateFilteringComponentModel();
    }

    public StringValue getStringValue() {
        if (this.stringValue == null) {
            this.stringValue = StringValues.createYesNoLookup();
        }
        return this.stringValue;
    }

    @Override
    protected void doRelease() {
        this.uninstallComboBoxListener((JComboBox<?>)this.getFilteringComponent());
    }

    @Override
    public JComboBox<?> getFilteringComponent() {
        return (JComboBox)super.getFilteringComponent();
    }

    @Override
    protected void matchValueChanged() {
        Object item = ((JComboBox)this.getFilteringComponent()).getSelectedItem();
        if (item instanceof ObjectWrapper) {
            item = ((ObjectWrapper)item).getValue();
        }
        this.getRowFilterModel().setMatchValue(item);
    }

    @Override
    protected void matchValueChanged(Object oldValue, Object newValue) {
        int index = this.findIndexOf(newValue);
        if (((JComboBox)this.getFilteringComponent()).getSelectedIndex() == index) {
            return;
        }
        if (index < 0 && newValue != null) {
            this.clearSelectionSilently();
        } else {
            ((JComboBox)this.getFilteringComponent()).setSelectedIndex(index);
        }
    }

    private void clearSelectionSilently() {
        Action action = ((JComboBox)this.getFilteringComponent()).getAction();
        ((JComboBox)this.getFilteringComponent()).setAction(null);
        ((JComboBox)this.getFilteringComponent()).setSelectedIndex(0);
        ((JComboBox)this.getFilteringComponent()).setAction(action);
    }

    private int findIndexOf(Object newValue) {
        int index = -1;
        ComboBoxModel model = ((JComboBox)this.getFilteringComponent()).getModel();
        int i = 0;
        while (i < model.getSize()) {
            Object element = model.getElementAt(i);
            if (element instanceof ObjectWrapper) {
                element = ((ObjectWrapper)element).getValue();
            }
            if (this.areEqual(newValue, element)) {
                return i;
            }
            ++i;
        }
        return index;
    }

    protected void updateFilteringComponentModel() {
        DefaultComboBoxModel<Object> model = new DefaultComboBoxModel<Object>(new Object[]{new ObjectWrapper(null, this.getStringValue()), new ObjectWrapper(Boolean.TRUE, this.getStringValue()), new ObjectWrapper(Boolean.FALSE, this.getStringValue())});
        ((JComboBox)this.getFilteringComponent()).setModel(model);
    }

    @Override
    protected JComboBox<?> createFilteringComponent() {
        JComboBox box = new JComboBox();
        box.setInheritsPopupMenu(true);
        box.setCursor(box.getCursor());
        this.installComboBoxListener(box);
        return box;
    }

    private void installComboBoxListener(final JComboBox<?> box) {
        box.setAction(this.createMatchValueChangedAction());
        final Action delegate = box.getActionMap().get("hidePopup");
        AbstractActionExt wrapper = new AbstractActionExt(){
            Action clear;
            {
                this.clear = BooleanColumnFilter.this.createClearAction();
            }

            public void actionPerformed(ActionEvent e) {
                if (box.isPopupVisible()) {
                    delegate.actionPerformed(e);
                } else {
                    this.clear.actionPerformed(e);
                }
            }
        };
        box.getActionMap().put("hidePopup", (Action)wrapper);
    }

    private void uninstallComboBoxListener(JComboBox<?> box) {
        box.setAction(null);
        box.getActionMap().remove("hidePopup");
    }
}

