/*
 * Decompiled with CFR 0.152.
 */
package de.javasoft.table.filter;

import de.javasoft.table.filter.IRowFilterModel;
import java.util.Collections;
import java.util.List;
import javax.swing.RowFilter;
import org.jdesktop.beans.AbstractBean;

public abstract class AbstractRowFilterModel<M>
extends AbstractBean
implements IRowFilterModel<M> {
    private int columnIndex;
    private Object matchValue;
    private Object matchRule;
    private RowFilter<? super M, ? super Integer> rowFilter;

    protected AbstractRowFilterModel() {
        this(0);
    }

    protected AbstractRowFilterModel(int columnIndex) {
        this.columnIndex = columnIndex;
    }

    @Override
    public RowFilter<? super M, ? super Integer> getRowFilter() {
        return this.rowFilter;
    }

    @Override
    public int getColumnIndex() {
        return this.columnIndex;
    }

    @Override
    public List<?> getMatchRules() {
        return Collections.emptyList();
    }

    @Override
    public void setMatchRule(Object matchRule) {
        if (!this.getMatchRules().contains(matchRule)) {
            throw new IllegalArgumentException("unknown match rule: " + matchRule);
        }
        if (this.getMatchRule() == matchRule) {
            return;
        }
        Object old = this.getMatchRule();
        this.matchRule = matchRule;
        this.setRowFilter(this.createRowFilter());
        this.firePropertyChange("matchRule", old, this.getMatchRule());
    }

    @Override
    public Object getMatchRule() {
        return this.matchRule;
    }

    @Override
    public void setMatchValue(Object matchValue) {
        if (this.areEqual(matchValue, this.getMatchValue())) {
            return;
        }
        Object old = this.getMatchValue();
        this.matchValue = matchValue;
        this.setRowFilter(this.createRowFilter());
        this.firePropertyChange("matchValue", old, this.getMatchValue());
    }

    @Override
    public Object getMatchValue() {
        return this.matchValue;
    }

    protected final void setRowFilter(RowFilter<? super M, ? super Integer> filter) {
        RowFilter<M, Integer> old = this.getRowFilter();
        this.rowFilter = filter;
        this.firePropertyChange("rowFilter", old, this.getRowFilter());
    }

    protected abstract RowFilter<? super M, ? super Integer> createRowFilter();

    protected boolean areEqual(Object oneItem, Object anotherItem) {
        if (oneItem == null && anotherItem == null) {
            return true;
        }
        if (anotherItem != null) {
            return anotherItem.equals(oneItem);
        }
        return false;
    }

    protected void setInitialMatchRule(Object matchRule) {
        List<?> rules = this.getMatchRules();
        if (rules.size() == 0) {
            return;
        }
        Object initial = rules.get(0);
        if (rules.contains(matchRule)) {
            initial = matchRule;
        }
        this.setMatchRule(initial);
    }
}

