/*
 * Decompiled with CFR 0.152.
 */
package de.javasoft.table.controls;

import de.javasoft.plaf.synthetica.SyntheticaLookAndFeel;
import de.javasoft.plaf.synthetica.SyntheticaState;
import de.javasoft.widgets.JYButtonIcon;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.GeneralPath;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.JPopupMenu;
import javax.swing.UIManager;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.synth.SynthContext;
import org.jdesktop.swingx.JXTable;
import org.jdesktop.swingx.table.ColumnControlButton;
import org.jdesktop.swingx.table.ColumnControlPopup;

public class JYTableColumnControlButton
extends ColumnControlButton {
    public JYTableColumnControlButton(JXTable table) {
        super(table);
    }

    public JYTableColumnControlButton(JXTable table, Icon icon) {
        super(table, icon);
    }

    public JPopupMenu getPopupMenu() {
        PublicColumnControlPopup popup = (PublicColumnControlPopup)this.getColumnControlPopup();
        return popup.getPopupMenu();
    }

    protected ColumnControlPopup createColumnControlPopup() {
        return new PublicColumnControlPopup();
    }

    protected void updateActionUI() {
        if (this.getAction() == null) {
            return;
        }
        Object icon = (Icon)this.getAction().getValue("SmallIcon");
        if (icon == null || icon instanceof UIResource) {
            icon = new ColumnControlIcon((AbstractButton)((Object)this), "JYTable.columnControlButton.icon", 10, 10);
            this.getAction().putValue("SmallIcon", icon);
        }
    }

    private static class ColumnControlIcon
    extends JYButtonIcon {
        private AbstractButton b;

        public ColumnControlIcon(AbstractButton b, String uiKey, int width, int height) {
            super(b, uiKey, width, height);
            this.b = b;
        }

        private Color getPaintColor(SyntheticaState state) {
            Color color = UIManager.getColor("Button.foreground");
            boolean isDarkForeground = (double)Color.RGBtoHSB(color.getRed(), color.getGreen(), color.getBlue(), new float[3])[2] < 0.5;
            int alpha = 255;
            if (state.isSet(SyntheticaState.State.DISABLED)) {
                alpha = isDarkForeground ? 80 : 96;
            } else if (state.isSet(SyntheticaState.State.PRESSED)) {
                alpha = 255;
            } else if (state.isSet(SyntheticaState.State.HOVER)) {
                alpha = isDarkForeground ? 136 : 255;
            }
            int rgba = alpha << 24 | 0xFFFFFF & color.getRGB();
            return new Color(rgba, true);
        }

        public void paintFallback2DIcon(SynthContext sc, SyntheticaState state, Graphics2D g2, float x, float y, float w, float h) {
            g2.setPaint(this.getPaintColor(state));
            boolean ltr = this.b.getComponentOrientation().isLeftToRight();
            int xOffset = SyntheticaLookAndFeel.getInt((String)"JYTable.columnControlButton.defaultIcon.xOffset", null, (int)0);
            int yOffset = SyntheticaLookAndFeel.getInt((String)"JYTable.columnControlButton.defaultIcon.yOffset", null, (int)0);
            float corr = xOffset != 0 ? 0.0f : (this.b.getWidth() % 2 == 0 && !ltr ? -1.0f : 0.0f);
            float x_ = w / 2.0f + (float)xOffset + corr;
            float y_ = h / 2.0f + 0.0f + (float)yOffset;
            Shape s = this.createTableShape(x_, y_);
            g2.draw(s);
            y_ = h / 2.0f + (float)yOffset;
            s = this.createArrowShape(x_, y_, ltr);
            g2.fill(s);
            g2.draw(s);
        }

        private Shape createArrowShape(float x, float y, boolean ltr) {
            GeneralPath path = new GeneralPath();
            float o = ltr ? 1.0f : -1.0f;
            path.moveTo(x - 1.5f * o, y + 1.5f);
            path.lineTo(x + 4.5f * o, y + 1.5f);
            path.lineTo(x + 1.5f * o, y + 4.5f);
            path.closePath();
            return path;
        }

        private Shape createTableShape(float x, float y) {
            GeneralPath path = new GeneralPath();
            path.moveTo(x - 4.5f, y - 4.5f);
            path.lineTo(x + 3.5f, y - 4.5f);
            path.moveTo(x - 4.5f, y - 2.5f);
            path.lineTo(x + 3.5f, y - 2.5f);
            path.moveTo(x - 4.5f, y - 4.5f);
            path.lineTo(x - 4.5f, y + 3.5f);
            path.moveTo(x - 0.5f, y - 4.5f);
            path.lineTo(x - 0.5f, y - 0.5f);
            path.moveTo(x + 3.5f, y - 4.5f);
            path.lineTo(x + 3.5f, y - 0.5f);
            path.moveTo(x - 4.5f, y + 3.5f);
            path.lineTo(x - 2.5f, y + 3.5f);
            return path;
        }

        public int getCacheHash(SynthContext sc, int w, int h, int meta, String id) {
            int hash = super.getCacheHash(sc, w, h, meta, id);
            hash = 31 * hash + (this.b.getComponentOrientation().isLeftToRight() ? 0 : 1);
            return hash;
        }
    }

    protected class PublicColumnControlPopup
    extends ColumnControlButton.DefaultColumnControlPopup {
        protected PublicColumnControlPopup() {
            super((ColumnControlButton)JYTableColumnControlButton.this);
        }

        public JPopupMenu getPopupMenu() {
            return super.getPopupMenu();
        }
    }
}

