/*
 * Decompiled with CFR 0.152.
 */
package de.javasoft.table;

import de.javasoft.syntheticaaddons.SyntheticaAddons;
import de.javasoft.table.JYTableHeader;
import de.javasoft.table.JYTableScrollPane;
import de.javasoft.table.controls.JYTableColumnControlButton;
import de.javasoft.table.controls.JYTableColumnFactory;
import de.javasoft.table.controls.TableColumnResizer;
import de.javasoft.table.filter.FilterRowController;
import de.javasoft.table.filter.IColumnFilterFactory;
import de.javasoft.table.sort.ISortController;
import de.javasoft.table.sort.JYTableSortController;
import de.javasoft.table.ui.addons.JYTableAddon;
import java.awt.ComponentOrientation;
import java.awt.Container;
import java.util.Date;
import java.util.Locale;
import java.util.Vector;
import java.util.logging.Logger;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JViewport;
import javax.swing.ListSelectionModel;
import javax.swing.RowSorter;
import javax.swing.SortOrder;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import org.jdesktop.swingx.JXTable;
import org.jdesktop.swingx.action.BoundAction;
import org.jdesktop.swingx.plaf.ComponentAddon;
import org.jdesktop.swingx.table.ColumnFactory;

public class JYTable
extends JXTable {
    private static final Logger LOG = Logger.getLogger(JYTable.class.getName());
    private static final long serialVersionUID = -3368205110339290756L;
    public static final String FILTER_ROW_ACTION_COMMAND = "column.filterRow";
    private boolean initDone;
    private boolean filterRowVisible;
    private FilterRowController filterRowController;
    private boolean columnResizable;
    private TableColumnResizer columnResizer;

    static {
        SyntheticaAddons.contribute((ComponentAddon)new JYTableAddon());
    }

    public void setColumnControlVisible(boolean visible) {
        super.setColumnControlVisible(visible);
        if (this.isColumnControlVisible()) {
            this.setHeaderComponentPopupMenu();
        }
    }

    private void setHeaderComponentPopupMenu() {
        if (this.canSetHeaderComponentPopupMenu()) {
            JPopupMenu menu = ((JYTableColumnControlButton)((Object)this.getColumnControl())).getPopupMenu();
            this.getTableHeader().setComponentPopupMenu(menu);
        }
    }

    private boolean canSetHeaderComponentPopupMenu() {
        return this.getTableHeader() != null && this.getColumnControl() instanceof JYTableColumnControlButton;
    }

    public void setTableHeader(JTableHeader tableHeader) {
        JTableHeader old = this.getTableHeader();
        super.setTableHeader(tableHeader);
        if (old != null) {
            old.setComponentPopupMenu(null);
        }
        if (this.isColumnControlVisible()) {
            this.setHeaderComponentPopupMenu();
        }
    }

    public void setFilterRowVisible(boolean filterRowVisible) {
        if (this.isFilterRowVisible() == filterRowVisible) {
            return;
        }
        boolean old = this.isFilterRowVisible();
        if (old) {
            this.unconfigureFilterRow();
        }
        this.filterRowVisible = filterRowVisible;
        if (this.isFilterRowVisible()) {
            this.configureFilterRow();
        }
        this.updateFilterRowVisibleAction();
        this.firePropertyChange("filterRowVisible", old, this.isFilterRowVisible());
    }

    public boolean isFilterRowVisible() {
        return this.filterRowVisible;
    }

    protected void updateFilterRowVisibleAction() {
        Action action = this.getActionMap().get(FILTER_ROW_ACTION_COMMAND);
        if (action instanceof BoundAction) {
            ((BoundAction)action).setSelected(this.isFilterRowVisible());
        }
    }

    public IColumnFilterFactory<? extends TableModel> getDefaultColumnFilterFactory(Class<?> clazz) {
        return this.getFilterRowController().getDefaultColumnFilterFactory(clazz);
    }

    public void setDefaultColumnFilterFactory(Class<?> clazz, IColumnFilterFactory<? extends TableModel> factory) {
        this.getFilterRowController().setDefaultColumnFilterFactory(clazz, factory);
    }

    public boolean isIncrementalFilter() {
        return this.getFilterRowController().isIncremental();
    }

    public void setIncrementalFilter(boolean incremental) {
        this.getFilterRowController().setIncremental(incremental);
    }

    public JComponent getFilterRow() {
        return this.getFilterRowController().getFilterRow();
    }

    protected void configureEnclosingScrollPane() {
        super.configureEnclosingScrollPane();
        this.configureFilterRow();
    }

    protected void unconfigureEnclosingScrollPane() {
        this.unconfigureFilterRow();
        super.unconfigureEnclosingScrollPane();
    }

    protected void configureFilterRow() {
        Container gp;
        if (!this.isFilterRowVisible()) {
            return;
        }
        Container p = this.getParent();
        if (p instanceof JViewport && (gp = p.getParent()) instanceof JYTableScrollPane) {
            JYTableScrollPane scrollPane = (JYTableScrollPane)gp;
            scrollPane.addColumnSubHeaderView(this.getFilterRow(), this.getFilterRowController().getFilterRowCorner());
        }
    }

    protected void unconfigureFilterRow() {
        Container gp;
        Container p = this.getParent();
        if (p instanceof JViewport && (gp = p.getParent()) instanceof JYTableScrollPane) {
            JYTableScrollPane scrollPane = (JYTableScrollPane)gp;
            scrollPane.removeColumnSubHeaderView(this.getFilterRow());
        }
    }

    public FilterRowController getFilterRowController() {
        if (this.filterRowController == null) {
            this.filterRowController = this.createDefaultFilterRowController();
        }
        return this.filterRowController;
    }

    protected FilterRowController createDefaultFilterRowController() {
        return new FilterRowController(this);
    }

    public ColumnFactory getColumnFactory() {
        JYTableColumnFactory.checkInstanceY();
        return super.getColumnFactory();
    }

    public int getSortIndex(int columnIndex) {
        if (this.hasSortController()) {
            return this.getSortController().getSortIndex(this.convertColumnIndexToModel(columnIndex));
        }
        return -1;
    }

    public int getSortCount() {
        if (this.hasSortController()) {
            return this.getSortController().getSortCount();
        }
        return 0;
    }

    public void toggleSortOrder(int columnIndex, boolean isMultipleSort) {
        if (this.hasSortController()) {
            this.getSortController().toggleSortOrder(this.convertColumnIndexToModel(columnIndex), isMultipleSort);
        }
    }

    public void toggleSortOrder(int columnIndex) {
        this.toggleSortOrder(columnIndex, false);
    }

    public void setRowSorter(RowSorter<? extends TableModel> sorter) {
        super.setRowSorter(sorter);
    }

    protected RowSorter<? extends TableModel> createDefaultRowSorter() {
        return new JYTableSortController<TableModel>(this.getModel());
    }

    protected ISortController<? extends TableModel> getSortController() {
        if (this.hasSortController()) {
            return (ISortController)((Object)this.getRowSorter());
        }
        return null;
    }

    protected boolean hasSortController() {
        return this.getRowSorter() instanceof ISortController;
    }

    public boolean isColumnResizable() {
        return this.columnResizable;
    }

    public void setColumnResizable(boolean resizable) {
        if (this.isColumnResizable() == resizable) {
            return;
        }
        this.columnResizable = resizable;
        this.updateTableColumnResizer();
        this.firePropertyChange("columnResizable", !resizable, this.isColumnResizable());
    }

    private void updateTableColumnResizer() {
        if (this.isColumnResizable()) {
            if (this.columnResizer == null) {
                this.columnResizer = new TableColumnResizer(this);
            }
        } else if (this.columnResizer != null) {
            this.columnResizer.release();
            this.columnResizer = null;
        }
    }

    protected JTableHeader createDefaultTableHeader() {
        return new JYTableHeader(this.columnModel);
    }

    protected JComponent createDefaultColumnControl() {
        return new JYTableColumnControlButton(this);
    }

    public void setComponentOrientation(ComponentOrientation o) {
        this.forceUnconfigureColumnControlCorner();
        super.setComponentOrientation(o);
    }

    protected void forceUnconfigureColumnControlCorner() {
        JScrollPane pane = this.getEnclosingScrollPane();
        if (pane != null && this.isColumnControlVisible()) {
            this.forceUnconfigureColumnControlCorner(pane, "UPPER_RIGHT_CORNER", "UPPER_LEFT_CORNER");
        }
    }

    private void forceUnconfigureColumnControlCorner(JScrollPane pane, String ... constraints) {
        String[] stringArray = constraints;
        int n = constraints.length;
        int n2 = 0;
        while (n2 < n) {
            String constraint = stringArray[n2];
            if (this.getColumnControl() == pane.getCorner(constraint)) {
                pane.setCorner(constraint, null);
            }
            ++n2;
        }
    }

    protected JScrollPane getEnclosingScrollPane() {
        Container gp;
        Container p = this.getParent();
        if (p instanceof JViewport && (gp = p.getParent()) instanceof JScrollPane) {
            JScrollPane scrollPane = (JScrollPane)gp;
            JViewport viewport = scrollPane.getViewport();
            if (viewport == null || viewport.getView() != this) {
                return null;
            }
            return scrollPane;
        }
        return null;
    }

    protected void createDefaultRenderers() {
        if (this.useCoreRenderers()) {
            this.createCoreRenderers();
        } else {
            this.createXRenderers();
        }
    }

    protected void createXRenderers() {
        super.createDefaultRenderers();
    }

    protected boolean useCoreRenderers() {
        return Boolean.TRUE.equals(UIManager.get("Table.useCoreRenderers"));
    }

    protected void createCoreRenderers() {
        final UIDefaults coreRenderers = new UIDefaults(8, 0.75f);
        JTable core = new JTable(){

            @Override
            protected void createDefaultRenderers() {
                super.createDefaultRenderers();
                coreRenderers.put(Object.class, this.getDefaultRenderer(Object.class));
                coreRenderers.put(Number.class, this.getDefaultRenderer(Number.class));
                coreRenderers.put(Float.class, this.getDefaultRenderer(Float.class));
                coreRenderers.put(Double.class, this.getDefaultRenderer(Double.class));
                coreRenderers.put(Date.class, this.getDefaultRenderer(Date.class));
                coreRenderers.put(Icon.class, this.getDefaultRenderer(Icon.class));
                coreRenderers.put(ImageIcon.class, this.getDefaultRenderer(Icon.class));
                coreRenderers.put(Boolean.class, this.getDefaultRenderer(Boolean.class));
            }
        };
        this.defaultRenderersByColumnClass = new UIDefaults(8, 0.75f);
        this.setDefaultRenderer(Object.class, (TableCellRenderer)coreRenderers.get(Object.class));
        this.setDefaultRenderer(Number.class, (TableCellRenderer)coreRenderers.get(Number.class));
        this.setDefaultRenderer(Float.class, (TableCellRenderer)coreRenderers.get(Float.class));
        this.setDefaultRenderer(Double.class, (TableCellRenderer)coreRenderers.get(Double.class));
        this.setDefaultRenderer(Date.class, (TableCellRenderer)coreRenderers.get(Date.class));
        this.setDefaultRenderer(Icon.class, (TableCellRenderer)coreRenderers.get(Icon.class));
        this.setDefaultRenderer(ImageIcon.class, (TableCellRenderer)coreRenderers.get(Icon.class));
        this.setDefaultRenderer(Boolean.class, (TableCellRenderer)coreRenderers.get(Boolean.class));
    }

    protected void updateLocaleState(Locale locale) {
        super.updateLocaleState(locale);
        Object[] objectArray = this.getActionMap().allKeys();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object key = objectArray[n2];
            if (this.isColumnControlActionKey(key)) {
                this.updateLocaleActionState((String)key, locale);
            }
            ++n2;
        }
    }

    protected void updateLocaleActionState(String key, Locale locale) {
        String toolTip;
        super.updateLocaleActionState(key, locale);
        Action action = this.getActionMap().get(key);
        if (action == null) {
            return;
        }
        String toolTipKey = String.valueOf(key) + ".toolTip";
        if (!toolTipKey.equals(toolTip = this.getUIString(toolTipKey, locale))) {
            action.putValue("ShortDescription", toolTip);
        }
    }

    protected boolean isColumnControlActionKey(Object actionKey) {
        return actionKey instanceof String && ((String)actionKey).startsWith("column.");
    }

    private void init() {
        this.setFilterRowVisible(true);
        this.setColumnResizable(true);
        this.setSortOrderCycle(new SortOrder[]{SortOrder.ASCENDING, SortOrder.DESCENDING, SortOrder.UNSORTED});
        this.initActionsAndBindings();
        this.updateLocaleState(this.getLocale());
        this.setColumnControlVisible(true);
        this.initDone = true;
    }

    private void initActionsAndBindings() {
        this.getActionMap().put(FILTER_ROW_ACTION_COMMAND, this.createToggleFilterRowAction());
    }

    private Action createToggleFilterRowAction() {
        BoundAction action = new BoundAction(null, FILTER_ROW_ACTION_COMMAND);
        action.setStateAction();
        action.registerCallback((Object)this, "setFilterRowVisible");
        action.setSelected(this.isFilterRowVisible());
        return action;
    }

    public JYTable() {
        this.init();
    }

    public JYTable(int numRows, int numColumns) {
        super(numRows, numColumns);
        this.init();
    }

    public JYTable(Object[][] rowData, Object[] columnNames) {
        super(rowData, columnNames);
        this.init();
    }

    public JYTable(TableModel dm, TableColumnModel cm, ListSelectionModel sm) {
        super(dm, cm, sm);
        this.init();
    }

    public JYTable(TableModel dm, TableColumnModel cm) {
        super(dm, cm);
        this.init();
    }

    public JYTable(Vector<? extends Vector<?>> rowData, Vector<?> columnNames) {
        super(rowData, columnNames);
        this.init();
    }

    public JYTable(TableModel model) {
        super(model);
        this.init();
    }

    public String getUIClassID() {
        return super.getUIClassID();
    }

    public void updateUI() {
        super.updateUI();
        if (this.initDone && !this.isFilterRowVisible()) {
            this.getFilterRowController().updateUI();
        }
    }
}

