/*
 * Decompiled with CFR 0.152.
 */
package de.javasoft.docking.ui.painter;

import de.javasoft.docking.controls.Dockbar;
import de.javasoft.docking.ui.BasicDockingPainter;
import de.javasoft.plaf.synthetica.SyntheticaState;
import de.javasoft.plaf.synthetica.painter.ImagePainter;
import de.javasoft.plaf.synthetica.painter.SyntheticaAddonsPainter;
import de.javasoft.plaf.synthetica.painter.SyntheticaComponentPainter;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.JComponent;

public class DockingPainter
extends BasicDockingPainter {
    public static SyntheticaAddonsPainter getInstance() {
        SyntheticaComponentPainter instance = (SyntheticaComponentPainter)instances.get(DockingPainter.getPainterClassName(null, DockingPainter.class, (String)"Synthetica.DockingPainter"));
        if (instance == null) {
            instance = DockingPainter.getInstance(null, DockingPainter.class, (String)"Synthetica.DockingPainter");
        }
        return (SyntheticaAddonsPainter)instance;
    }

    @Override
    public void paintDockingTitleBarBackground(JComponent c, SyntheticaState state, Graphics g, int x, int y, int w, int h) {
        Insets sInsets;
        String imagePath = "Synthetica.docking.titlebar.background.image";
        if (state.isSet(SyntheticaState.State.SELECTED)) {
            imagePath = String.valueOf(imagePath) + ".selected";
        }
        imagePath = this.resolveImagePath(imagePath, c);
        Insets dInsets = sInsets = this.getImageInsets("Synthetica.docking.titlebar.background.image.insets", c);
        ImagePainter imagePainter = new ImagePainter(g, x, y, w, h, imagePath, sInsets, dInsets, 0, 0);
        imagePainter.draw();
    }

    @Override
    public void paintDockingContentPaneBackground(JComponent c, SyntheticaState state, Graphics g, int x, int y, int w, int h) {
        Boolean opaque = c.getClientProperty("Synthetica.opaque") == null ? true : (Boolean)c.getClientProperty("Synthetica.opaque");
        if (opaque.booleanValue()) {
            String imagePath = null;
            if (state.isSet(SyntheticaState.State.SELECTED)) {
                imagePath = this.resolveImagePath("Synthetica.docking.contentPane.background.image.selected", c);
            }
            if (imagePath == null) {
                imagePath = this.resolveImagePath("Synthetica.docking.contentPane.background.image", c);
            }
            if (imagePath == null) {
                super.paintDockingContentPaneBackground(c, state, g, x, y, w, h);
                return;
            }
            Insets sInsets = this.getImageInsets("Synthetica.docking.contentPane.background.image.insets", c);
            ImagePainter imagePainter = new ImagePainter(g, x, y, w, h, imagePath, sInsets, sInsets, 0, 0);
            imagePainter.draw();
        }
    }

    @Override
    public void paintDockingDockbarBackground(JComponent c, SyntheticaState state, Graphics g, int x, int y, int w, int h, int placement) {
        Insets sInsets;
        String placement_ = Dockbar.placementAsString(placement);
        String imagePath = "Synthetica.docking.dockbar." + placement_ + ".background.image";
        if ((imagePath = this.resolveImagePath(imagePath, c)) == null) {
            super.paintDockingDockbarBackground(c, state, g, x, y, w, h, placement);
            return;
        }
        Insets dInsets = sInsets = this.getImageInsets("Synthetica.docking.dockbar." + placement_ + ".background.image.insets", c);
        ImagePainter imagePainter = new ImagePainter(g, x, y, w, h, imagePath, sInsets, dInsets, 0, 0);
        imagePainter.draw();
    }

    @Override
    public void paintDockingDockbarLabelBackground(JComponent c, SyntheticaState state, Graphics g, int x, int y, int w, int h, int placement) {
        String placement_ = Dockbar.placementAsString(placement);
        boolean placementSupport = true;
        String imagePath = "Synthetica.docking.dockbarLabel." + placement_ + ".background.image";
        if ((imagePath = this.resolveImagePath(imagePath, c)) == null) {
            placementSupport = false;
            imagePath = this.resolveImagePath("Synthetica.docking.dockbarLabel.background.image", c);
        }
        if (imagePath == null) {
            super.paintDockingDockbarLabelBackground(c, state, g, x, y, w, h, placement);
            return;
        }
        if (placementSupport) {
            Insets sInsets = this.getImageInsets("Synthetica.docking.dockbarLabel." + placement_ + ".background.image.insets", c);
            ImagePainter imagePainter = new ImagePainter(g, x, y, w, h, imagePath, sInsets, sInsets, 0, 0);
            imagePainter.draw();
        } else {
            Insets sInsets;
            Insets dInsets = sInsets = this.getImageInsets("Synthetica.docking.dockbarLabel.background.image.insets", c);
            int angle = placement == 3 ? 0 : -90;
            ImagePainter imagePainter = new ImagePainter(g, x, y, angle == 0 ? w : h, angle == 0 ? h : w, imagePath, sInsets, dInsets, 0, 0);
            imagePainter.setAngle(angle);
            imagePainter.draw();
        }
    }

    @Override
    public void paintDockingSlidePanelBackground(JComponent c, SyntheticaState state, Graphics g, int x, int y, int w, int h, int placement) {
        Insets sInsets;
        String placement_ = Dockbar.placementAsString(placement);
        String imagePath = "Synthetica.docking.slidePanel." + placement_ + ".background.image";
        if ((imagePath = this.resolveImagePath(imagePath, c)) == null) {
            super.paintDockingSlidePanelBackground(c, state, g, x, y, w, h, placement);
            return;
        }
        Insets dInsets = sInsets = this.getImageInsets("Synthetica.docking.slidePanel." + placement_ + ".background.image.insets", c);
        ImagePainter imagePainter = new ImagePainter(g, x, y, w, h, imagePath, sInsets, dInsets, 0, 0);
        imagePainter.draw();
    }
}

