/*
 * Decompiled with CFR 0.152.
 */
package de.javasoft.docking.ui.controls;

import de.javasoft.docking.JYDockingView;
import de.javasoft.docking.ui.BasicDockingViewTitlebarUI;
import de.javasoft.docking.ui.DockingViewTitlebarUI;
import de.javasoft.docking.ui.controls.AbstractDockingViewAction;
import de.javasoft.docking.ui.controls.DefaultCloseAction;
import de.javasoft.docking.ui.controls.DefaultFloatAction;
import de.javasoft.docking.ui.controls.DefaultMaximizeAction;
import de.javasoft.docking.ui.controls.DefaultMinimizeAction;
import de.javasoft.docking.ui.controls.DefaultUndockAction;
import de.javasoft.docking.ui.controls.DockingButton;
import de.javasoft.docking.ui.controls.IDockingButtonFactory;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.util.LinkedHashMap;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import org.jdesktop.swingx.plaf.LookAndFeelAddons;

public class DockingViewTitlebar
extends JComponent {
    private static final long serialVersionUID = -8936591064762821423L;
    public static final String uiClassID = "JYDockingViewTitlebarUI";
    private JLabel titleLabel = new TitleLabel();
    private Color titleForeground;
    private Color activeTitleForeground;
    private LinkedHashMap<Action, DockingButton> dockingButtons;
    private JYDockingView parentView;

    public DockingViewTitlebar() {
        this(null, null);
    }

    public DockingViewTitlebar(String title, Action[] actions) {
        this.setTitleText(title);
        this.setActions(actions);
        this.add(this.titleLabel);
        this.add(Box.createHorizontalGlue());
        this.updateUI();
    }

    @Override
    public String getUIClassID() {
        return uiClassID;
    }

    @Override
    public void updateUI() {
        this.setUI(LookAndFeelAddons.getUI((JComponent)this, DockingViewTitlebarUI.class));
    }

    @Override
    public DockingViewTitlebarUI getUI() {
        return (DockingViewTitlebarUI)this.ui;
    }

    protected void setActions(Action[] actions) {
        if (actions == null) {
            actions = new Action[]{};
            this.dockingButtons = new LinkedHashMap(4);
        }
        this.removeActions();
        int i = 0;
        while (i < actions.length) {
            this.addAction(actions[i]);
            ++i;
        }
    }

    protected void removeActions() {
        Action[] actionArray = this.getActions();
        int n = actionArray.length;
        int n2 = 0;
        while (n2 < n) {
            Action action = actionArray[n2];
            this.removeAction(action);
            ++n2;
        }
    }

    public Action[] getActions() {
        return this.dockingButtons.keySet().toArray(new Action[0]);
    }

    public void addAction(Action action) {
        if (!this.dockingButtons.keySet().contains(action)) {
            DockingButton button = this.createDockingButton(action);
            this.dockingButtons.put(action, button);
            this.add(button);
        }
    }

    public void removeAction(Action action) {
        if (this.dockingButtons.keySet().contains(action)) {
            this.remove(this.dockingButtons.get(action));
            this.dockingButtons.remove(action);
        }
    }

    public boolean isActive() {
        return this.parentView == null ? false : this.parentView.isActive();
    }

    public void setView(JYDockingView view) {
        this.parentView = view;
    }

    public JYDockingView getView() {
        return (JYDockingView)SwingUtilities.getAncestorOfClass(JYDockingView.class, this);
    }

    private DockingButton createDockingButton(Action action) {
        ButtonModel model;
        DockingButton button = null;
        IDockingButtonFactory factory = ((BasicDockingViewTitlebarUI)this.getUI()).getDockingButtonFactory();
        if (action instanceof DefaultMinimizeAction) {
            button = factory.createMinimizeButton(action);
        } else if (action instanceof DefaultMaximizeAction) {
            button = factory.createMaximizeButton(action);
        } else if (action instanceof DefaultFloatAction) {
            button = factory.createFloatButton(action);
        } else if (action instanceof DefaultUndockAction) {
            button = factory.createUndockButton(action);
        } else if (action instanceof DefaultCloseAction) {
            button = factory.createCloseButton(action);
        }
        if (action instanceof AbstractDockingViewAction && (model = ((AbstractDockingViewAction)action).createButtonModel()) != null) {
            button.setModel(model);
        }
        return button;
    }

    public void setTitleText(String text) {
        this.titleLabel.setText(text == null ? "" : text);
    }

    public String getTitleText() {
        return this.titleLabel.getText();
    }

    public Icon getTitleIcon() {
        return this.titleLabel.getIcon();
    }

    public void setTitleIcon(Icon icon) {
        this.titleLabel.setIcon(icon);
    }

    public void setTitleForeground(Color foreground) {
        this.titleForeground = foreground;
    }

    public Color getTitleForeground() {
        return this.titleForeground;
    }

    public void setActiveTitleForeground(Color foreground) {
        this.activeTitleForeground = foreground;
    }

    public Color getActiveTitleForeground() {
        return this.activeTitleForeground;
    }

    protected Icon getIcon(Action action) {
        Object obj = action == null ? null : action.getValue("SmallIcon");
        return obj instanceof Icon ? (Icon)obj : null;
    }

    private class TitleLabel
    extends JLabel {
        private static final long serialVersionUID = -1108225465058579891L;

        private TitleLabel() {
        }

        @Override
        public Dimension getMinimumSize() {
            int iconWidth = this.getIcon() == null ? 0 : this.getIcon().getIconWidth();
            return new Dimension(iconWidth, super.getMinimumSize().height);
        }

        @Override
        public Color getForeground() {
            return DockingViewTitlebar.this.isActive() ? DockingViewTitlebar.this.getActiveTitleForeground() : DockingViewTitlebar.this.getTitleForeground();
        }

        @Override
        public Font getFont() {
            return DockingViewTitlebar.this.getFont();
        }

        @Override
        public boolean isFocusable() {
            return false;
        }
    }
}

