/*
 * Decompiled with CFR 0.152.
 */
package de.javasoft.docking.ui.controls;

import de.javasoft.docking.controls.DockingManager;
import de.javasoft.docking.controls.IDockable;
import de.javasoft.docking.ui.controls.AbstractDockingViewAction;
import de.javasoft.docking.ui.controls.DockingButton;
import java.awt.Window;
import java.awt.event.ActionEvent;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.UIManager;

public class DefaultUndockAction
extends AbstractDockingViewAction {
    public DefaultUndockAction(IDockable dockable) {
        super(dockable);
        Object tt = UIManager.get("JYDocking.titlebar.undockButton.toolTip");
        if (tt == null) {
            tt = UIManager.get("JYDocking.titlebar.floatButton.toolTip");
        }
        this.putValue("ShortDescription", tt);
    }

    @Override
    public void actionPerformed(IDockable dockable, ActionEvent evt) {
        AbstractButton button = (AbstractButton)evt.getSource();
        if (button.isEnabled()) {
            DockingManager.setFloating(dockable, true);
        }
    }

    @Override
    public ButtonModel createButtonModel() {
        return new DockingButton.DockingButtonModel(){

            @Override
            public boolean isSelected() {
                return false;
            }

            @Override
            public boolean isEnabled() {
                Window w = DockingManager.getWindow(DefaultUndockAction.this.dockable);
                return w == DockingManager.getMainWindow() ? true : DockingManager.getDockables(w).size() > 1;
            }
        };
    }
}

