/*
 * Decompiled with CFR 0.152.
 */
package de.javasoft.docking.ui;

import de.javasoft.docking.controls.Dockbar;
import de.javasoft.docking.controls.DockbarSlidePanel;
import de.javasoft.docking.ui.BasicDockingPainter;
import de.javasoft.docking.ui.DockbarSlidePanelUI;
import de.javasoft.plaf.synthetica.SyntheticaLookAndFeel;
import de.javasoft.plaf.synthetica.SyntheticaState;
import de.javasoft.widgets.util.WidgetUtils;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;
import javax.swing.plaf.ComponentUI;

public class BasicDockbarSlidePanelUI
extends DockbarSlidePanelUI
implements PropertyChangeListener {
    protected DockbarSlidePanel slidePanel;

    public static ComponentUI createUI(JComponent c) {
        return new BasicDockbarSlidePanelUI();
    }

    @Override
    public void installUI(JComponent c) {
        this.slidePanel = (DockbarSlidePanel)c;
        super.installUI(c);
        this.installDefaults();
        this.installListener();
    }

    @Override
    public void uninstallUI(JComponent c) {
        super.uninstallUI(c);
        this.uninstallDefaults();
        this.uninstallListener();
    }

    protected void installDefaults() {
        this.updateDefaults();
    }

    protected void uninstallDefaults() {
    }

    protected void installListener() {
        this.slidePanel.addPropertyChangeListener(this);
    }

    protected void uninstallListener() {
        this.slidePanel.removePropertyChangeListener(this);
    }

    private void updateDefaults() {
        this.slidePanel.setOpaque(SyntheticaLookAndFeel.getBoolean((String)"JYDocking.slidePanel.opaque", (Component)this.slidePanel, (boolean)true));
        this.updateInsets(this.slidePanel.getPlacement());
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        int x = 0;
        int y = 0;
        int w = c.getWidth();
        int h = c.getHeight();
        this.paintBackground(c, g, x, y, w, h, ((DockbarSlidePanel)c).getPlacement());
    }

    protected void paintBackground(JComponent c, Graphics g, int x, int y, int w, int h, int placement) {
        BasicDockingPainter.getInstance().paintDockingSlidePanelBackground(c, new SyntheticaState(), g, x, y, w, h, placement);
    }

    protected void updateInsets(int placement) {
        Insets insets = SyntheticaLookAndFeel.getInsets((String)("JYDocking.slidePanel." + Dockbar.placementAsString(placement) + ".insets"), (Component)this.slidePanel);
        if (insets == null) {
            insets = placement == 3 ? new Insets(2, 0, 0, 0) : (placement == 4 ? new Insets(0, 2, 0, 0) : new Insets(0, 0, 0, 2));
        }
        this.slidePanel.setBorder(SyntheticaLookAndFeel.getInstance().createEmptyBorder(insets, true));
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        String name = evt.getPropertyName();
        if (WidgetUtils.shouldUpdateStyle((PropertyChangeEvent)evt)) {
            this.updateDefaults();
        }
        if ("placement".equals(name)) {
            this.updateInsets((Integer)evt.getNewValue());
        }
    }
}

