/*
 * Decompiled with CFR 0.152.
 */
package de.javasoft.docking.controls;

import de.javasoft.docking.controls.Dockbar;
import de.javasoft.docking.controls.DockbarManager;
import de.javasoft.docking.controls.DockbarSlidePanel;
import de.javasoft.docking.controls.RootWindow;
import de.javasoft.docking.controls.StatusDockbarLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import javax.swing.JDialog;

class StatusDockbarManager
extends DockbarManager {
    private static final boolean JAVA5 = System.getProperty("java.version").startsWith("1.5.");
    private static boolean leftBarInner = false;
    private static boolean rightBarInner = false;
    private static boolean bottomBarInner = true;

    public StatusDockbarManager(RootWindow window) {
        super(window);
        this.dockbarLayout = new StatusDockbarLayout(this);
        this.leftBar = new Dockbar(this, 2);
        this.rightBar = new Dockbar(this, 4);
        this.bottomBar = new Dockbar(this, 3);
        this.slidePanel = new DockbarSlidePanel(this);
    }

    public static void setDockbarPlacement(int placement, boolean inner) {
        if (placement == 2) {
            leftBarInner = inner;
        } else if (placement == 4) {
            rightBarInner = inner;
        } else if (placement == 3) {
            bottomBarInner = inner;
        }
    }

    @Override
    public void validate() {
        this.dockbarLayout.layout();
        this.slidePanel.revalidate();
    }

    @Override
    protected void install() {
        RootWindow rw = this.getRootWindow();
        if (rw == null) {
            return;
        }
        if (rw.getWindow() instanceof JDialog && ((JDialog)rw.getWindow()).isModal()) {
            return;
        }
        if (rw.getContentPane().getLayout() instanceof BorderLayout) {
            rw.getLayeredPane().add((Component)this.slidePanel, DOCKBAR_LAYER);
            this.installDockbar(this.leftBar, "West", leftBarInner);
            this.installDockbar(this.bottomBar, "South", bottomBarInner);
            this.installDockbar(this.rightBar, "East", rightBarInner);
        }
    }

    private boolean installDockbar(Dockbar dockbar, String constraint, boolean inner) {
        Container container = this.getRootWindow().getContentPane();
        LayoutManager lm = container.getLayout();
        if (!(lm instanceof BorderLayout)) {
            throw new IllegalStateException("Only BorderLayout for ContentPane is supported!");
        }
        BorderLayout bl = (BorderLayout)lm;
        Component c = bl.getLayoutComponent(constraint);
        if (c instanceof DockbarContainer) {
            return false;
        }
        if (c != null) {
            container.remove(c);
        }
        String dockbarConstraints = constraint;
        if (constraint.equals("North") && inner) {
            dockbarConstraints = "South";
        } else if (constraint.equals("South") && inner) {
            dockbarConstraints = "North";
        } else if (constraint.equals("West") && inner) {
            dockbarConstraints = "East";
        } else if (constraint.equals("East") && inner) {
            dockbarConstraints = "West";
        }
        DockbarContainer dc = new DockbarContainer();
        if (c != null) {
            dc.add(c, "Center");
        }
        dc.add((Component)dockbar, dockbarConstraints);
        container.add((Component)dc, constraint);
        if (c != null) {
            container.validate();
        }
        if (JAVA5) {
            dc.validate();
        }
        return true;
    }

    public Container getContainer(int dockbarPlacement) {
        BorderLayout bl = (BorderLayout)this.getDockbar(dockbarPlacement).getParent().getLayout();
        return (Container)bl.getLayoutComponent("Center");
    }

    private static class DockbarContainer
    extends Container {
        private static final long serialVersionUID = 2621037069903125435L;

        public DockbarContainer() {
            this.setLayout(new BorderLayout());
        }
    }
}

