/*
 * Decompiled with CFR 0.152.
 */
package de.javasoft.docking.controls;

import de.javasoft.docking.controls.Dockbar;
import de.javasoft.docking.controls.DockbarLayout;
import de.javasoft.docking.controls.DockbarManager;
import de.javasoft.docking.controls.IDockable;
import de.javasoft.docking.controls.StatusDockbarManager;
import java.awt.Rectangle;
import javax.swing.SwingUtilities;

class StatusDockbarLayout
extends DockbarLayout {
    public StatusDockbarLayout(StatusDockbarManager mgr) {
        super(mgr);
    }

    @Override
    public void layout() {
        this.layoutSlidePanel();
    }

    @Override
    public Rectangle getViewArea(DockbarManager mgr, IDockable dockable) {
        if (mgr == null) {
            return new Rectangle(0, 0, 0, 0);
        }
        Rectangle leftBar = StatusDockbarLayout.convert(mgr, mgr.getLeftBar());
        Rectangle bottomBar = StatusDockbarLayout.convert(mgr, mgr.getBottomBar());
        Rectangle rightBar = StatusDockbarLayout.convert(mgr, mgr.getRightBar());
        int h = bottomBar.y - leftBar.y;
        return new Rectangle(leftBar.x + leftBar.width, leftBar.y, bottomBar.width - leftBar.width - rightBar.width, h);
    }

    private static Rectangle convert(DockbarManager mgr, Dockbar bar) {
        Rectangle rect = new Rectangle(0, 0, bar.getBounds().width, bar.getBounds().height);
        return SwingUtilities.convertRectangle(bar, rect, mgr.getRootWindow().getLayeredPane());
    }
}

