/*
 * Decompiled with CFR 0.152.
 */
package de.javasoft.docking.controls;

import de.javasoft.docking.controls.DockbarManager;
import de.javasoft.docking.controls.IDockable;
import de.javasoft.docking.controls.RootWindow;
import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

class ResizeListener
extends MouseAdapter
implements MouseMotionListener {
    private static final int MINIMUM_VIEW_SIZE = 60;
    private DockbarManager manager;
    private IDockable dockable;
    private JPanel dragGlassPane;
    private Component cachedGlassPane;
    private RootWindow rootWindow;
    private int xOffset;
    private int yOffset;

    public ResizeListener(DockbarManager manager) {
        this.manager = manager;
        this.dragGlassPane = new JPanel();
        this.dragGlassPane.setOpaque(false);
    }

    @Override
    public void mousePressed(MouseEvent evt) {
        this.dockable = this.manager.getActiveDockable();
        this.rootWindow = this.manager.getRootWindow();
        this.cachedGlassPane = this.rootWindow.getGlassPane();
        this.rootWindow.setGlassPane(this.dragGlassPane);
        this.dragGlassPane.setCursor(this.manager.getResizeCursor());
        this.dragGlassPane.setVisible(true);
        this.manager.setDragging(true);
        int orientation = this.manager.getActivePlacement();
        Rectangle r = this.manager.getSlidePanel().getBounds();
        Point pd = new Point(r.x, r.y);
        if (orientation == 2) {
            pd.x += r.width;
        }
        SwingUtilities.convertPointToScreen(pd, this.manager.getSlidePanel().getParent());
        Point pm = new Point(evt.getPoint());
        SwingUtilities.convertPointToScreen(pm, evt.getComponent());
        this.xOffset = orientation == 3 ? 0 : pd.x - pm.x;
        this.yOffset = orientation == 3 ? pd.y - pm.y : 0;
    }

    @Override
    public void mouseReleased(MouseEvent evt) {
        this.dockable = null;
        this.dragGlassPane.setVisible(false);
        this.manager.setDragging(false);
        if (this.rootWindow != null && this.cachedGlassPane != null) {
            this.rootWindow.setGlassPane(this.cachedGlassPane);
            this.cachedGlassPane = null;
            this.rootWindow = null;
        }
    }

    @Override
    public void mouseDragged(MouseEvent evt) {
        if (this.dockable != null) {
            this.handleResizeEvent(evt);
        }
    }

    @Override
    public void mouseMoved(MouseEvent evt) {
    }

    private void handleResizeEvent(MouseEvent evt) {
        Rectangle viewArea = this.manager.getDockbarLayout().getViewArea(this.manager, this.dockable);
        Point pv = new Point(viewArea.x, viewArea.y);
        SwingUtilities.convertPointToScreen(pv, this.manager.getSlidePanel().getRootPane().getLayeredPane());
        Point pm = new Point(evt.getPoint());
        SwingUtilities.convertPointToScreen(pm, evt.getComponent());
        Point p = new Point(pm.x - pv.x + this.xOffset, pm.y - pv.y + this.yOffset);
        int orientation = this.manager.getActivePlacement();
        if (orientation == 4) {
            p.x = viewArea.width - p.x;
        } else if (orientation == 3) {
            p.y = viewArea.height - p.y;
        }
        p.x = Math.max(p.x, 0);
        p.x = Math.min(p.x, viewArea.width);
        p.y = Math.max(p.y, 0);
        p.y = Math.min(p.y, viewArea.height);
        float loc = orientation == 3 ? p.y : p.x;
        float dim = orientation == 3 ? viewArea.height : viewArea.width;
        float percent = loc / dim;
        float minPercent = 60.0f / dim;
        percent = Math.max(percent, minPercent);
        this.dockable.setPreviewSize(percent);
        this.manager.revalidate();
    }
}

