/*
 * Decompiled with CFR 0.152.
 */
package de.javasoft.docking.controls;

import de.javasoft.docking.controls.ActiveDockableTracker;
import de.javasoft.docking.controls.DockingManager;
import de.javasoft.docking.controls.DockingPath;
import de.javasoft.docking.controls.DockingState;
import de.javasoft.docking.controls.DockingUtility;
import de.javasoft.docking.controls.FloatingGroup;
import de.javasoft.docking.controls.IDockable;
import de.javasoft.docking.controls.IDockableFactory;
import de.javasoft.docking.controls.IDockingConstants;
import de.javasoft.docking.controls.IDockingPort;
import de.javasoft.docking.controls.IDockingStrategy;
import de.javasoft.docking.controls.ILayoutNode;
import de.javasoft.docking.controls.IPerspectiveModelListener;
import de.javasoft.docking.controls.Perspective;
import de.javasoft.docking.controls.PerspectiveManager;
import de.javasoft.docking.controls.PerspectiveModelEvent;
import java.awt.Component;
import java.awt.EventQueue;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;

public class PerspectiveModel
implements Cloneable,
Serializable {
    private static final long serialVersionUID = 5464430338438274555L;
    private HashMap<String, DockingState> dockingStates = new LinkedHashMap<String, DockingState>();
    private HashMap<String, FloatingGroup> floatingGroups = new LinkedHashMap<String, FloatingGroup>();
    private ILayoutNode restorationLayout;
    private List<DockingState> dockableSequence = new ArrayList<DockingState>();
    private List<IPerspectiveModelListener> listeners = new ArrayList<IPerspectiveModelListener>();

    public PerspectiveModel() {
    }

    private PerspectiveModel(HashMap<String, DockingState> dockingStates, HashMap<String, FloatingGroup> floatingGroups, List<IPerspectiveModelListener> listeners, List<DockingState> dockableSequence) {
        this();
        this.dockingStates = dockingStates;
        this.floatingGroups = floatingGroups;
        this.listeners = listeners;
        this.dockableSequence = dockableSequence;
    }

    public void addModelListener(IPerspectiveModelListener listener) {
        this.listeners.add(listener);
    }

    public void removeModelListener(IPerspectiveModelListener listener) {
        this.listeners.remove(listener);
    }

    public IPerspectiveModelListener[] getModelListeners() {
        return this.listeners.toArray(new IPerspectiveModelListener[0]);
    }

    private void addState(IDockable dockable) {
        this.addState(dockable.getID());
    }

    private void addState(String dockableID) {
        if (dockableID == null) {
            throw new IllegalStateException("dockableID can't be null");
        }
        if (this.dockingStates.containsKey(dockableID)) {
            return;
        }
        this.setDockingState(dockableID, new DockingState(dockableID));
        this.dispatchEvent(new PerspectiveModelEvent(this, dockableID, 4));
    }

    public DockingState removeDockingState(String dockableID) {
        DockingState state = this.dockingStates.remove(dockableID);
        if (state != null) {
            this.dispatchEvent(new PerspectiveModelEvent(this, dockableID, 5));
        }
        return state;
    }

    public void setDockingState(String dockableID, DockingState dockingState) {
        this.dockingStates.put(dockableID, dockingState);
    }

    public FloatingGroup removeFloatingGroup(String groupID) {
        return this.floatingGroups.remove(groupID);
    }

    public boolean contains(IDockable dockable) {
        return dockable == null ? false : this.contains(dockable.getID());
    }

    public boolean contains(String dockableID) {
        return dockableID == null ? false : this.dockingStates.containsKey(dockableID);
    }

    public IDockable getDockable(String id) {
        if (this.dockingStates.containsKey(id)) {
            return DockingManager.getDockable(id);
        }
        return null;
    }

    public IDockable[] getDockables() {
        ArrayList<IDockable> list = new ArrayList<IDockable>(this.dockingStates.size());
        for (String dockingId : this.dockingStates.keySet()) {
            IDockable d = PerspectiveModel.findDockable(dockingId);
            if (d == null) continue;
            list.add(d);
        }
        return list.toArray(new IDockable[0]);
    }

    private static IDockable findDockable(String dockableID) {
        IDockable d = DockingManager.getDockable(dockableID);
        IDockableFactory factory = DockingManager.getDockableFactory();
        if (d == null && factory != null) {
            d = factory.getDockable(dockableID);
            DockingManager.registerDockable(d);
        }
        return d;
    }

    public DockingState getDockingState(IDockable dockable, boolean load) {
        return this.getDockingState(dockable.getID(), load);
    }

    public DockingState getDockingState(String dockableID, boolean load) {
        IDockable dockable;
        if (dockableID == null) {
            return null;
        }
        if (load && (dockable = DockingManager.getDockable(dockableID)) != null) {
            this.isMaintained(dockable);
        }
        DockingState obj = this.dockingStates.get(dockableID);
        return obj;
    }

    public void applyFloatingGroup(IDockingPort dockingPort, Perspective perspective, String floatingGroupID) {
        if (dockingPort == null) {
            throw new IllegalStateException("DockingPort can not be null");
        }
        if (!this.isInitialized()) {
            return;
        }
        ArrayList<IDockable> deferredMinimizedDockables = new ArrayList<IDockable>();
        boolean deferMinimized = DockingUtility.getActiveWindow() == null;
        IDockable activeDockable = null;
        ArrayList<IDockable> selectedDockables = new ArrayList<IDockable>();
        IDockable[] iDockableArray = this.getDockables();
        int n = iDockableArray.length;
        int n2 = 0;
        while (n2 < n) {
            IDockable dockable = iDockableArray[n2];
            DockingState state = this.getDockingState(dockable, false);
            String id = state.getFloatingGroupID();
            if (floatingGroupID.equals(id) && state.isFloating()) {
                if (!DockingManager.isFloating(dockable)) {
                    int placement = state.getPlacement();
                    FloatingGroup group = this.getFloatingGroup(state.getFloatingGroupID());
                    DockingManager.setFloating(dockable, perspective, true, group.getBounds(), false);
                    DockingManager.getRootDockingPort(dockable.getComponent()).setID(state.getPath().getRootPortId());
                    ILayoutNode floatingLayout = group.getRestorationLayout();
                    if (floatingLayout != null) {
                        DockingManager.getRootDockingPort(dockable.getComponent()).importLayout(floatingLayout);
                    }
                    state.setPlacement(placement);
                }
                DockingPath floatingRestorePath = state.getFloatingRestorePath();
                floatingRestorePath.setRootPortId(dockingPort.getID());
                state.setFloatingRestorePath(floatingRestorePath);
                if (state.isMinimized()) {
                    if (deferMinimized) {
                        deferredMinimizedDockables.add(dockable);
                    } else {
                        SwingUtilities.invokeLater(() -> DockingManager.setMinimized(dockable, perspective, true, state.getPlacement()));
                    }
                } else if (state.isMaximized()) {
                    SwingUtilities.invokeLater(() -> DockingManager.setMaximized(dockable, perspective, true));
                }
            }
            if (state.isSelected()) {
                selectedDockables.add(dockable);
            }
            if (state.isActive()) {
                activeDockable = dockable;
            }
            ++n2;
        }
        this.restoreDeferredMinimizedDockables(deferredMinimizedDockables);
        for (IDockable d : selectedDockables) {
            JComponent c = d.getComponent();
            JTabbedPane tabPane = (JTabbedPane)SwingUtilities.getAncestorOfClass(JTabbedPane.class, c);
            if (tabPane == null) continue;
            try {
                tabPane.setSelectedComponent(c);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        if (activeDockable != null) {
            ActiveDockableTracker.requestDockableActivation(activeDockable.getComponent(), true);
        }
    }

    public void apply(IDockingPort dockingPort, Perspective perspective) {
        DockingPath floatingRestorePath;
        JComponent comp = dockingPort.getComponent();
        if (comp == null || !this.isInitialized()) {
            return;
        }
        PerspectiveManager.clear(dockingPort);
        DockingPath path = this.getDockingState(this.getDockables()[0], false).getPath();
        if (path != null) {
            dockingPort.setID(path.getRootPortId());
        }
        if ((floatingRestorePath = this.getDockingState(this.getDockables()[0], false).getFloatingRestorePath()) != null) {
            dockingPort.setID(floatingRestorePath.getRootPortId());
        }
        boolean listening = PerspectiveManager.isDockingStateListening();
        PerspectiveManager.setDockingStateListening(false);
        dockingPort.importLayout(this.restorationLayout);
        PerspectiveManager.setDockingStateListening(listening);
        IDockable[] dockables = this.getDockables();
        ArrayList<IDockable> deferredMinimizedDockables = new ArrayList<IDockable>();
        boolean deferMinimized = DockingUtility.getActiveWindow() == null;
        boolean restoreFloatOnLoad = PerspectiveManager.isRestoreFloatingOnLoad();
        IDockable activeDockable = null;
        ArrayList<IDockable> selectedDockables = new ArrayList<IDockable>();
        IDockable[] iDockableArray = dockables;
        int n = dockables.length;
        int n2 = 0;
        while (n2 < n) {
            IDockable dockable = iDockableArray[n2];
            DockingState state = this.getDockingState(dockable, false);
            if (restoreFloatOnLoad && state.isFloating() && !DockingManager.isFloating(dockable)) {
                int placement = state.getPlacement();
                FloatingGroup group = this.getFloatingGroup(state.getFloatingGroupID());
                DockingManager.setFloating(dockable, perspective, true, group.getBounds(), false);
                IDockingPort rootPort = DockingManager.getRootDockingPort(dockable.getComponent());
                rootPort.setID(state.getPath().getRootPortId());
                ILayoutNode floatingLayout = group.getRestorationLayout();
                if (floatingLayout != null) {
                    rootPort.importLayout(floatingLayout);
                }
                state.setPlacement(placement);
            }
            if (state.isMinimized()) {
                if (deferMinimized) {
                    deferredMinimizedDockables.add(dockable);
                } else {
                    DockingManager.setMinimized(dockable, perspective, true, state.getPlacement());
                }
            } else if (state.isMaximized()) {
                SwingUtilities.invokeLater(() -> DockingManager.setMaximized(dockable, perspective, true));
            }
            if (state.isSelected()) {
                selectedDockables.add(dockable);
            }
            if (state.isActive()) {
                activeDockable = dockable;
            }
            ++n2;
        }
        this.restoreDeferredMinimizedDockables(deferredMinimizedDockables);
        for (IDockable d : selectedDockables) {
            JComponent c = d.getComponent();
            JTabbedPane tabPane = (JTabbedPane)SwingUtilities.getAncestorOfClass(JTabbedPane.class, c);
            if (tabPane == null) continue;
            try {
                tabPane.setSelectedComponent(c);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        if (activeDockable != null) {
            ActiveDockableTracker.requestDockableActivation(activeDockable.getComponent(), true);
        }
        this.dispatchEvent(new PerspectiveModelEvent(this, null, 0));
    }

    private void restoreMinimizedDockables(ArrayList<IDockable> dockables) {
        if (DockingUtility.getActiveWindow() == null) {
            this.restoreDeferredMinimizedDockables(dockables);
            return;
        }
        Perspective currentPerspective = DockingManager.getPerspectiveManager().getCurrentPerspective();
        for (IDockable dockable : dockables) {
            DockingManager.setMinimized(dockable, currentPerspective, true, this.getDockingState(dockable, false).getPlacement());
        }
    }

    private void restoreDeferredMinimizedDockables(final ArrayList<IDockable> deferred) {
        if (deferred == null || deferred.size() == 0) {
            return;
        }
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                PerspectiveModel.this.restoreMinimizedDockables(deferred);
            }
        });
    }

    private boolean isMaintained(IDockable dockable) {
        if (!this.contains(dockable)) {
            this.addState(dockable);
        }
        return true;
    }

    public void hide(IDockable dockable) {
        if (!this.isMaintained(dockable)) {
            return;
        }
        boolean hidden = false;
        if (DockingManager.isDocked(dockable)) {
            hidden = DockingManager.undock(dockable);
        } else if (DockingManager.isMinimized(dockable, DockingManager.getPerspectiveManager().getCurrentPerspective())) {
            hidden = DockingManager.getMinimizeManager().close(dockable);
        }
        if (hidden) {
            this.dispatchEvent(new PerspectiveModelEvent(this, dockable.getID(), 2));
        }
    }

    public void show(IDockable dockable, IDockingPort dockingPort) {
        if (!this.isMaintained(dockable) || DockingManager.isDocked(dockable)) {
            return;
        }
    }

    public FloatingGroup getGroup(String groupID) {
        return groupID == null ? null : this.floatingGroups.get(groupID);
    }

    public String[] getFloatingGroupIDs() {
        return this.floatingGroups.keySet().toArray(new String[0]);
    }

    public FloatingGroup getFloatingGroup(String groupID) {
        return this.floatingGroups.get(groupID);
    }

    public void addFloatingGroup(FloatingGroup floatingGroup) {
        if (floatingGroup == null) {
            return;
        }
        this.floatingGroups.put(floatingGroup.getID(), floatingGroup);
    }

    public boolean isInitialized() {
        return this.restorationLayout != null;
    }

    public ILayoutNode getRestorationLayout() {
        return this.restorationLayout;
    }

    public void setRestorationLayout(ILayoutNode restorationLayout) {
        this.restorationLayout = restorationLayout;
    }

    void updateDockingStates() {
        for (DockingState state : this.getDockableSequenceClone()) {
            this.dockingStates.put(state.getDockableID(), state);
        }
    }

    public Object clone() {
        ILayoutNode restoreNode;
        ArrayList listeners_ = (ArrayList)((ArrayList)this.listeners).clone();
        HashMap dockingStates_ = (HashMap)this.dockingStates.clone();
        for (String id : this.dockingStates.keySet()) {
            DockingState dockingState = this.getDockingState(id, false);
            dockingStates_.put(id, (DockingState)dockingState.clone());
        }
        HashMap floatingGroups_ = (HashMap)this.floatingGroups.clone();
        for (String key : this.floatingGroups.keySet()) {
            FloatingGroup floatingGroup = this.floatingGroups.get(key);
            floatingGroups_.put(key, (FloatingGroup)floatingGroup.clone());
        }
        PerspectiveModel clone = new PerspectiveModel(dockingStates_, floatingGroups_, listeners_, this.getDockableSequenceClone());
        clone.restorationLayout = restoreNode = this.restorationLayout == null ? null : (ILayoutNode)this.restorationLayout.clone();
        return clone;
    }

    List<DockingState> getDockableSequence() {
        return this.getDockableSequenceClone();
    }

    void setDockableSequence(List<DockingState> dockableSequence) {
        this.dockableSequence = dockableSequence;
    }

    public void add(IDockable dockable) {
        this.add(dockable.getID());
    }

    void add(String dockableID) {
        this.add(dockableID, null);
    }

    void add(String dockableID, String relativeParentID) {
        this.add(dockableID, relativeParentID, "CENTER", -1.0f);
    }

    public void add(IDockable dockable, IDockable relativeParent, String region, float ratio) {
        String dockableID = dockable == null ? null : dockable.getID();
        String parentID = relativeParent == null ? null : relativeParent.getID();
        this.add(dockableID, parentID, region, ratio);
    }

    void add(String dockableID, String relativeParentID, String region, float ratio) {
        if (relativeParentID == null && this.dockableSequence.size() > 0) {
            throw new IllegalStateException("All calls to add() after the first dockable has been added MUST specify a relative dockable parent.");
        }
        DockingState info = new DockingState(dockableID);
        info.setRelativeParentID(relativeParentID);
        info.setRegion(region);
        info.setSplitRatio(ratio);
        this.dockableSequence.add(info);
    }

    public void remove(String dockableID) {
        this.removeDockingState(dockableID);
        for (DockingState state : this.dockableSequence) {
            if (!state.getDockableID().equals(dockableID)) continue;
            this.dockableSequence.remove(state);
            break;
        }
    }

    private List<DockingState> getDockableSequenceClone() {
        ArrayList<DockingState> list = new ArrayList<DockingState>(this.dockableSequence.size());
        for (DockingState state : this.dockableSequence) {
            list.add((DockingState)state.clone());
        }
        return list;
    }

    public void dispatchEvent(PerspectiveModelEvent evt) {
        for (IPerspectiveModelListener l : this.listeners) {
            switch (evt.getEventType()) {
                case 2: {
                    l.dockableHidden(evt);
                    break;
                }
                case 3: {
                    l.dockableDisplayed(evt);
                    break;
                }
                case 0: {
                    l.modelApplied(evt);
                    break;
                }
                case 1: {
                    l.modelEmptied(evt);
                    break;
                }
                case 4: {
                    l.stateAdded(evt);
                    break;
                }
                case 5: {
                    l.stateRemoved(evt);
                }
            }
        }
    }

    static class DockableNode
    extends DockingNode {
        private static final long serialVersionUID = 3725121216737471819L;
        private String dockableID;

        public DockableNode() {
        }

        private DockableNode(String id) {
            this.dockableID = id;
        }

        public String getDockableID() {
            return this.dockableID;
        }

        public void setDockableID(String dockableID) {
            this.dockableID = dockableID;
        }

        public IDockable getDockable() {
            return PerspectiveModel.findDockable(this.dockableID);
        }

        @Override
        public void add(MutableTreeNode newChild) {
        }

        @Override
        public Object getDockingObject() {
            return this.getDockable();
        }

        @Override
        protected DockingNode shallowClone() {
            return new DockableNode(this.dockableID);
        }

        @Override
        public String toString() {
            StringBuffer sb = new StringBuffer("DockableNode[");
            sb.append("id=").append(this.getDockableID()).append("; ");
            sb.append("]");
            return sb.toString();
        }
    }

    static abstract class DockingNode
    extends DefaultMutableTreeNode
    implements ILayoutNode,
    IDockingConstants {
        private static final long serialVersionUID = -7294513608480374203L;

        DockingNode() {
        }

        @Override
        public Object getUserObject() {
            Object obj = super.getUserObject();
            if (obj == null) {
                obj = this.getDockingObject();
                this.setUserObject(obj);
            }
            return obj;
        }

        @Override
        public abstract Object getDockingObject();

        protected abstract DockingNode shallowClone();

        @Override
        public Object clone() {
            return this.deepClone();
        }

        public DockingNode deepClone() {
            DockingNode clone = this.shallowClone();
            Enumeration<TreeNode> en = this.children();
            while (en.hasMoreElements()) {
                DockingNode child = (DockingNode)en.nextElement();
                clone.add(child.deepClone());
            }
            return clone;
        }

        @Override
        public String toString() {
            return this.getClass().getSimpleName();
        }
    }

    static class DockingPortNode
    extends DockingNode {
        private static final long serialVersionUID = -3421808775600227426L;

        DockingPortNode() {
        }

        @Override
        public Object getDockingObject() {
            TreeNode parent = this.getParent();
            if (!(parent instanceof SplitNode)) {
                return null;
            }
            TreeNode grandParent = parent.getParent();
            if (!(grandParent instanceof DockingPortNode)) {
                return null;
            }
            IDockingPort superPort = (IDockingPort)((DockingPortNode)grandParent).getUserObject();
            IDockingStrategy strategy = superPort.getDockingStrategy();
            return strategy.createDockingPort(superPort);
        }

        public IDockingPort getDockingPort() {
            return (IDockingPort)this.getUserObject();
        }

        public boolean isSplit() {
            int cnt = this.getChildCount();
            if (cnt != 1) {
                return false;
            }
            return this.getChildAt(0) instanceof SplitNode;
        }

        @Override
        protected DockingNode shallowClone() {
            return new DockingPortNode();
        }
    }

    static class SplitNode
    extends DockingNode {
        private static final long serialVersionUID = -2640096750924868595L;
        private int orientation;
        private int region;
        private float splitRatio;
        private String siblingId;
        private String dockingRegion;

        public SplitNode(int orientation, int region, float splitRatio, String siblingId) {
            this.orientation = orientation;
            this.region = region;
            this.splitRatio = splitRatio;
            this.siblingId = siblingId;
        }

        public int getOrientation() {
            return this.orientation;
        }

        public void setOrientation(int orientation) {
            this.orientation = orientation;
        }

        public float getSplitRatio() {
            return this.splitRatio;
        }

        public void setSplitRatio(float splitRatio) {
            this.splitRatio = splitRatio;
        }

        public int getRegion() {
            return this.region;
        }

        public void setRegion(int region) {
            this.region = region;
        }

        public String getSiblingId() {
            return this.siblingId;
        }

        public void setSiblingId(String siblingId) {
            this.siblingId = siblingId;
        }

        @Override
        public String toString() {
            StringBuffer sb = new StringBuffer("SplitNode[");
            sb.append("orient=").append(this.getOrientationDesc()).append("; ");
            sb.append("region=").append(this.getRegionDesc()).append("; ");
            sb.append("percent=").append(this.splitRatio).append("%;");
            sb.append("]");
            return sb.toString();
        }

        public String getRegionDesc() {
            switch (this.region) {
                case 1: {
                    return "top";
                }
                case 3: {
                    return "bottom";
                }
                case 4: {
                    return "right";
                }
            }
            return "left";
        }

        public String getOrientationDesc() {
            return this.orientation == 0 ? "vertical" : "horizontal";
        }

        @Override
        public Object clone() {
            return new SplitNode(this.orientation, this.region, this.splitRatio, this.siblingId);
        }

        public String getDockingRegion() {
            return this.dockingRegion;
        }

        public void setDockingRegion(String dockingRegion) {
            this.dockingRegion = dockingRegion;
        }

        @Override
        public Object getDockingObject() {
            if (this.dockingRegion == null) {
                return null;
            }
            if (!(this.getParent() instanceof DockingPortNode)) {
                return null;
            }
            DockingPortNode superNode = (DockingPortNode)this.getParent();
            Object userObj = superNode.getUserObject();
            if (!(userObj instanceof IDockingPort)) {
                return null;
            }
            IDockingPort superPort = (IDockingPort)userObj;
            IDockingStrategy strategy = superPort.getDockingStrategy();
            return strategy.createSplitPane(superPort, this.dockingRegion);
        }

        public JSplitPane getSplitPane() {
            return (JSplitPane)this.getUserObject();
        }

        public Component getLeftComponent() {
            return this.getChildComponent(0);
        }

        public Component getRightComponent() {
            return this.getChildComponent(1);
        }

        private Component getChildComponent(int indx) {
            ILayoutNode child = this.getChild(indx);
            Component c = child == null ? null : (Component)child.getUserObject();
            return c;
        }

        private ILayoutNode getChild(int indx) {
            if (indx >= this.getChildCount()) {
                return null;
            }
            return (ILayoutNode)this.getChildAt(indx);
        }

        @Override
        protected DockingNode shallowClone() {
            SplitNode clone = new SplitNode(this.orientation, this.region, this.splitRatio, this.siblingId);
            clone.dockingRegion = this.dockingRegion;
            return clone;
        }
    }
}

