/*
 * Decompiled with CFR 0.152.
 */
package de.javasoft.docking.controls;

import de.javasoft.docking.controls.DockbarManager;
import de.javasoft.docking.controls.DockingEvent;
import de.javasoft.docking.controls.DockingManager;
import de.javasoft.docking.controls.IDockable;
import de.javasoft.docking.controls.IMinimizationManager;
import de.javasoft.docking.controls.Perspective;
import java.awt.Component;
import java.awt.Window;
import javax.swing.SwingUtilities;

class MinimizationManager
implements IMinimizationManager {
    MinimizationManager() {
    }

    @Override
    public void preview(IDockable dockable, boolean locked) {
        DockbarManager.activate(dockable, true);
    }

    @Override
    public boolean close(IDockable dockable) {
        DockbarManager mgr = DockbarManager.getCurrent(dockable);
        boolean success = mgr == null ? false : mgr.remove(dockable);
        DockingEvent evt = new DockingEvent(dockable, DockingManager.getRootDockingPort(dockable.getComponent()), null, 6, null);
        DockingManager.dispatchEvent(evt, true, false);
        return success;
    }

    @Override
    public Window getWindow(Component c) {
        Window w;
        Window window = c == null ? null : (w = c instanceof Window ? (Window)c : SwingUtilities.getWindowAncestor(c));
        if (DockingManager.getFloatingMode() == DockingManager.FloatingMode.MIN_MAX_OWNER) {
            w = w == null ? null : (w.getParent() == null ? w : w.getOwner());
        }
        return w;
    }

    @Override
    public void setMinimized(IDockable dockable, Perspective perspective, boolean minimize, Window w, int placement) {
        DockbarManager mgr = DockbarManager.getInstance(w);
        if (mgr == null) {
            return;
        }
        if (minimize) {
            if (placement == -1) {
                mgr.minimize(dockable, perspective);
            } else {
                mgr.minimize(dockable, perspective, placement);
            }
        } else {
            mgr.restore(dockable, perspective);
        }
    }
}

