/*
 * Decompiled with CFR 0.152.
 */
package de.javasoft.docking.controls;

import de.javasoft.docking.controls.DockbarManager;
import de.javasoft.docking.controls.DockingEvent;
import de.javasoft.docking.controls.DockingManager;
import de.javasoft.docking.controls.DockingPort;
import de.javasoft.docking.controls.FloatingDialog;
import de.javasoft.docking.controls.FloatingFrame;
import de.javasoft.docking.controls.IDockable;
import de.javasoft.docking.controls.IFloatingDockingPort;
import java.awt.Component;
import java.awt.Container;
import java.awt.EventQueue;
import java.awt.Window;
import javax.swing.JComponent;
import javax.swing.JTabbedPane;
import javax.swing.UIManager;

public class FloatingDockingPort
extends DockingPort
implements IFloatingDockingPort {
    private static final long serialVersionUID = -8638759130060755602L;
    protected Window floatingWindow;

    public FloatingDockingPort() {
        this.setTabsAsDragSourceEnabled(true);
        this.setSingleTabAllowed(UIManager.getBoolean("JYDocking.floatingWindow.singleTabAllowed"));
    }

    @Override
    public void setFloatingWindow(Window floatingWindow) {
        this.floatingWindow = floatingWindow;
    }

    @Override
    public void undockingCompleted(DockingEvent evt) {
        super.undockingCompleted(evt);
        EventQueue.invokeLater(() -> {
            if (evt.getOldDockingPort() == this && this.getDockableCount() == 0) {
                if (this.floatingWindow instanceof FloatingDialog) {
                    ((FloatingDialog)this.floatingWindow).destroy();
                } else if (this.floatingWindow instanceof FloatingFrame) {
                    ((FloatingFrame)this.floatingWindow).destroy();
                }
                this.floatingWindow = null;
            }
        });
    }

    @Override
    public int getDockableCount() {
        JComponent comp = this.getDockedComponent();
        if (comp instanceof JTabbedPane) {
            return ((JTabbedPane)comp).getTabCount();
        }
        return this.countDockables(this, 0);
    }

    private int countDockables(Container container, int counter) {
        Component[] componentArray = container.getComponents();
        int n = componentArray.length;
        int n2 = 0;
        while (n2 < n) {
            Component c = componentArray[n2];
            if (c instanceof IDockable) {
                ++counter;
            }
            if (c instanceof Container) {
                counter = this.countDockables((Container)c, counter);
            }
            ++n2;
        }
        if (this.floatingWindow != null && DockingManager.getMinimizeManager().getWindow(this.floatingWindow) == this.floatingWindow) {
            DockbarManager dm = DockbarManager.getInstance(this.floatingWindow);
            counter += dm.getDockbar(2).getDockableCount();
            counter += dm.getDockbar(3).getDockableCount();
            counter += dm.getDockbar(4).getDockableCount();
        }
        return counter;
    }
}

