/*
 * Decompiled with CFR 0.152.
 */
package de.javasoft.docking.controls;

import de.javasoft.docking.controls.DockingEvent;
import de.javasoft.docking.controls.DockingManager;
import de.javasoft.docking.controls.IDockable;
import de.javasoft.docking.controls.IDockingPort;
import de.javasoft.docking.controls.IFloatPolicy;
import de.javasoft.docking.controls.IFloatingDockingPort;

class FloatPolicy
implements IFloatPolicy {
    private static final FloatPolicy INSTANCE = new FloatPolicy();

    FloatPolicy() {
    }

    public static FloatPolicy getInstance() {
        return INSTANCE;
    }

    @Override
    public boolean isFloatDropAllowed(DockingEvent evt) {
        IFloatingDockingPort dockingPort;
        IDockingPort oldPort = evt.getOldDockingPort();
        if (oldPort instanceof IFloatingDockingPort && (dockingPort = (IFloatingDockingPort)oldPort).getDockableCount() < 2) {
            evt.consume();
            return false;
        }
        return true;
    }

    @Override
    public boolean isFloatingAllowed(IDockable dockable) {
        return dockable != null && DockingManager.isFloatingEnabled();
    }
}

