/*
 * Decompiled with CFR 0.152.
 */
package de.javasoft.docking.controls;

import de.javasoft.docking.controls.IDockable;
import de.javasoft.docking.controls.IDockingPort;
import de.javasoft.docking.controls.IDragPreview;
import de.javasoft.docking.controls.IRegionChecker;
import de.javasoft.docking.controls.RegionChecker;
import de.javasoft.plaf.synthetica.SyntheticaLookAndFeel;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;

abstract class DragPreview
implements IDragPreview {
    private static final int DEFAULT_TAB_WIDTH = SyntheticaLookAndFeel.getInstance().scaleInteger(Integer.valueOf(50));
    private static final int DEFAULT_TAB_HEIGHT = SyntheticaLookAndFeel.getInstance().scaleInteger(Integer.valueOf(20));

    DragPreview() {
    }

    @Override
    public abstract void drawPreview(Graphics2D var1, Polygon var2, IDockable var3, Map<Object, Object> var4);

    @Override
    public Polygon createPreviewPolygon(Component dockable, IDockingPort port, IDockable hover, String targetRegion, Component paintingTarget, Map<Object, Object> dragInfo) {
        if (dockable == null || port == null || targetRegion == null || paintingTarget == null) {
            return null;
        }
        if ("UNKNOWN".equals(targetRegion)) {
            return null;
        }
        if (hover == null) {
            Rectangle portBounds = port.getComponent().getBounds();
            portBounds = SwingUtilities.convertRectangle(port.getComponent().getParent(), portBounds, paintingTarget);
            return this.createPolyRect(portBounds);
        }
        Polygon p = null;
        JComponent srcAxes = hover.getComponent();
        if (this.isOuterRegion(targetRegion)) {
            p = this.createPolyRect(port, srcAxes, targetRegion);
        } else {
            int tabIndex = -1;
            if (dragInfo != null && dragInfo.get("DROP_TAB_INDEX") != null) {
                tabIndex = (Integer)dragInfo.get("DROP_TAB_INDEX");
            }
            p = this.createPolyTab(port, srcAxes, tabIndex);
            srcAxes = port.getComponent();
        }
        this.translate(srcAxes, p, paintingTarget);
        return p;
    }

    private void translate(Component src, Polygon poly, Component dest) {
        if (src == null || poly == null || dest == null) {
            return;
        }
        Rectangle srcRect = src.getBounds();
        srcRect.setLocation(0, 0);
        Rectangle destRect = SwingUtilities.convertRectangle(src, srcRect, dest);
        int deltaX = destRect.x - srcRect.x;
        int deltaY = destRect.y - srcRect.y;
        int len = poly.npoints;
        int i = 0;
        while (i < len) {
            int n = i;
            poly.xpoints[n] = poly.xpoints[n] + deltaX;
            int n2 = i++;
            poly.ypoints[n2] = poly.ypoints[n2] + deltaY;
        }
    }

    protected Polygon createPolyRect(IDockingPort port, Component dockable, String region) {
        IRegionChecker regionChecker = port.getRegionChecker();
        if (regionChecker == null) {
            regionChecker = new RegionChecker();
        }
        Rectangle r = regionChecker.getSiblingBounds(dockable, region);
        return this.createPolyRect(r);
    }

    protected Polygon createPolyRect(Rectangle r) {
        if (r == null) {
            return null;
        }
        int x2 = r.x + r.width;
        int y2 = r.y + r.height;
        int[] x = new int[]{r.x, x2, x2, r.x};
        int[] y = new int[]{r.y, r.y, y2, y2};
        return new Polygon(x, y, 4);
    }

    protected Polygon createPolyTab(IDockingPort port, Component hover, int dropTabIndex) {
        boolean tabsOnTop;
        JComponent c = port.getDockedComponent();
        Rectangle tabPaneRect = this.createTabbedPaneRect(port, hover);
        if (c == null && port.isSingleTabAllowed() == Boolean.FALSE.booleanValue()) {
            return this.createPolyRect(tabPaneRect);
        }
        Boolean tabDragPreview = (Boolean)port.getComponent().getClientProperty("JYDocking.tabDragPreview");
        if (tabDragPreview == Boolean.FALSE) {
            return this.createPolyRect(tabPaneRect);
        }
        if (dropTabIndex >= 0 && c instanceof JTabbedPane) {
            JTabbedPane tabPane = (JTabbedPane)c;
            return this.createPolyRect(tabPane.getBoundsAt(dropTabIndex));
        }
        Rectangle tabRect = new Rectangle(tabPaneRect.x, tabPaneRect.y, DEFAULT_TAB_WIDTH, DEFAULT_TAB_HEIGHT);
        boolean bl = tabsOnTop = port.getTabPlacement() == 1;
        if (c instanceof JTabbedPane) {
            JTabbedPane tabs = (JTabbedPane)c;
            Rectangle lastTab = tabs.getBoundsAt(tabs.getTabCount() - 1);
            tabRect.height = lastTab.height;
            tabRect.y = lastTab.y;
            tabRect.x = lastTab.x + lastTab.width;
            tabsOnTop = tabs.getTabPlacement() == 1;
        } else {
            int n = tabRect.y = tabsOnTop ? 0 : tabPaneRect.height - DEFAULT_TAB_HEIGHT;
            if (c != null) {
                tabRect.x += DEFAULT_TAB_WIDTH;
            }
        }
        tabPaneRect.height -= tabRect.height;
        if (tabsOnTop) {
            tabPaneRect.y += tabRect.height;
        }
        if (tabsOnTop) {
            return this.createPolyTabOnTop(tabPaneRect, tabRect);
        }
        return this.createPolyTabOnBottom(tabPaneRect, tabRect);
    }

    protected Rectangle createTabbedPaneRect(IDockingPort port, Component hover) {
        Rectangle tabPaneRect = port.getComponent().getBounds();
        tabPaneRect.setLocation(0, 0);
        return tabPaneRect;
    }

    protected Polygon createPolyTabOnTop(Rectangle tabPane, Rectangle tab) {
        Polygon p = new Polygon();
        int tabRight = tab.x + tab.width;
        int paneRight = tabPane.x + tabPane.width;
        int paneBottom = tabPane.y + tabPane.height;
        if (tab.x != 0) {
            p.addPoint(tabPane.x, tabPane.y);
            p.addPoint(tab.x, tabPane.y);
        }
        p.addPoint(tab.x, tab.y);
        p.addPoint(tabRight, tab.y);
        p.addPoint(tabRight, tabPane.y);
        p.addPoint(paneRight, tabPane.y);
        p.addPoint(paneRight, paneBottom);
        p.addPoint(tabPane.x, paneBottom);
        return p;
    }

    protected Polygon createPolyTabOnBottom(Rectangle tabPane, Rectangle tab) {
        Polygon p = new Polygon();
        int tabRight = tab.x + tab.width;
        int paneRight = tabPane.x + tabPane.width;
        int paneBottom = tabPane.y + tabPane.height;
        int tabBottom = paneBottom + tab.height;
        p.addPoint(tabPane.x, tabPane.y);
        p.addPoint(paneRight, tabPane.y);
        p.addPoint(paneRight, paneBottom);
        p.addPoint(tabRight, paneBottom);
        p.addPoint(tabRight, tabBottom);
        p.addPoint(tab.x, tabBottom);
        if (tab.x != 0) {
            p.addPoint(tab.x, paneBottom);
            p.addPoint(tabPane.x, paneBottom);
        }
        return p;
    }

    protected boolean isOuterRegion(String region) {
        return "NORTH".equals(region) || "SOUTH".equals(region) || "EAST".equals(region) || "WEST".equals(region);
    }

    protected void drawPolygon(Graphics2D g, Polygon p, int thickness) {
        Polygon poly = this.clonePolygon(p);
        Point center = this.getCenterOfGravity(poly);
        int i = 0;
        while (i < thickness) {
            g.drawPolygon(poly);
            this.gravitate(poly, center, 1);
            ++i;
        }
    }

    private Polygon clonePolygon(Polygon p) {
        return new Polygon((int[])p.xpoints.clone(), (int[])p.ypoints.clone(), p.npoints);
    }

    private void gravitate(Polygon p, Point center, int step) {
        int len = p.npoints;
        int i = 0;
        while (i < len) {
            int deltaX = center.x > p.xpoints[i] ? step : -step;
            int deltaY = center.y > p.ypoints[i] ? step : -step;
            int n = i;
            p.xpoints[n] = p.xpoints[n] + deltaX;
            int n2 = i++;
            p.ypoints[n2] = p.ypoints[n2] + deltaY;
        }
    }

    private Point getCenterOfGravity(Polygon p) {
        int x = 0;
        int y = 0;
        int len = p.npoints;
        int i = 0;
        while (i < len) {
            x += p.xpoints[i];
            y += p.ypoints[i];
            ++i;
        }
        return new Point(x / len, y / len);
    }
}

