/*
 * Decompiled with CFR 0.152.
 */
package de.javasoft.docking.controls;

import de.javasoft.docking.controls.DockingEvent;
import de.javasoft.docking.controls.DockingManager;
import de.javasoft.docking.controls.DockingPath;
import de.javasoft.docking.controls.DockingState;
import de.javasoft.docking.controls.DockingStrategy;
import de.javasoft.docking.controls.DockingUtility;
import de.javasoft.docking.controls.FloatingDialog;
import de.javasoft.docking.controls.FloatingDockingPort;
import de.javasoft.docking.controls.FloatingFrame;
import de.javasoft.docking.controls.IDockable;
import de.javasoft.docking.controls.IDockingEventListener;
import de.javasoft.docking.controls.IDockingPort;
import de.javasoft.docking.controls.Perspective;
import de.javasoft.docking.controls.RootWindow;
import java.awt.Component;
import java.awt.Container;
import java.awt.EventQueue;
import java.awt.Point;
import java.awt.Window;
import javax.swing.JComponent;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;

class DockingStateListener
implements IDockingEventListener {
    private boolean isEnabled = true;

    DockingStateListener() {
    }

    public void setEnabled(boolean isEnabled) {
        this.isEnabled = isEnabled;
    }

    public boolean isEnabled() {
        return this.isEnabled;
    }

    public void updateState(IDockable dockable) {
        if (dockable == null || !dockable.getComponent().isValid() || !DockingManager.isDocked(dockable)) {
            return;
        }
        this.updateFloating(dockable);
        this.updateCenterPoint(dockable);
        this.updateRelative(dockable);
        if (!DockingManager.isMaximized(dockable)) {
            this.updateDockingPath(dockable);
        }
    }

    private void updateFloating(IDockable dockable) {
        boolean isFloating;
        RootWindow rootWindow = RootWindow.getRootWindow(dockable.getComponent());
        Window rootComponent = rootWindow == null ? null : rootWindow.getWindow();
        boolean bl = isFloating = rootComponent instanceof FloatingDialog || rootComponent instanceof FloatingFrame;
        if (isFloating) {
            if (rootComponent instanceof FloatingDialog) {
                DockingManager.addToFloatingGroup(dockable, ((FloatingDialog)rootWindow.getWindow()).getGroupID());
            } else if (rootComponent instanceof FloatingFrame) {
                DockingManager.addToFloatingGroup(dockable, ((FloatingFrame)rootWindow.getWindow()).getGroupID());
            }
        } else {
            DockingManager.removeFromFloatingGroup(dockable);
        }
    }

    private void updateCenterPoint(IDockable dockable) {
        JComponent c = dockable.getComponent();
        Point p = new Point(((Component)c).getWidth() / 2, ((Component)c).getHeight() / 2);
        RootWindow rootWindow = RootWindow.getRootWindow(c);
        Container contentPane = rootWindow.getContentPane();
        p = SwingUtilities.convertPoint(c, p, contentPane);
        float x = (float)p.x / (float)contentPane.getWidth() * 100.0f;
        float y = (float)p.y / (float)contentPane.getHeight() * 100.0f;
        p.x = Math.round(x);
        p.y = Math.round(y);
        DockingState info = this.getDockingState(dockable, null);
        info.setCenter(p);
    }

    private void updateDockingPath(IDockable dockable) {
        DockingState state = this.getDockingState(dockable, null);
        DockingPath path = DockingPath.create(dockable);
        if (!(path.getRootDockingPort() instanceof FloatingDockingPort)) {
            state.setFloatingRestorePath((DockingPath)path.clone());
        }
        state.setPath(path);
    }

    private void updateRelative(IDockable dockable) {
        IDockable sibling;
        DockingState info = this.getDockingState(dockable, null);
        IDockingPort port = dockable.getDockingPort();
        if (port.getDockedComponent() != dockable.getComponent()) {
            return;
        }
        Container comp = port.getComponent().getParent();
        if (!(comp instanceof JSplitPane)) {
            this.setNullRelative(info);
            return;
        }
        JSplitPane splitPane = (JSplitPane)comp;
        Component siblingComp = this.getOtherComponent(splitPane, port.getComponent());
        if (!(siblingComp instanceof IDockingPort)) {
            this.setNullRelative(info);
            return;
        }
        JComponent otherDocked = ((IDockingPort)((Object)siblingComp)).getDockedComponent();
        IDockable iDockable = sibling = otherDocked instanceof JSplitPane || otherDocked instanceof JTabbedPane ? null : DockingManager.getDockable(otherDocked);
        if (sibling == null) {
            this.setNullRelative(info);
            return;
        }
        String region = DockingStrategy.findRegion(dockable.getComponent());
        float ratio = DockingUtility.calcSplitRatio(splitPane);
        info.setRelativeParentID(sibling.getID());
        info.setRegion(region);
        info.setSplitRatio(ratio);
        info = this.getDockingState(sibling, null);
        info.setRelativeParentID(dockable.getID());
        info.setRegion(DockingUtility.flipRegion(region));
        info.setSplitRatio(ratio);
    }

    private Component getOtherComponent(JSplitPane split, Component current) {
        if (split == null || current == null) {
            return null;
        }
        Component other = split.getLeftComponent();
        if (other == current) {
            other = split.getRightComponent();
        }
        return other;
    }

    private void setNullRelative(DockingState info) {
        info.setRelativeParentID(null);
        info.setSplitRatio(-1.0f);
        info.setRegion("CENTER");
    }

    private DockingState getDockingState(IDockable dockable, Perspective perspective) {
        if (perspective == null) {
            perspective = DockingManager.getPerspectiveManager().getCurrentPerspective();
        }
        return perspective.getDockingState(dockable, true);
    }

    @Override
    public void dockableRegistered(DockingEvent evt) {
    }

    @Override
    public void dockableUnregistered(DockingEvent evt) {
    }

    @Override
    public void dockingCanceled(DockingEvent evt) {
    }

    @Override
    public void dockingCompleted(DockingEvent evt) {
        if (!this.isEnabled()) {
            return;
        }
        final IDockable dockable = evt.getDockable();
        DockingState state = this.getDockingState(dockable, evt.getPerspective());
        state.setPlacement(-1);
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                DockingStateListener.this.updateState(dockable);
            }
        });
    }

    @Override
    public void undockingStarted(DockingEvent evt) {
        if (this.isEnabled()) {
            this.updateState(evt.getDockable());
        }
    }

    @Override
    public void undockingCompleted(DockingEvent evt) {
    }

    @Override
    public void dragStarted(DockingEvent evt) {
    }

    @Override
    public void dropStarted(DockingEvent evt) {
    }
}

