/*
 * Decompiled with CFR 0.152.
 */
package de.javasoft.docking.controls;

import de.javasoft.docking.controls.DockingPath;
import java.awt.Point;
import java.io.Serializable;

public class DockingState
implements Cloneable,
Serializable {
    private static final long serialVersionUID = -6782228304231760001L;
    private String dockableID;
    private String relativeParentID;
    private String region = "UNKNOWN";
    private float splitRatio = -1.0f;
    private int placement = -1;
    private boolean maximized;
    private String floatingGroupID;
    private int centerX = -1;
    private int centerY = -1;
    private DockingPath dockingPath;
    private DockingPath floatingRestorePath;
    private boolean active;
    private boolean selected;

    public DockingState(String dockableID) {
        this.dockableID = dockableID;
    }

    public String getDockableID() {
        return this.dockableID;
    }

    public void setRelativeParentID(String relativeParentID) {
        this.relativeParentID = relativeParentID;
    }

    public String getRelativeParentID() {
        return this.relativeParentID;
    }

    public void setRegion(String region) {
        this.region = region;
    }

    public String getRegion() {
        return this.region;
    }

    public void setSplitRatio(float ratio) {
        this.splitRatio = ratio;
    }

    public float getSplitRatio() {
        return this.splitRatio;
    }

    public void setFloatingGroupID(String groupID) {
        this.floatingGroupID = groupID;
    }

    public String getFloatingGroupID() {
        return this.floatingGroupID;
    }

    public boolean isFloating() {
        return this.floatingGroupID != null;
    }

    public void setPlacement(int placement) {
        this.placement = placement;
    }

    public int getPlacement() {
        return this.placement;
    }

    public boolean isMinimized() {
        return this.placement != -1;
    }

    public void setMaximized(boolean maximized) {
        this.maximized = maximized;
    }

    public boolean getMaximized() {
        return this.maximized;
    }

    public boolean isMaximized() {
        return this.maximized;
    }

    public void setCenterX(int centerX) {
        this.centerX = centerX;
    }

    public int getCenterX() {
        return this.centerX;
    }

    public void setCenterY(int centerY) {
        this.centerY = centerY;
    }

    public int getCenterY() {
        return this.centerY;
    }

    public void setCenter(Point p) {
        this.centerX = p == null ? 0 : p.x;
        this.centerY = p == null ? 0 : p.y;
    }

    public Point getCenterPoint() {
        if (this.centerX == -1 || this.centerY == -1) {
            return null;
        }
        return new Point(this.centerX, this.centerY);
    }

    public boolean hasCenterPoint() {
        return this.centerX != -1 && this.centerY != -1;
    }

    public DockingPath getPath() {
        return this.dockingPath;
    }

    public void setPath(DockingPath path) {
        this.dockingPath = path;
    }

    public boolean hasDockingPath() {
        return this.dockingPath != null;
    }

    public DockingPath getFloatingRestorePath() {
        return this.floatingRestorePath == null ? (this.getPath() == null ? null : (DockingPath)this.getPath().clone()) : this.floatingRestorePath;
    }

    public void setFloatingRestorePath(DockingPath path) {
        this.floatingRestorePath = path;
    }

    public boolean hasFloatingRestorePath() {
        return this.getFloatingRestorePath() != null;
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    public boolean isActive() {
        return this.active;
    }

    public void setSelected(boolean selected) {
        this.selected = selected;
    }

    public boolean isSelected() {
        return this.selected;
    }

    public Object clone() {
        DockingState clone = new DockingState(this.dockableID);
        clone.relativeParentID = this.relativeParentID;
        clone.region = this.region;
        clone.splitRatio = this.splitRatio;
        clone.floatingGroupID = this.floatingGroupID;
        clone.maximized = this.maximized;
        clone.placement = this.placement;
        clone.dockingPath = this.dockingPath == null ? null : (DockingPath)this.dockingPath.clone();
        clone.floatingRestorePath = this.floatingRestorePath == null ? null : (DockingPath)this.floatingRestorePath.clone();
        clone.centerX = this.centerX;
        clone.centerY = this.centerY;
        clone.active = this.active;
        clone.selected = this.selected;
        return clone;
    }

    public String toString() {
        return "DockingState[id=" + this.dockableID + "; center=[" + this.centerX + "%," + this.centerY + "%]" + "; parent=" + this.relativeParentID + "; region=" + this.region + "; ratio=" + this.splitRatio + "; float=" + this.floatingGroupID + "; minimization=" + this.placement + "; maximized=" + this.maximized + "; active=" + this.active + "; selected=" + this.selected + "; ]";
    }
}

