/*
 * Decompiled with CFR 0.152.
 */
package de.javasoft.docking.controls;

import de.javasoft.docking.controls.ActiveDockableTracker;
import de.javasoft.docking.controls.BorderManager;
import de.javasoft.docking.controls.DockingEvent;
import de.javasoft.docking.controls.DockingManager;
import de.javasoft.docking.controls.DockingPortTracker;
import de.javasoft.docking.controls.DockingSplitPane;
import de.javasoft.docking.controls.DockingState;
import de.javasoft.docking.controls.DockingUtility;
import de.javasoft.docking.controls.DragManager;
import de.javasoft.docking.controls.DragTabListener;
import de.javasoft.docking.controls.IBorderManager;
import de.javasoft.docking.controls.IDockable;
import de.javasoft.docking.controls.IDockingConstants;
import de.javasoft.docking.controls.IDockingEventListener;
import de.javasoft.docking.controls.IDockingPort;
import de.javasoft.docking.controls.IDockingStrategy;
import de.javasoft.docking.controls.ILayoutNode;
import de.javasoft.docking.controls.IRegionChecker;
import de.javasoft.docking.controls.Perspective;
import de.javasoft.docking.controls.PerspectiveManager;
import de.javasoft.docking.controls.PerspectiveModel;
import de.javasoft.docking.controls.RegionChecker;
import de.javasoft.plaf.synthetica.SyntheticaLookAndFeel;
import de.javasoft.tabpane.JYTabbedPane;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.LayoutManager2;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.WeakHashMap;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.tree.TreeNode;

public class DockingPort
extends JPanel
implements IDockingPort,
IDockingConstants {
    private static final long serialVersionUID = -3178316774389639543L;
    private static final WeakHashMap<Component, String> COMPONENT_TITLES = new WeakHashMap();
    protected ArrayList<IDockingEventListener> dockingListeners;
    private IBorderManager borderManager;
    private String id;
    private boolean tabsAsDragSourceEnabled;
    private boolean rootPort;
    private static PropertyChangeListener dockablePropertyHandler = new DockablePropertyChangeHandler();
    private MaximizationInstallInfo maximizationInstallInfo;
    private MaximizationReleaseInfo maximizationReleaseInfo;
    private static final IRegionChecker DEFAULT_REGION_CHECKER = new RegionChecker();
    private IRegionChecker regionChecker;
    private boolean singleTabAllowed;
    private int tabPlacement;
    private HashMap<String, Float> regionInset;

    public DockingPort() {
        this(UUID.randomUUID().toString());
    }

    public DockingPort(String id) {
        this.setID(id);
        this.dockingListeners = new ArrayList(2);
        this.addDockingListener(this);
        this.addHierarchyListener(DockingPortTracker.getInstance());
        this.addAncestorListener(DockingPortTracker.getInstance());
        this.rootPort = true;
        this.setLayout(this.createLayout());
        this.setBorderManager(this.createBorderManager());
        this.regionChecker = DEFAULT_REGION_CHECKER;
        this.tabPlacement = 3;
        this.regionInset = new HashMap();
        this.regionInset.put("NORTH", Float.valueOf(0.25f));
        this.regionInset.put("SOUTH", Float.valueOf(0.25f));
        this.regionInset.put("EAST", Float.valueOf(0.25f));
        this.regionInset.put("WEST", Float.valueOf(0.25f));
    }

    @Override
    public JComponent getComponent() {
        return this;
    }

    @Override
    public IDockable getDockable(String region) {
        JComponent c = this.getDockedComponent(region);
        return DockingManager.getDockable(c);
    }

    @Override
    public JComponent getDockedComponent() {
        return this.getDockedComponent(null);
    }

    @Override
    public JComponent getDockedComponent(String region) {
        JComponent docked;
        JComponent jComponent = docked = this.getComponentCount() == 0 ? null : (JComponent)this.getComponent(0);
        if (region == null) {
            return docked;
        }
        if (docked == null) {
            return null;
        }
        if (docked instanceof JTabbedPane) {
            if (!"CENTER".equals(region)) {
                return null;
            }
            JTabbedPane tabs = (JTabbedPane)docked;
            return (JComponent)tabs.getSelectedComponent();
        }
        if (docked instanceof JSplitPane) {
            Component c;
            boolean horizontal;
            if ("CENTER".equals(region)) {
                return null;
            }
            JSplitPane split = (JSplitPane)docked;
            boolean bl = horizontal = split.getOrientation() == 1;
            if (horizontal ? "NORTH".equals(region) || "SOUTH".equals(region) : "EAST".equals(region) || "WEST".equals(region)) {
                return null;
            }
            boolean left = "NORTH".equals(region) || "WEST".equals(region);
            Component component = c = left ? split.getLeftComponent() : split.getRightComponent();
            if (!(c instanceof IDockingPort)) {
                return null;
            }
            return ((IDockingPort)((Object)c)).getDockedComponent();
        }
        return "CENTER".equals(region) ? docked : null;
    }

    public boolean dock(IDockable dockable, String region) {
        return this.dock(dockable, DockingManager.getPerspectiveManager().getCurrentPerspective(), region);
    }

    @Override
    public boolean dock(IDockable dockable, Perspective perspective, String region) {
        boolean success;
        if (dockable == null) {
            return false;
        }
        JComponent comp = dockable.getComponent();
        if (comp == null) {
            return false;
        }
        JComponent docked = this.getDockedComponent();
        if (comp == docked) {
            return false;
        }
        if (docked == null) {
            region = "CENTER";
        }
        String tabTitle = dockable.getTabText();
        COMPONENT_TITLES.put(comp, tabTitle);
        if (!this.isSingleTabAllowed() && docked == null) {
            this.setDockedComponent(comp, perspective, region);
            this.evaluateDockingBorderStatus();
            return true;
        }
        this.updateSelectedDockingState(dockable, false);
        boolean bl = success = "CENTER".equals(region) ? this.dockInCenterRegion(comp, perspective) : this.dockInOuterRegion(comp, perspective, region);
        if (success) {
            this.evaluateDockingBorderStatus();
            if (!"CENTER".equals(region)) {
                this.resetSplitDividerLocation();
            }
        }
        return success;
    }

    @Override
    public boolean undock(IDockable dockable) {
        return this.undockComponent(dockable.getComponent());
    }

    public boolean dockComponent(JComponent c, String region) {
        return this.dockComponent(c, DockingManager.getPerspectiveManager().getCurrentPerspective(), region);
    }

    @Override
    public boolean dockComponent(JComponent c, Perspective perspective, String region) {
        if (c == null || region == null) {
            return false;
        }
        IDockable dockable = DockingManager.getDockable(c);
        if (dockable == null) {
            dockable = DockingManager.registerDockableComponent(c);
        }
        return this.dock(dockable, perspective, region);
    }

    @Override
    public boolean undockComponent(JComponent c) {
        if (!this.isParentDockingPort(c)) {
            return false;
        }
        Container parent = c.getParent();
        if (parent.getParent() instanceof JYTabbedPane) {
            parent = parent.getParent();
        }
        parent.remove(c);
        this.reevaluateContainerTree();
        return true;
    }

    @Override
    public void setID(String id) {
        if (id == null) {
            id = UUID.randomUUID().toString();
        }
        this.id = id;
        DockingPortTracker.addDockingPort(this);
    }

    @Override
    public String getID() {
        return this.id;
    }

    @Override
    public String getRegion(Point location) {
        if (location == null) {
            return "UNKNOWN";
        }
        IRegionChecker regionChecker = this.getRegionChecker();
        IDockable d = this.getDockableAt(location);
        JComponent c = this;
        if (d != null) {
            c = d.getComponent();
            location = SwingUtilities.convertPoint(this, location, c);
        }
        return regionChecker.getRegion(c, location);
    }

    @Override
    public IDockingStrategy getDockingStrategy() {
        return DockingManager.getDockingStrategy(this);
    }

    @Override
    public Set<IDockable> getDockables() {
        return this.getDockables(-1, 0, null);
    }

    protected Set<IDockable> getDockables(int depth, int level, Class<?> desiredClass) {
        Component c = this.getDockedComponent();
        if (c instanceof JTabbedPane) {
            JTabbedPane tabs = (JTabbedPane)c;
            int len = tabs.getTabCount();
            HashSet<IDockable> set = new HashSet<IDockable>(len);
            int i = 0;
            while (i < len) {
                c = tabs.getComponentAt(i);
                if (this.isValidDockableChild(c, desiredClass)) {
                    if (c instanceof IDockable) {
                        set.add((IDockable)((Object)c));
                    } else {
                        set.add(DockingManager.getDockable(c));
                    }
                }
                ++i;
            }
            return set;
        }
        HashSet<IDockable> set = new HashSet<IDockable>(1);
        if (c instanceof JSplitPane && (depth < 0 || level <= depth)) {
            JSplitPane pane = (JSplitPane)c;
            Component sub1 = pane.getLeftComponent();
            Component sub2 = pane.getRightComponent();
            if (sub1 instanceof DockingPort) {
                set.addAll(((DockingPort)sub1).getDockables(depth, level + 1, desiredClass));
            }
            if (sub2 instanceof DockingPort) {
                set.addAll(((DockingPort)sub2).getDockables(depth, level + 1, desiredClass));
            }
        }
        if (this.isValidDockableChild(c, desiredClass)) {
            if (c instanceof IDockable) {
                set.add((IDockable)((Object)c));
            } else {
                set.add(DockingManager.getDockable(c));
            }
        }
        return set;
    }

    protected boolean isValidDockableChild(Component c, Class<?> desiredClass) {
        return desiredClass == null ? DockingManager.getDockable(c) != null : desiredClass.isAssignableFrom(c.getClass());
    }

    @Override
    public boolean isDockingAllowed(Component c, String region) {
        if (c == null || !DockingManager.isValidDockingRegion(region)) {
            return false;
        }
        IDockable targetDockable = this.getCenterDockable();
        if (targetDockable != null && c instanceof IDockable && !targetDockable.getDockableAcceptor().acceptDockable((IDockable)((Object)c), region)) {
            return false;
        }
        if (!this.isParentDockingPort(c)) {
            return true;
        }
        JComponent docked = this.getDockedComponent();
        if (!(docked instanceof JTabbedPane)) {
            return false;
        }
        JTabbedPane tabs = (JTabbedPane)docked;
        return tabs.getTabCount() >= 2;
    }

    @Override
    public boolean isParentDockingPort(Component c) {
        if (c == null) {
            return false;
        }
        Container parent = c.getParent();
        if (parent == null) {
            return false;
        }
        if (parent.getParent() instanceof JYTabbedPane) {
            parent = parent.getParent();
        }
        if (parent == this) {
            return true;
        }
        return parent == this.getDockedComponent();
    }

    @Override
    public void importLayout(ILayoutNode node) {
        if (!(node instanceof PerspectiveModel.DockingPortNode)) {
            return;
        }
        node.setUserObject(this);
        ArrayList<PerspectiveModel.SplitNode> splitPaneResizeList = new ArrayList<PerspectiveModel.SplitNode>();
        this.constructLayout(node, splitPaneResizeList);
        this.deferSplitPaneValidation(splitPaneResizeList);
        this.revalidate();
    }

    @Override
    public void clear() {
        this.removeAll();
    }

    @Override
    public void releaseForMaximization(IDockable dockable) {
        if (this.maximizationReleaseInfo != null) {
            throw new IllegalStateException("Already released a Dockable for maximization.");
        }
        JComponent comp = dockable.getComponent();
        this.maximizationReleaseInfo = new MaximizationReleaseInfo(comp, comp.getBorder());
        JComponent docked = this.getDockedComponent();
        if (docked == null) {
            throw new IllegalStateException("DefaultDockingPort is empty.");
        }
        if (docked instanceof JSplitPane) {
            throw new IllegalStateException("DefaultDockingPort does not directly contain a Dockable");
        }
        if (docked instanceof JTabbedPane) {
            JTabbedPane tabs = (JTabbedPane)docked;
            this.maximizationReleaseInfo.setTabIndex(this.getTabIndex(tabs, comp));
            tabs.remove(comp);
        } else {
            if (comp != docked) {
                throw new IllegalStateException("Dockable requesting maximization is not the one docked in this DefaultDockingPort.");
            }
            this.remove(comp);
        }
    }

    @Override
    public void returnFromMaximization() {
        JComponent comp = this.maximizationReleaseInfo.getContent();
        comp.setBorder(this.maximizationReleaseInfo.getBorder());
        int tabIndex = this.maximizationReleaseInfo.getTabIndex();
        this.maximizationReleaseInfo = null;
        JComponent docked = this.getDockedComponent();
        if (docked != null && docked instanceof JTabbedPane) {
            JTabbedPane tabs = (JTabbedPane)docked;
            tabs.add(comp, this.getValidTabTitle(tabs, comp), tabIndex);
            tabs.setSelectedIndex(tabIndex);
        } else {
            this.setDockedComponent(comp);
        }
        this.revalidate();
    }

    @Override
    public void installMaximizedDockable(IDockable dockable) {
        if (this.maximizationInstallInfo != null) {
            throw new IllegalStateException("Already maximized");
        }
        this.maximizationInstallInfo = new MaximizationInstallInfo(this.getDockedComponent(), this.getBorder());
        JComponent newComponent = dockable.getComponent();
        this.setDockedComponent(newComponent);
        this.evaluateDockingBorderStatus();
        this.revalidate();
    }

    @Override
    public void uninstallMaximizedDockable() {
        if (this.maximizationInstallInfo == null) {
            throw new IllegalStateException("No dockable maximized.");
        }
        JComponent c = this.maximizationInstallInfo.getContent();
        if (c != null) {
            this.setDockedComponent(c);
        }
        this.setBorder(this.maximizationInstallInfo.getBorder());
        this.maximizationInstallInfo = null;
        this.revalidate();
    }

    @Override
    public void addDockingListener(IDockingEventListener listener) {
        if (listener != null) {
            this.dockingListeners.add(listener);
        }
    }

    @Override
    public void removeDockingListener(IDockingEventListener listener) {
        if (listener != null) {
            this.dockingListeners.remove(listener);
        }
    }

    @Override
    public List<IDockingEventListener> getDockingListeners() {
        return this.dockingListeners;
    }

    @Override
    public void setRegionChecker(IRegionChecker regionChecker) {
        IRegionChecker oldValue = this.getRegionChecker();
        this.regionChecker = regionChecker;
        this.firePropertyChange("regionChecker", oldValue, regionChecker);
    }

    @Override
    public IRegionChecker getRegionChecker() {
        return this.regionChecker;
    }

    @Override
    public void setSingleTabAllowed(boolean allowed) {
        boolean oldValue = this.isSingleTabAllowed();
        this.singleTabAllowed = allowed;
        this.firePropertyChange("singleTabAllowed", oldValue, allowed);
    }

    @Override
    public boolean isSingleTabAllowed() {
        return this.singleTabAllowed;
    }

    @Override
    public void setTabPlacement(int placement) {
        int oldValue = this.getTabPlacement();
        this.tabPlacement = placement;
        if (this.getComponentCount() > 0 && this.getComponent(0) instanceof JTabbedPane) {
            ((JTabbedPane)this.getComponent(0)).setTabPlacement(placement);
        }
        this.firePropertyChange("tabPlacement", oldValue, placement);
    }

    @Override
    public int getTabPlacement() {
        return this.tabPlacement;
    }

    @Override
    public void setSelectedTabIndex(int index) {
        if (this.getComponent(0) instanceof JYTabbedPane) {
            ((JYTabbedPane)this.getComponent(0)).setSelectedIndex(index, true);
        }
    }

    @Override
    public int getSelectedTabIndex() {
        if (this.getComponent(0) instanceof JTabbedPane) {
            return ((JTabbedPane)this.getComponent(0)).getSelectedIndex();
        }
        return -1;
    }

    @Override
    public void setRegionInset(String region, float inset) {
        this.regionInset.put(region, Float.valueOf(inset));
    }

    @Override
    public float getRegionInset(String region) {
        Float inset = this.regionInset.get(region);
        return inset == null ? 0.0f : inset.floatValue();
    }

    @Override
    public void dockableRegistered(DockingEvent evt) {
    }

    @Override
    public void dockableUnregistered(DockingEvent evt) {
    }

    @Override
    public void dockingCanceled(DockingEvent evt) {
    }

    @Override
    public void dockingCompleted(DockingEvent evt) {
        IDockable dockable = evt.getDockable();
        if (dockable == null || evt.getNewDockingPort() != this) {
            return;
        }
        boolean installed = false;
        PropertyChangeListener[] propertyChangeListenerArray = dockable.getComponent().getPropertyChangeListeners();
        int n = propertyChangeListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            PropertyChangeListener l = propertyChangeListenerArray[n2];
            installed = l == dockablePropertyHandler;
            ++n2;
        }
        if (!installed) {
            dockable.getComponent().addPropertyChangeListener(dockablePropertyHandler);
        }
    }

    @Override
    public void undockingStarted(DockingEvent evt) {
    }

    @Override
    public void undockingCompleted(DockingEvent evt) {
        IDockable dockable = evt.getDockable();
        dockable.getComponent().removePropertyChangeListener(dockablePropertyHandler);
    }

    @Override
    public void dragStarted(DockingEvent evt) {
    }

    @Override
    public void dropStarted(DockingEvent evt) {
    }

    @Override
    public Component add(Component c) {
        return this.setDockedComponent((JComponent)c);
    }

    @Override
    public Component add(Component c, int index) {
        return this.setDockedComponent((JComponent)c);
    }

    @Override
    public void add(Component c, Object constraints) {
        this.setDockedComponent((JComponent)c);
    }

    @Override
    public void add(Component c, Object constraints, int index) {
        this.setDockedComponent((JComponent)c);
    }

    @Override
    public Component add(String name, Component c) {
        return this.setDockedComponent((JComponent)c);
    }

    private void addCmp(IDockingPort port, JComponent c) {
        if (port instanceof Container) {
            ((Container)((Object)port)).add(c);
        }
    }

    public void dock(IDockable dockable) {
        this.dock(dockable, DockingManager.getPerspectiveManager().getCurrentPerspective());
    }

    void dock(IDockable dockable, Perspective perspective) {
        this.dock(dockable, perspective, "CENTER");
    }

    protected LayoutManager createLayout() {
        return new PortLayout();
    }

    protected IBorderManager createBorderManager() {
        return new BorderManager(SyntheticaLookAndFeel.getInstance().createEmptyBorder(0, 0, 0, 0, true));
    }

    public void setBorderManager(IBorderManager mgr) {
        this.borderManager = mgr;
    }

    public IBorderManager getBorderManager() {
        return this.borderManager;
    }

    public void setTabsAsDragSourceEnabled(boolean enabled) {
        this.tabsAsDragSourceEnabled = enabled;
    }

    public boolean isTabsAsDragSourceEnabled() {
        return this.tabsAsDragSourceEnabled;
    }

    @Override
    public boolean isRoot() {
        return this.rootPort;
    }

    void setRoot(boolean root) {
        this.rootPort = root;
    }

    protected JTabbedPane createTabbedPane() {
        JYTabbedPane pane = new JYTabbedPane();
        pane.setFocusable(false);
        pane.setTabReorderByDraggingEnabled(Boolean.valueOf(false));
        pane.setTabPlacement(this.getTabPlacement());
        DragTabListener tdl = new DragTabListener();
        pane.addMouseListener((MouseListener)tdl);
        pane.addMouseMotionListener((MouseMotionListener)tdl);
        return pane;
    }

    protected void updateTab(IDockable dockable) {
        JTabbedPane tabs;
        int index;
        JComponent docked = this.getDockedComponent();
        if (docked instanceof JTabbedPane && (index = (tabs = (JTabbedPane)docked).indexOfComponent(dockable.getComponent())) > -1) {
            tabs.setIconAt(index, dockable.getTabIcon());
            tabs.setTitleAt(index, dockable.getTabText());
        }
    }

    void evaluateDockingBorderStatus() {
        if (this.borderManager == null) {
            return;
        }
        JComponent docked = this.getDockedComponent();
        if (docked == null) {
            this.borderManager.managePortNullChild(this);
        } else if (docked instanceof JSplitPane) {
            this.borderManager.managePortSplitChild(this);
        } else if (docked instanceof JTabbedPane) {
            this.borderManager.managePortTabbedChild(this);
        } else {
            this.borderManager.managePortSimpleChild(this);
        }
    }

    private IDockable getDockableAt(Point location) {
        if (location == null) {
            return null;
        }
        JComponent docked = this.getDockedComponent();
        if (docked == null || docked instanceof JSplitPane) {
            return null;
        }
        if (docked instanceof JTabbedPane) {
            JTabbedPane tabPane = (JTabbedPane)docked;
            Component c = tabPane.getComponentAt(tabPane.getSelectedIndex());
            return c instanceof IDockable ? (IDockable)((Object)c) : DockingManager.getDockable(c);
        }
        return DockingManager.getDockable(docked);
    }

    private JComponent setDockedComponent(JComponent c, Perspective perspective, String region) {
        IDockable d = DockingManager.getDockable(c);
        if (c instanceof JTabbedPane) {
            JTabbedPane tabPane = (JTabbedPane)c;
            d = DockingManager.getDockable(tabPane.getSelectedComponent());
            if (d != null) {
                this.updateDockingState(d, perspective, region);
            }
        } else if (c instanceof JSplitPane) {
            JSplitPane splitPane = (JSplitPane)c;
            d = DockingManager.getDockable(splitPane.getLeftComponent());
            if (d != null) {
                this.updateDockingState(d, perspective, region);
            }
            if ((d = DockingManager.getDockable(splitPane.getRightComponent())) != null) {
                this.updateDockingState(d, perspective, region);
            }
        } else if (d != null) {
            this.updateDockingState(d, perspective, region);
        }
        JComponent comp = this.setDockedComponent(c);
        return comp;
    }

    private void updateDockingState(IDockable d, Perspective perspective, String region) {
        DockingEvent evt = new DockingEvent(d, d.getDockingPort(), this, 4, DragManager.getDragContext(d));
        evt.setPerspective(perspective);
        evt.setRegion(region);
        DockingManager.dispatchEvent(evt, true, true);
    }

    private JComponent setDockedComponent(JComponent c) {
        this.removeAll();
        JComponent ret = (JComponent)super.add(c);
        return ret;
    }

    private void resetSplitDividerLocation() {
        JComponent c = this.getDockedComponent();
        if (c instanceof JSplitPane) {
            JSplitPane splitPane = (JSplitPane)c;
            IDockingStrategy strategy = DockingManager.getDockingStrategy(this);
            int loc = strategy.getInitialDividerLocation(this, splitPane);
            splitPane.setDividerLocation(loc);
        }
    }

    private void constructLayout(ILayoutNode node, ArrayList<PerspectiveModel.SplitNode> splitPaneResizeList) {
        Object obj = node.getUserObject();
        if (node instanceof PerspectiveModel.SplitNode) {
            splitPaneResizeList.add((PerspectiveModel.SplitNode)node);
        }
        Enumeration<? extends TreeNode> en = node.children();
        while (en.hasMoreElements()) {
            ILayoutNode child = (ILayoutNode)en.nextElement();
            this.constructLayout(child, splitPaneResizeList);
        }
        if (node instanceof PerspectiveModel.SplitNode) {
            this.reconstruct((PerspectiveModel.SplitNode)node);
        } else if (node instanceof PerspectiveModel.DockingPortNode) {
            this.reconstruct((PerspectiveModel.DockingPortNode)node);
        }
    }

    private boolean dockInCenterRegion(Component c, Perspective perspective) {
        JComponent docked = this.getDockedComponent();
        JTabbedPane tabPane = null;
        if (docked instanceof JTabbedPane) {
            tabPane = (JTabbedPane)docked;
            this.addTab(tabPane, c);
            tabPane.revalidate();
            tabPane.setSelectedIndex(tabPane.getTabCount() - 1);
            this.updateDockingState(DockingManager.getDockable(c), perspective, "CENTER");
            return true;
        }
        tabPane = this.createTabbedPane();
        if (tabPane == null) {
            return false;
        }
        tabPane.addChangeListener(ActiveDockableTracker.getInstance());
        tabPane.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                JTabbedPane tabbedPane = (JTabbedPane)evt.getSource();
                int selectedIndex = tabbedPane.getSelectedIndex();
                int i = 0;
                while (i < tabbedPane.getTabCount()) {
                    Component c_ = tabbedPane.getComponentAt(i);
                    if (c_ instanceof IDockable) {
                        IDockable dockable = (IDockable)((Object)c_);
                        boolean selected = i == selectedIndex;
                        DockingPort.this.updateSelectedDockingState(dockable, selected);
                    }
                    ++i;
                }
            }
        });
        if (docked != null) {
            this.remove(docked);
            if (docked instanceof DockingSplitPane) {
                this.addSplitPanelToTabbedPane(tabPane, (DockingSplitPane)docked);
            } else {
                this.addTab(tabPane, docked);
            }
        }
        this.addTab(tabPane, c);
        tabPane.setSelectedIndex(tabPane.getTabCount() - 1);
        this.setDockedComponent(tabPane, perspective, "CENTER");
        return true;
    }

    private void updateSelectedDockingState(IDockable dockable, boolean selected) {
        DockingState state;
        Perspective p = PerspectiveManager.getInstance().getCurrentPerspective();
        if (!p.isLoading() && !p.isUnloading() && (state = p.getModel().getDockingState(dockable, false)) != null) {
            state.setSelected(selected);
        }
    }

    private void addSplitPanelToTabbedPane(JTabbedPane tabbedPane, DockingSplitPane split) {
        JComponent lc = ((DockingPort)split.getLeftComponent()).getDockedComponent();
        if (lc instanceof DockingSplitPane) {
            this.addSplitPanelToTabbedPane(tabbedPane, (DockingSplitPane)lc);
        } else if (lc instanceof JTabbedPane) {
            this.addTabbedPaneToTabbedPane(tabbedPane, (JTabbedPane)lc);
        } else {
            this.addTab(tabbedPane, lc);
        }
        JComponent rc = ((DockingPort)split.getRightComponent()).getDockedComponent();
        if (rc instanceof DockingSplitPane) {
            this.addSplitPanelToTabbedPane(tabbedPane, (DockingSplitPane)rc);
        } else if (rc instanceof JTabbedPane) {
            this.addTabbedPaneToTabbedPane(tabbedPane, (JTabbedPane)rc);
        } else {
            this.addTab(tabbedPane, rc);
        }
    }

    private void addTabbedPaneToTabbedPane(JTabbedPane tabPane, JTabbedPane child) {
        while (child.getTabCount() > 0) {
            this.addTab(tabPane, child.getComponentAt(0));
        }
    }

    private void addTab(JTabbedPane tabPane, Component comp) {
        String tabText = this.getValidTabTitle(tabPane, comp);
        tabPane.add(comp, tabText);
        IDockable d = DockingManager.getDockable(comp);
        if (d != null) {
            Icon icon = d.getTabIcon();
            int indx = tabPane.getTabCount() - 1;
            tabPane.setIconAt(indx, icon);
        }
    }

    private boolean dockInOuterRegion(JComponent c, Perspective perspective, String region) {
        JComponent docked = this.getDockedComponent();
        this.remove(docked);
        IDockingStrategy strategy = this.getDockingStrategy();
        IDockingPort oldContent = strategy.createDockingPort(this);
        IDockingPort newContent = strategy.createDockingPort(this);
        this.addCmp(oldContent, docked);
        newContent.dockComponent(c, perspective, "CENTER");
        JSplitPane splitPane = strategy.createSplitPane(this, region);
        IDockingPort[] ports = this.putPortsInOrder(oldContent, newContent, region);
        if (ports[0] != null) {
            splitPane.setLeftComponent(ports[0].getComponent());
        }
        if (ports[1] != null) {
            splitPane.setRightComponent(ports[1].getComponent());
        }
        double ratio = 0.5;
        IDockable dockable = DockingManager.getDockable(docked);
        if (dockable != null && splitPane instanceof DockingSplitPane) {
            Float siblingRatio = Float.valueOf(dockable.getSiblingSize(region));
            if (siblingRatio != null) {
                ratio = siblingRatio.doubleValue();
            }
            ((DockingSplitPane)splitPane).setInitialDividerRatio(ratio);
        }
        splitPane.setDividerLocation(ratio);
        this.setDockedComponent(splitPane, perspective, region);
        if (this.isShowing()) {
            return true;
        }
        double proportion = strategy.getDividerProportion(this, splitPane);
        oldContent.getComponent().putClientProperty("DefaultDockingStrategy.PREFERRED_PROPORTION", Float.valueOf(Double.valueOf(proportion).floatValue()));
        newContent.getComponent().putClientProperty("DefaultDockingStrategy.PREFERRED_PROPORTION", Float.valueOf(Double.valueOf(1.0 - proportion).floatValue()));
        return true;
    }

    @Override
    public Dimension getMinimumSize() {
        Dimension minSize;
        int minPortSizeWidth = SyntheticaLookAndFeel.getInt((String)"JYDocking.minimumPortSizeWidth", (Component)this, (int)80, (boolean)true);
        int minPortSizeHeight = SyntheticaLookAndFeel.getInt((String)"JYDocking.minimumPortSizeHeight", (Component)this, (int)40, (boolean)true);
        Dimension dimension = minSize = SyntheticaLookAndFeel.getBoolean((String)"JYDocking.respectMinimumDockableSize", (Component)this, (boolean)false) ? super.getMinimumSize() : null;
        if (minSize == null || minSize.width < minPortSizeWidth && minSize.height < minPortSizeHeight) {
            return new Dimension(minPortSizeWidth, minPortSizeHeight);
        }
        if (minSize.width < minPortSizeWidth) {
            return new Dimension(minPortSizeWidth, minSize.height);
        }
        if (minSize.height < minPortSizeHeight) {
            return new Dimension(minSize.width, minPortSizeHeight);
        }
        return minSize;
    }

    private String getValidTabTitle(JTabbedPane tabs, Component comp) {
        String title = COMPONENT_TITLES.get(comp);
        if (title == null || title.trim().length() == 0) {
            title = "null";
        }
        int tc = tabs.getTabCount();
        int occurrances = 0;
        HashSet<String> titles = new HashSet<String>();
        String tmp = null;
        int i = 0;
        while (i < tc) {
            tmp = tabs.getTitleAt(i).toLowerCase();
            titles.add(tmp);
            if (tmp.startsWith(title.toLowerCase())) {
                ++occurrances;
            }
            ++i;
        }
        if (titles.contains(title) && occurrances > 0) {
            title = String.valueOf(title) + occurrances;
        }
        COMPONENT_TITLES.put(comp, title);
        return title;
    }

    private boolean isSingleComponentDocked() {
        JComponent c = this.getDockedComponent();
        if (c == null) {
            return false;
        }
        if (c instanceof JSplitPane) {
            return false;
        }
        if (c instanceof JTabbedPane) {
            return ((JTabbedPane)c).getTabCount() == 1;
        }
        return true;
    }

    protected IDockable getCenterDockable() {
        if (!this.isSingleComponentDocked()) {
            return null;
        }
        Component c = this.getDockedComponent();
        if (c instanceof JTabbedPane) {
            c = ((JTabbedPane)c).getComponentAt(0);
        }
        return DockingManager.getDockable(c);
    }

    private IDockingPort[] putPortsInOrder(IDockingPort oldPort, IDockingPort newPort, String region) {
        if ("NORTH".equals(region) || "WEST".equals(region)) {
            return new IDockingPort[]{newPort, oldPort};
        }
        return new IDockingPort[]{oldPort, newPort};
    }

    private void reevaluateContainerTree() {
        this.reevaluateDockingWrapper();
        this.reevaluateTabbedPane();
        this.evaluateDockingBorderStatus();
    }

    private void reevaluateDockingWrapper() {
        Container grandParent;
        JComponent docked = this.getDockedComponent();
        Container parent = this.getParent();
        Container container = grandParent = parent == null ? null : parent.getParent();
        if (docked == null && parent instanceof JSplitPane && grandParent instanceof DockingPort) {
            parent.remove(this);
            ((DockingPort)grandParent).reevaluateContainerTree();
        } else if (docked instanceof JSplitPane) {
            JSplitPane wrapper = (JSplitPane)docked;
            JComponent left = (JComponent)wrapper.getLeftComponent();
            JComponent right = (JComponent)wrapper.getRightComponent();
            if (left != null && right != null) {
                return;
            }
            if (left == right) {
                this.removeAll();
                return;
            }
            JComponent comp = left == null ? right : left;
            wrapper.remove(comp);
            if (wrapper instanceof DockingSplitPane) {
                ((DockingSplitPane)wrapper).cleanup();
            }
            super.remove(wrapper);
            if (comp instanceof DockingPort) {
                comp = ((DockingPort)comp).getDockedComponent();
            }
            if (comp != null) {
                this.setDockedComponent(comp);
            }
        }
    }

    private void reevaluateTabbedPane() {
        Container parent;
        Container grandParent;
        int minTabs;
        JComponent docked = this.getDockedComponent();
        if (!(docked instanceof JTabbedPane)) {
            return;
        }
        JTabbedPane tabs = (JTabbedPane)docked;
        int tabCount = tabs.getTabCount();
        int n = minTabs = this.isSingleTabAllowed() ? 0 : 1;
        if (tabCount > minTabs) {
            return;
        }
        JComponent comp = tabCount == 1 ? (JComponent)tabs.getComponentAt(0) : null;
        this.removeAll();
        if (comp != null) {
            comp.setVisible(true);
            this.setDockedComponent(comp);
        }
        Container container = grandParent = (parent = this.getParent()) == null ? null : parent.getParent();
        if (comp == null && parent instanceof JSplitPane && grandParent instanceof DockingPort) {
            parent.remove(this);
            ((DockingPort)grandParent).reevaluateContainerTree();
        }
    }

    private void reconstruct(PerspectiveModel.DockingPortNode node) {
        DockingPort port = (DockingPort)node.getDockingPort();
        if (node.isSplit()) {
            PerspectiveModel.SplitNode child = (PerspectiveModel.SplitNode)node.getChildAt(0);
            JSplitPane split = child.getSplitPane();
            port.setDockedComponent(split);
            port.evaluateDockingBorderStatus();
            return;
        }
        Enumeration<TreeNode> en = node.children();
        while (en.hasMoreElements()) {
            ILayoutNode child = (ILayoutNode)en.nextElement();
            if (!(child instanceof PerspectiveModel.DockableNode)) continue;
            IDockable dockable = ((PerspectiveModel.DockableNode)child).getDockable();
            port.dock(dockable, DockingManager.getPerspectiveManager().getCurrentPerspective(), "CENTER");
        }
    }

    private void reconstruct(PerspectiveModel.SplitNode node) {
        JSplitPane split = node.getSplitPane();
        Component left = node.getLeftComponent();
        Component right = node.getRightComponent();
        split.setLeftComponent(left);
        split.setRightComponent(right);
    }

    private void deferSplitPaneValidation(final ArrayList<PerspectiveModel.SplitNode> splitNodes) {
        int size;
        if (splitNodes.size() == 0) {
            return;
        }
        PerspectiveModel.SplitNode node = splitNodes.get(0);
        JSplitPane split = node.getSplitPane();
        int n = size = split.getOrientation() == 1 ? split.getWidth() : split.getHeight();
        if (!split.isValid() || !split.isVisible() || size == 0) {
            split.addPropertyChangeListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    if ("dividerLocation".equals(evt.getPropertyName())) {
                        JSplitPane split = (JSplitPane)evt.getSource();
                        split.removePropertyChangeListener(this);
                        DockingPort.this.processImportedSplitPaneValidation(splitNodes);
                    }
                }
            });
        } else {
            this.processImportedSplitPaneValidation(splitNodes);
        }
    }

    private void processImportedSplitPaneValidation(ArrayList<PerspectiveModel.SplitNode> splitNodes) {
        int i = 0;
        while (i < splitNodes.size()) {
            PerspectiveModel.SplitNode node = splitNodes.get(i);
            JSplitPane splitPane = node.getSplitPane();
            splitPane.setDividerLocation(DockingUtility.calcDividerLocation(splitPane, node.getSplitRatio()));
            IDockingPort port = DockingUtility.getParentDockingPort(splitPane);
            if (port instanceof DockingPort) {
                ((DockingPort)port).evaluateDockingBorderStatus();
            }
            splitPane.validate();
            ++i;
        }
    }

    private int getTabIndex(JTabbedPane tabs, Component comp) {
        int tabCount = tabs.getTabCount();
        int i = 0;
        while (i < tabCount) {
            if (tabs.getComponentAt(i) == comp) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    @Override
    protected String paramString() {
        return "id=" + this.getID() + "," + super.paramString();
    }

    private static class DockablePropertyChangeHandler
    implements PropertyChangeListener {
        private DockablePropertyChangeHandler() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            Object src = evt.getSource();
            if (src instanceof IDockable) {
                IDockable dockable = (IDockable)src;
                String name = evt.getPropertyName();
                if ("tabIcon".equals(name) || "tabText".equals(name)) {
                    IDockingPort dockingPort = dockable.getDockingPort();
                    if (dockingPort instanceof DockingPort) {
                        ((DockingPort)dockingPort).updateTab(dockable);
                    }
                } else if ("active".equals(name) && ((Boolean)evt.getNewValue()).booleanValue() && ActiveDockableTracker.getInstance().getActiveDockable() != dockable) {
                    ActiveDockableTracker.requestDockableActivation(dockable.getComponent(), true);
                }
            }
        }
    }

    private static class MaximizationInstallInfo {
        private final JComponent content;
        private final Border border;

        public MaximizationInstallInfo(JComponent content, Border border) {
            this.content = content;
            this.border = border;
        }

        public Border getBorder() {
            return this.border;
        }

        public JComponent getContent() {
            return this.content;
        }
    }

    private static class MaximizationReleaseInfo
    extends MaximizationInstallInfo {
        private int tabIndex;

        public MaximizationReleaseInfo(JComponent content, Border border) {
            super(content, border);
        }

        public int getTabIndex() {
            return this.tabIndex;
        }

        public void setTabIndex(int tabIndex) {
            this.tabIndex = tabIndex;
        }
    }

    protected class PortLayout
    implements LayoutManager2,
    Serializable {
        private static final long serialVersionUID = 7776573881944632196L;

        protected PortLayout() {
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            Insets i = DockingPort.this.getInsets();
            Dimension dd = DockingPort.this.getDockedComponent() != null ? DockingPort.this.getDockedComponent().getPreferredSize() : parent.getSize();
            return new Dimension(dd.width + i.left + i.right, dd.height + i.top + i.bottom);
        }

        @Override
        public Dimension minimumLayoutSize(Container parent) {
            Insets i = DockingPort.this.getInsets();
            Dimension dd = DockingPort.this.getDockedComponent() != null ? DockingPort.this.getDockedComponent().getMinimumSize() : new Dimension(0, 0);
            return new Dimension(dd.width + i.left + i.right, dd.height + i.top + i.bottom);
        }

        @Override
        public Dimension maximumLayoutSize(Container target) {
            Insets i = DockingPort.this.getInsets();
            Dimension dd = DockingPort.this.getDockedComponent() != null ? DockingPort.this.getDockedComponent().getMaximumSize() : new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE - i.top - i.bottom);
            return new Dimension(dd.width + i.left + i.right, dd.height + i.top + i.bottom);
        }

        @Override
        public void layoutContainer(Container parent) {
            Rectangle b = DockingPort.this.getBounds();
            Insets i = DockingPort.this.getInsets();
            int w = b.width - i.right - i.left;
            int h = b.height - i.top - i.bottom;
            if (DockingPort.this.getDockedComponent() != null) {
                DockingPort.this.getDockedComponent().setBounds(i.left, i.top, w, h);
            }
        }

        @Override
        public void addLayoutComponent(String name, Component comp) {
        }

        @Override
        public void removeLayoutComponent(Component comp) {
        }

        @Override
        public void addLayoutComponent(Component comp, Object constraints) {
        }

        @Override
        public float getLayoutAlignmentX(Container target) {
            return 0.0f;
        }

        @Override
        public float getLayoutAlignmentY(Container target) {
            return 0.0f;
        }

        @Override
        public void invalidateLayout(Container target) {
        }
    }
}

