/*
 * Decompiled with CFR 0.152.
 */
package de.javasoft.docking.controls;

import de.javasoft.docking.controls.Dockbar;
import de.javasoft.docking.controls.DockbarManager;
import de.javasoft.docking.controls.DockingManager;
import de.javasoft.docking.controls.DockingPort;
import de.javasoft.docking.controls.DockingPortTracker;
import de.javasoft.docking.controls.DockingUtility;
import de.javasoft.docking.controls.IDockable;
import de.javasoft.docking.controls.IDockingConstants;
import de.javasoft.docking.controls.IDockingPort;
import de.javasoft.docking.controls.Perspective;
import de.javasoft.docking.controls.PerspectiveModel;
import de.javasoft.tabpane.JYTabbedPane;
import java.awt.Component;
import java.awt.Container;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;

public class DockingPath
implements Cloneable,
IDockingConstants,
Serializable {
    private static final long serialVersionUID = 9019675117741910838L;
    private transient String stringForm;
    private String rootPortID;
    private ArrayList<PerspectiveModel.SplitNode> nodes;
    private String siblingID;
    private boolean tabbed;

    public DockingPath() {
        this.nodes = new ArrayList();
    }

    public static DockingPath create(String dockableID) {
        IDockable dockable = DockingPath.findDockable(dockableID);
        return DockingPath.create(dockable);
    }

    static DockingPath create(IDockable dockable) {
        if (dockable == null || !DockingPath.isDocked(dockable)) {
            return null;
        }
        DockingPath path = new DockingPath(dockable);
        JComponent comp = dockable.getComponent();
        Container parent = comp.getParent();
        while (!DockingPath.isDockingRoot(parent)) {
            if (parent instanceof IDockingPort) {
                PerspectiveModel.SplitNode node = DockingPath.createNode((IDockingPort)((Object)parent));
                path.addNode(node);
            }
            parent = parent.getParent();
        }
        if (DockingPath.isDockingRoot(parent)) {
            path.setRootPortId(((IDockingPort)((Object)parent)).getID());
        }
        path.initialize();
        return path;
    }

    static PerspectiveModel.SplitNode createNode(IDockable dockable) {
        Container parent = dockable.getComponent().getParent();
        return parent instanceof IDockingPort ? DockingPath.createNode((IDockingPort)((Object)parent)) : null;
    }

    static PerspectiveModel.SplitNode createNode(IDockingPort port) {
        Container c = port.getComponent().getParent();
        return c instanceof JSplitPane ? DockingPath.createNode(port, (JSplitPane)c) : null;
    }

    private static PerspectiveModel.SplitNode createNode(IDockingPort port, JSplitPane split) {
        int orientation = split.getOrientation();
        boolean topLeft = split.getLeftComponent() == port;
        int region = 0;
        String siblingId = null;
        if (topLeft) {
            region = orientation == 0 ? 1 : 2;
            siblingId = DockingPath.getSiblingID(split.getRightComponent());
        } else {
            region = orientation == 0 ? 3 : 4;
            siblingId = DockingPath.getSiblingID(split.getLeftComponent());
        }
        return new PerspectiveModel.SplitNode(orientation, region, DockingUtility.calcSplitRatio(split), siblingId);
    }

    private static String getSiblingID(Component c) {
        IDockable dockable;
        if (c instanceof IDockingPort) {
            c = ((IDockingPort)((Object)c)).getDockedComponent();
        }
        return (dockable = DockingPath.findDockable(c)) == null ? null : dockable.getID();
    }

    private static boolean isDockingRoot(Container c) {
        return c instanceof IDockingPort && ((IDockingPort)((Object)c)).isRoot();
    }

    private DockingPath(IDockable dockable) {
        this.siblingID = this.findSiblingID(dockable);
        this.tabbed = dockable.getComponent().getParent() instanceof JTabbedPane || dockable.getComponent().getParent().getParent() instanceof JYTabbedPane;
        this.nodes = new ArrayList();
    }

    String getSiblingID() {
        return this.siblingID;
    }

    void setSiblingId(String siblingID) {
        this.siblingID = siblingID;
    }

    private DockingPath(String parentID, boolean tabs, ArrayList<PerspectiveModel.SplitNode> nodeList) {
        this.siblingID = parentID;
        this.tabbed = tabs;
        this.nodes = nodeList;
    }

    List<PerspectiveModel.SplitNode> getNodes() {
        return this.nodes;
    }

    IDockingPort getRootDockingPort() {
        return DockingPortTracker.getRootDockingPort(this.rootPortID);
    }

    String getRootPortId() {
        return this.rootPortID;
    }

    void setRootPortId(String portId) {
        this.rootPortID = portId;
    }

    private void addNode(PerspectiveModel.SplitNode node) {
        this.nodes.add(node);
    }

    private void initialize() {
        Collections.reverse(this.nodes);
    }

    private String findSiblingID(IDockable dockable) {
        IDockable d;
        JSplitPane split;
        JComponent comp = dockable.getComponent();
        JSplitPane jSplitPane = split = comp.getParent() instanceof JSplitPane ? (JSplitPane)comp.getParent() : null;
        if (split == null) {
            return null;
        }
        Component sibling = split.getLeftComponent();
        if (comp == sibling) {
            sibling = split.getRightComponent();
        }
        return (d = DockingPath.findDockable(sibling)) == null ? null : d.getID();
    }

    public boolean restore(String id, Perspective perspective) {
        return this.restore(DockingManager.getDockable(id), perspective);
    }

    public boolean restore(IDockable dockable, Perspective perspective) {
        if (DockingPath.isDocked(dockable)) {
            return false;
        }
        IDockingPort rootPort = this.getRootDockingPort();
        if (rootPort == null) {
            rootPort = DockingPortTracker.getRootDockingPort(DockingUtility.getActiveWindow());
        }
        String region = "CENTER";
        IDockingPort port = rootPort;
        for (PerspectiveModel.SplitNode node : this.nodes) {
            JSplitPane splitPane;
            Component comp = port.getDockedComponent();
            region = this.getRegion(node, comp);
            JSplitPane jSplitPane = splitPane = comp instanceof JSplitPane ? (JSplitPane)comp : null;
            if (splitPane == null || splitPane.getOrientation() != node.getOrientation()) {
                boolean success = this.dockBrokenPath(dockable, port, perspective, region, node);
                if (!success) break;
                return success;
            }
            comp = node.getRegion() == 2 || node.getRegion() == 1 ? splitPane.getLeftComponent() : splitPane.getRightComponent();
            port = (IDockingPort)((Object)comp);
        }
        return this.dockFullPath(dockable, port, perspective, region);
    }

    private boolean dockBrokenPath(IDockable dockable, IDockingPort port, Perspective perspective, String region, PerspectiveModel.SplitNode ctrlNode) {
        PerspectiveModel.SplitNode lastNode;
        JComponent current = port.getDockedComponent();
        if (current instanceof JSplitPane) {
            return this.dockExtendedPath(dockable, port, perspective, region, ctrlNode);
        }
        if (current instanceof JTabbedPane) {
            return this.dock(dockable, port, perspective, "CENTER", null);
        }
        IDockable embedded = DockingPath.findDockable(current);
        if (embedded == null || this.tabbed) {
            return this.dock(dockable, port, perspective, "CENTER", null);
        }
        String embedId = embedded.getID();
        if (embedId.equals((lastNode = this.getLastNode()).getSiblingId())) {
            region = this.getRegion(lastNode, current);
            ctrlNode = lastNode;
        }
        return this.dock(dockable, port, perspective, region, ctrlNode);
    }

    private boolean dockFullPath(IDockable dockable, IDockingPort port, Perspective perspective, String region) {
        JComponent current = port.getDockedComponent();
        if (current instanceof JTabbedPane) {
            return this.dock(dockable, port, perspective, "CENTER", null);
        }
        IDockable docked = DockingPath.findDockable(current);
        if (docked != null) {
            JComponent comp = dockable.getComponent();
            if (port.isDockingAllowed(comp, "CENTER")) {
                return this.dock(dockable, port, perspective, "CENTER", null);
            }
            IDockingPort superPort = (IDockingPort)((Object)SwingUtilities.getAncestorOfClass(IDockingPort.class, port.getComponent()));
            if (superPort != null) {
                port = superPort;
            }
            return this.dock(dockable, port, perspective, region, this.getLastNode());
        }
        return this.dockExtendedPath(dockable, port, perspective, region, this.getLastNode());
    }

    private boolean dockExtendedPath(IDockable dockable, IDockingPort port, Perspective perspective, String region, PerspectiveModel.SplitNode splitNode) {
        String lastSiblingId;
        JComponent docked = port.getDockedComponent();
        if (docked != null && !(docked instanceof JSplitPane)) {
            throw new RuntimeException("Illegal docked: " + docked);
        }
        PerspectiveModel.SplitNode lastNode = this.getLastNode();
        String string = lastSiblingId = lastNode == null ? null : lastNode.getSiblingId();
        if (lastSiblingId != null) {
            for (IDockable d : port.getDockables()) {
                if (!d.getID().equals(lastSiblingId)) continue;
                IDockingPort embedPort = d.getDockingPort();
                String embedRegion = this.getRegion(lastNode, d.getComponent());
                return this.dock(dockable, embedPort, perspective, embedRegion, splitNode);
            }
        }
        return this.dock(dockable, port, perspective, region, splitNode);
    }

    private String getRegion(PerspectiveModel.SplitNode node, Component dockedComponent) {
        if (dockedComponent == null) {
            return "CENTER";
        }
        return DockingUtility.getRegion(node.getRegion());
    }

    PerspectiveModel.SplitNode getLastNode() {
        return this.nodes.size() == 0 ? null : this.nodes.get(this.nodes.size() - 1);
    }

    private boolean dock(IDockable dockable, IDockingPort port, Perspective perspective, String region, PerspectiveModel.SplitNode splitNode) {
        boolean ret = DockingManager.dock(dockable, port, perspective, region);
        if (this.tabbed || splitNode == null) {
            return ret;
        }
        this.resizeSplitPane(dockable, splitNode.getSplitRatio());
        return ret;
    }

    private void resizeSplitPane(IDockable dockable, float splitRatio) {
        Dockbar dockbar;
        Container grandParent;
        Container parent = dockable.getComponent().getParent();
        Container container = grandParent = parent == null ? null : parent.getParent();
        if (!(grandParent instanceof JSplitPane)) {
            return;
        }
        JSplitPane split = (JSplitPane)grandParent;
        int orientation = split.getOrientation();
        int parentSize = orientation == 0 ? split.getParent().getHeight() : split.getParent().getWidth();
        DockbarManager mgr = DockbarManager.getCurrent(dockable);
        Dockbar dockbar2 = dockbar = mgr == null ? null : mgr.getDockbar(dockable);
        if (dockbar != null && dockbar.getComponentCount() == 2) {
            parentSize += dockbar.getPlacement() == 3 ? dockbar.getHeight() : dockbar.getWidth();
        }
        this.validateSplitDividerLocation(split, parentSize, splitRatio);
    }

    private void validateSplitDividerLocation(JSplitPane splitPane, int parentSize, float splitRatio) {
        JSplitPane splitChild;
        int location = splitPane.getDividerLocation();
        int divSize = splitPane.getDividerSize();
        if (location > parentSize || splitRatio < 0.0f) {
            splitRatio = (float)location / (float)(splitPane.getOrientation() == 0 ? splitPane.getHeight() : splitPane.getWidth());
        }
        float minLocation = splitPane.getOrientation() == 0 ? splitPane.getRightComponent().getMinimumSize().height : splitPane.getRightComponent().getMinimumSize().width;
        float maxRatio = 1.0f - minLocation / (float)(parentSize - divSize);
        splitRatio = Math.min(splitRatio, maxRatio);
        float maxLocation = splitPane.getOrientation() == 0 ? splitPane.getLeftComponent().getMinimumSize().height : splitPane.getLeftComponent().getMinimumSize().width;
        float minRatio = maxLocation / (float)(parentSize - divSize);
        splitRatio = Math.max(splitRatio, minRatio);
        splitPane.setDividerLocation((int)((float)(parentSize - divSize) * splitRatio));
        if (splitPane.getLeftComponent() instanceof DockingPort && ((DockingPort)splitPane.getLeftComponent()).getDockedComponent() instanceof JSplitPane) {
            splitChild = (JSplitPane)((DockingPort)splitPane.getLeftComponent()).getDockedComponent();
            if (splitPane.getOrientation() == splitChild.getOrientation()) {
                this.validateSplitDividerLocation(splitChild, (int)((float)(parentSize - divSize) * splitRatio), -1.0f);
            }
        }
        if (splitPane.getRightComponent() instanceof DockingPort && ((DockingPort)splitPane.getRightComponent()).getDockedComponent() instanceof JSplitPane) {
            splitChild = (JSplitPane)((DockingPort)splitPane.getRightComponent()).getDockedComponent();
            if (splitPane.getOrientation() == splitChild.getOrientation()) {
                this.validateSplitDividerLocation(splitChild, (int)((float)(parentSize - divSize) * (1.0f - splitRatio)), -1.0f);
            }
        }
    }

    private static IDockable findDockable(Component c) {
        return DockingManager.getDockable(c);
    }

    private static IDockable findDockable(String id) {
        return DockingManager.getDockable(id);
    }

    private static boolean isDocked(IDockable dockable) {
        return DockingManager.isDocked(dockable);
    }

    public int getDepth() {
        return this.nodes.size();
    }

    PerspectiveModel.SplitNode getNode(int indx) {
        return indx < 0 || indx >= this.getDepth() ? null : this.nodes.get(indx);
    }

    public String toString() {
        if (this.stringForm == null) {
            StringBuffer sb = new StringBuffer("/RootPort[id=").append(this.rootPortID).append("]");
            for (PerspectiveModel.SplitNode node : this.nodes) {
                sb.append("/").append(node.toString());
            }
            sb.append("/Dockable");
            this.stringForm = sb.toString();
        }
        return this.stringForm;
    }

    public Object clone() {
        ArrayList<PerspectiveModel.SplitNode> nodeList = null;
        if (this.nodes != null) {
            nodeList = new ArrayList<PerspectiveModel.SplitNode>(this.nodes.size());
            for (PerspectiveModel.SplitNode node : this.nodes) {
                nodeList.add((PerspectiveModel.SplitNode)node.clone());
            }
        }
        DockingPath path = new DockingPath(this.siblingID, this.tabbed, nodeList);
        path.rootPortID = this.rootPortID;
        return path;
    }
}

