/*
 * Decompiled with CFR 0.152.
 */
package de.javasoft.docking.controls;

import de.javasoft.docking.controls.ActiveDockableTracker;
import de.javasoft.docking.controls.DockableComponentWrapper;
import de.javasoft.docking.controls.Dockbar;
import de.javasoft.docking.controls.DockbarManager;
import de.javasoft.docking.controls.DockingEvent;
import de.javasoft.docking.controls.DockingPath;
import de.javasoft.docking.controls.DockingPortTracker;
import de.javasoft.docking.controls.DockingState;
import de.javasoft.docking.controls.DockingStrategy;
import de.javasoft.docking.controls.DockingStrategyClassMapping;
import de.javasoft.docking.controls.DockingUtility;
import de.javasoft.docking.controls.DragManager;
import de.javasoft.docking.controls.FloatPolicyManager;
import de.javasoft.docking.controls.FloatingDialog;
import de.javasoft.docking.controls.FloatingFrame;
import de.javasoft.docking.controls.FloatingGroup;
import de.javasoft.docking.controls.IDockable;
import de.javasoft.docking.controls.IDockableFactory;
import de.javasoft.docking.controls.IDockingConstants;
import de.javasoft.docking.controls.IDockingEventListener;
import de.javasoft.docking.controls.IDockingPort;
import de.javasoft.docking.controls.IDockingStrategy;
import de.javasoft.docking.controls.IFloatingDockingPort;
import de.javasoft.docking.controls.IMaximizationManager;
import de.javasoft.docking.controls.IMinimizationManager;
import de.javasoft.docking.controls.IPerspectiveManager;
import de.javasoft.docking.controls.MaximizationManager;
import de.javasoft.docking.controls.MinimizationManager;
import de.javasoft.docking.controls.Perspective;
import de.javasoft.docking.controls.PerspectiveManager;
import de.javasoft.docking.controls.RegionChecker;
import de.javasoft.docking.controls.RestorationManager;
import de.javasoft.docking.controls.RootWindow;
import de.javasoft.plaf.synthetica.SyntheticaLookAndFeel;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.EventListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;

public class DockingManager
implements IDockingConstants {
    private static final DockingManager INSTANCE = new DockingManager();
    private static final HashMap<String, IDockable> DOCKABLES_BY_ID = new HashMap();
    private static final WeakHashMap<JComponent, IDockable> DOCKABLES_BY_COMPONENT = new WeakHashMap();
    private static final DockingStrategyClassMapping DOCKING_STRATEGIES = new DockingStrategyClassMapping(DockingStrategy.class, new DockingStrategy());
    private static final WeakHashMap<IDockingPort, MaximizedState> maximizedStatesByRootPort = new WeakHashMap();
    private static final Logger LOG = Logger.getLogger(DockingManager.class.getName());
    private IDockableFactory dockableFactory;
    private IMinimizationManager minimizeManager;
    private IMaximizationManager maximizeManager;
    private AutoPersist autoPersister = new AutoPersist();
    private float defaultSiblingSize;
    private static boolean tabReorderEnabled;
    private static FloatingMode floatingMode;

    static {
        floatingMode = FloatingMode.MIN_MAX_OWNER;
        DockingManager.init();
    }

    private DockingManager() {
    }

    private static DockingManager getInstance() {
        return INSTANCE;
    }

    private static void init() {
        DragManager.prime();
        tabReorderEnabled = true;
        DockingManager.setMaximizeManager(MaximizationManager.class.getName());
        DockingManager.setMinimizeManager(MinimizationManager.class.getName());
        ActiveDockableTracker.getInstance();
        float siblingSize = 0.5f;
        String siblingSize_ = System.getProperty("docking.defaultSiblingSize");
        if (siblingSize_ != null) {
            siblingSize = Float.parseFloat(siblingSize_);
        }
        DockingManager.setDefaultSiblingSize(siblingSize);
        Runtime.getRuntime().addShutdownHook(DockingManager.getInstance().autoPersister);
    }

    public static IDockable registerDockableComponent(JComponent c) {
        if (c instanceof IDockable) {
            return DockingManager.registerDockable((IDockable)((Object)c));
        }
        return DockingManager.registerDockableComponent(c, null);
    }

    public static void clear() {
        DockingManager.removeAll();
        for (String id : DockingManager.getDockableIDs()) {
            DockingManager.undock(DockingManager.getDockable(id));
        }
        IPerspectiveManager pm = DockingManager.getPerspectiveManager();
        for (Perspective p : pm.getPerspectives()) {
            pm.removePerspective(p);
        }
        PerspectiveManager.setCurrentPerspectiveID(null, true);
        for (String id : DockingManager.getDockableIDs()) {
            DockingManager.unregisterDockable(DockingManager.getDockable(id));
        }
    }

    private static void removeAll() {
        Frame[] frameArray = JFrame.getFrames();
        int n = frameArray.length;
        int n2 = 0;
        while (n2 < n) {
            Frame frame = frameArray[n2];
            if (frame instanceof JFrame) {
                JFrame f = (JFrame)frame;
                IDockingPort rootPort = DockingManager.getRootDockingPort(f);
                if (rootPort != null) {
                    rootPort.getComponent().getParent().remove(rootPort.getComponent());
                }
                ArrayList list = new ArrayList();
                SyntheticaLookAndFeel.findComponents(Dockbar.class, (Container)f, list);
                for (Dockbar bar : list) {
                    Container container = bar.getParent().getParent();
                    container.remove(bar.getParent());
                }
            }
            ++n2;
        }
    }

    public static IDockable registerDockableComponent(JComponent c, String tabText) {
        return DockingManager.registerDockableComponent(c, tabText, null);
    }

    private static IDockable registerDockableComponent(JComponent c, String tabText, String dockingId) {
        IDockable dockable;
        if (tabText == null) {
            tabText = DockingManager.determineTabText(c, dockingId);
        }
        if ((dockable = DockingManager.getDockable(c)) == null) {
            String persistentId = dockingId == null ? DockingManager.generatePersistentId(c, null) : dockingId;
            dockable = new DockableComponentWrapper(c, persistentId, tabText, true);
            if (tabText != null) {
                dockable.setTabText(tabText);
            }
        }
        return DockingManager.registerDockable(dockable);
    }

    private static String generatePersistentId(Object obj, String desiredId) {
        String pId = desiredId == null ? obj.getClass().getName() : desiredId;
        StringBuffer baseId = new StringBuffer(pId);
        int i = 1;
        while (DockingManager.hasRegisteredDockableId(pId)) {
            baseId.append("_").append(i);
            pId = baseId.toString();
            ++i;
        }
        return pId;
    }

    public static void unregisterDockableComponent(JComponent c) {
        IDockable dockable = DockingManager.getDockable(c);
        DockingManager.unregisterDockable(dockable);
    }

    public static IDockable registerDockable(IDockable dockable) {
        if (dockable.getComponent() == null || dockable.getDragSources() == null) {
            throw new IllegalArgumentException("Dockable is invalid.");
        }
        if (dockable.getID() == null) {
            throw new IllegalArgumentException("Dockable must have a non-null ID.");
        }
        DOCKABLES_BY_COMPONENT.put(dockable.getComponent(), dockable);
        dockable.getComponent().putClientProperty(DockingUtility.DOCKABLE_INDICATOR, true);
        dockable.getComponent().getInputMap(2).put(KeyStroke.getKeyStroke(27, 0), "CancelDockingDragOperation");
        dockable.getComponent().getActionMap().put("CancelDockingDragOperation", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                if (DragManager.getCurrentDragOperation() != null) {
                    DragManager.cancelCurrentDragOperation();
                }
            }
        });
        DockingManager.updateDragListeners(dockable);
        dockable.addDockingListener(dockable);
        dockable.addDockingListener(PerspectiveManager.getDockingStateListener());
        dockable.addDockingListener(FloatPolicyManager.getInstance());
        DOCKABLES_BY_ID.put(dockable.getID(), dockable);
        DockingManager.dispatchEvent(new DockingEvent(dockable, 0));
        return dockable;
    }

    public static void unregisterDockable(IDockable dockable) {
        DOCKABLES_BY_COMPONENT.remove(dockable.getComponent());
        DockingManager.removeDragListeners(dockable);
        dockable.removeDockingListener(dockable);
        dockable.removeDockingListener(PerspectiveManager.getDockingStateListener());
        dockable.removeDockingListener(FloatPolicyManager.getInstance());
        for (Perspective p : PerspectiveManager.getInstance().getPerspectives()) {
            p.getModel().remove(dockable.getID());
        }
        DOCKABLES_BY_ID.remove(dockable.getID());
        DockingManager.dispatchEvent(new DockingEvent(dockable, 1));
    }

    public static void unregisterDockable(String id) {
        DockingManager.unregisterDockable(DockingManager.getDockable(id));
    }

    public static void removePerspective(String id) {
        IPerspectiveManager pm = DockingManager.getPerspectiveManager();
        pm.removePerspective(pm.getPerspective(id));
    }

    public static void setDockableFactory(IDockableFactory factory) {
        DockingManager.INSTANCE.dockableFactory = factory;
    }

    public static IDockableFactory getDockableFactory() {
        return DockingManager.INSTANCE.dockableFactory;
    }

    public static void close(IDockable dockable) {
        DockingManager.close(dockable, false);
    }

    public static void close(IDockable dockable, boolean unregister) {
        DockingManager.close(dockable, DockingManager.getPerspective(dockable), unregister);
    }

    static void close(IDockable dockable, Perspective perspective, boolean unregister) {
        if (DockingManager.isMaximized(dockable)) {
            DockingManager.toggleMaximized(dockable, perspective);
        }
        if (DockingManager.isDocked(dockable)) {
            DockingManager.undock(dockable);
        } else if (DockingManager.isMinimized(dockable, perspective)) {
            DockingManager.getMinimizeManager().close(dockable);
        }
        DockingManager.removeFromFloatingGroup(dockable);
        if (unregister || SyntheticaLookAndFeel.getBoolean((String)"JYDocking.unregisterOnClose", (Component)dockable.getComponent(), (boolean)false)) {
            DockingManager.unregisterDockable(dockable);
        }
    }

    public static boolean dockComponent(JComponent c, IDockingPort port) {
        return DockingManager.dockComponent(c, port, "CENTER");
    }

    public static boolean dockComponent(JComponent c, IDockingPort port, String region) {
        IDockable d = DockingManager.resolveDockableComponent(c);
        IDockingStrategy strategy = DockingManager.getDockingStrategy(port);
        if (strategy != null) {
            return strategy.dock(d, port, DockingManager.getPerspectiveManager().getCurrentPerspective(), region);
        }
        return false;
    }

    public static boolean dockComponent(JComponent c, JComponent parent) {
        return DockingManager.dockComponent(c, parent, null, -1.0f);
    }

    public static boolean dockComponent(JComponent c, JComponent parent, String region) {
        return DockingManager.dockComponent(c, parent, region, 0.5f);
    }

    public static boolean dockComponent(JComponent c, JComponent parent, String region, float proportion) {
        return DockingManager.dockComponent(c, parent, DockingManager.getPerspectiveManager().getCurrentPerspective(), region, proportion);
    }

    static boolean dockComponent(JComponent c, JComponent parent, Perspective perspective, String region, float proportion) {
        return DockingManager.dock(DockingManager.resolveDockableComponent(c), DockingManager.resolveDockableComponent(parent), perspective, region, proportion);
    }

    public static boolean undockComponent(JComponent c) {
        return DockingManager.undock(DockingManager.getDockable(c));
    }

    private static IDockable resolveDockableComponent(JComponent c) {
        IDockable d = DockingManager.getDockable(c);
        return d == null ? DockingManager.registerDockableComponent(c) : d;
    }

    public static boolean dock(IDockable dockable, IDockingPort port, String region) {
        return DockingManager.dock(dockable, port, DockingManager.getPerspectiveManager().getCurrentPerspective(), region);
    }

    static boolean dock(IDockable dockable, IDockingPort port, Perspective perspective, String region) {
        IDockingStrategy strategy;
        IDockingPort rootPort = DockingManager.getRootDockingPort(dockable.getComponent());
        IDockable maximizedDockable = DockingManager.getMaximizedDockable(rootPort);
        if (maximizedDockable != null) {
            DockingManager.toggleMaximized(maximizedDockable, perspective);
        }
        if ((strategy = DockingManager.getDockingStrategy(port)) != null) {
            return strategy.dock(dockable, port, perspective, region);
        }
        return false;
    }

    public static boolean dock(IDockable dockable, IDockable parent, String region) {
        return DockingManager.dock(dockable, parent, region, 0.5f);
    }

    public static boolean dock(IDockable dockable, IDockable parent, String region, float proportion) {
        return DockingManager.dock(dockable, parent, DockingManager.getPerspectiveManager().getCurrentPerspective(), region, proportion);
    }

    static boolean dock(IDockable dockable, IDockable parent, Perspective perspective, String region, float proportion) {
        return DockingManager.dockRelative(dockable, parent, perspective, region, proportion);
    }

    static boolean dockRelative(IDockable dockable, IDockable parent, Perspective perspective, String relativeRegion) {
        return DockingManager.dockRelative(parent, dockable, perspective, relativeRegion, -1.0f);
    }

    static boolean dockRelative(final IDockable dockable, final IDockable parent, final Perspective perspective, String relativeRegion, float ratio) {
        IDockingPort port;
        IDockable d;
        IDockable maxDockable;
        if (parent == null || dockable == null || !DockingManager.isValidDockingRegion(relativeRegion)) {
            return false;
        }
        IDockingPort rootPort = DockingPortTracker.getRootDockingPort(parent.getComponent());
        if (rootPort == null && perspective.getDockingState(parent.getID(), false) != null) {
            rootPort = perspective.getDockingState(parent.getID(), false).getPath().getRootDockingPort();
        }
        if ((maxDockable = DockingManager.getMaximizedDockable(rootPort)) != null) {
            DockingManager.toggleMaximized(maxDockable, perspective);
            SwingUtilities.invokeLater(() -> DockingManager.updateRestorationLayout(maxDockable, perspective));
        }
        if (parent.getComponent() instanceof IDockable && DockingManager.isMinimized(d = (IDockable)((Object)parent.getComponent()))) {
            DockingManager.setMinimized(d, perspective, false);
        }
        if (DockingManager.isFloating(parent)) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    DockingState state = perspective.getModel().getDockingState(dockable, false);
                    if (state.getPath() == null) {
                        DockingState parentState = perspective.getModel().getDockingState(parent, false);
                        state.setPath((DockingPath)parentState.getPath().clone());
                        state.setFloatingRestorePath((DockingPath)parentState.getFloatingRestorePath().clone());
                        state.setFloatingGroupID(parentState.getFloatingGroupID());
                        DockingManager.addToFloatingGroup(dockable, parentState.getFloatingGroupID());
                    }
                }
            });
        }
        if (ratio == -1.0f) {
            ratio = 0.5f;
        }
        if (relativeRegion == null) {
            relativeRegion = "CENTER";
        }
        if (ratio != -1.0f && !"CENTER".equals(relativeRegion) && DockingManager.isValidDockingRegion(relativeRegion)) {
            parent.setSiblingSize(relativeRegion, RegionChecker.validateSiblingSize(ratio));
        }
        if ((port = parent.getDockingPort()) != null) {
            return DockingManager.dock(dockable, port, perspective, relativeRegion);
        }
        return false;
    }

    public static boolean undock(String dockableID) {
        return DockingManager.undock(DockingManager.getDockable(dockableID));
    }

    public static boolean undock(IDockable dockable) {
        if (dockable == null) {
            return false;
        }
        IDockingStrategy strategy = DockingManager.findDockingStrategy(dockable);
        if (strategy != null) {
            return strategy.undock(dockable);
        }
        return false;
    }

    public static void setMinimized(IDockable dockable, boolean minimize) {
        DockingManager.setMinimized(dockable, DockingManager.getPerspective(dockable), minimize);
    }

    static void setMinimized(IDockable dockable, Perspective perspective, boolean minimize) {
        DockingManager.setMinimized(dockable, perspective, minimize, -1);
    }

    public static void setMinimized(IDockable dockable, boolean minimize, int placement) {
        DockingManager.setMinimized(dockable, DockingManager.getPerspective(dockable), minimize, placement);
    }

    static void setMinimized(IDockable dockable, Perspective perspective, boolean minimize, int placement) {
        Window w = DockingManager.getWindow(dockable);
        DockingManager.setMinimized(dockable, perspective, minimize, w, placement);
    }

    static void setMinimized(IDockable dockable, Perspective perspective, boolean minimize, Window w, int placement) {
        DockingManager.setMinimized(dockable, perspective, minimize, w, placement, true);
    }

    static void setMinimized(IDockable dockable, Perspective perspective, boolean minimize, Window w, int placement, boolean modifyState) {
        Component oldFocusOwner;
        Window w_ = SwingUtilities.getWindowAncestor(dockable.getComponent());
        Component component = oldFocusOwner = w_ == null ? null : w_.getFocusOwner();
        if (modifyState) {
            if (DockingManager.getMaximizedDockable(DockingManager.getRootDockingPort(dockable.getComponent())) != null) {
                DockingManager.setMaximized(DockingManager.getMaximizedDockable(DockingManager.getRootDockingPort(dockable.getComponent())), perspective, false);
            } else if (DockingManager.isFloating(dockable) && DockingManager.getMinimizeManager().getWindow(dockable.getComponent()) != w) {
                DockingManager.setFloating(dockable, perspective, false, null);
            }
        }
        if (w == null) {
            w = DockingUtility.getActiveWindow();
        }
        DockingManager.getMinimizeManager().setMinimized(dockable, perspective, minimize, w, placement);
        ActiveDockableTracker.requestDockableActivation(dockable.getComponent(), oldFocusOwner, true);
    }

    public static void setMaximized(IDockable dockable, boolean maximize) {
        DockingManager.setMaximized(dockable, DockingManager.getPerspective(dockable), maximize);
    }

    static void setMaximized(IDockable dockable, Perspective perspective, boolean maximize) {
        Component oldFocusOwner;
        JComponent c = dockable.getComponent();
        boolean isMaximized = DockingManager.isMaximized(dockable);
        if (isMaximized && maximize || !isMaximized && !maximize) {
            return;
        }
        boolean isMinimized = DockingManager.isMinimized(dockable);
        Window w_ = SwingUtilities.getWindowAncestor(c);
        Component component = oldFocusOwner = w_ == null ? null : w_.getFocusOwner();
        if (!isMaximized && !isMinimized) {
            DockingManager.updateRestorationLayout(dockable, perspective);
        }
        DockingManager.toggleMaximized(dockable, perspective);
        if (!maximize && !isMinimized) {
            DockingManager.updateRestorationLayout(dockable, perspective);
        }
        if (maximize) {
            ActiveDockableTracker.requestDockableActivation(dockable.getComponent(), oldFocusOwner, true);
        }
    }

    private static void updateRestorationLayout(IDockable dockable, Perspective perspective) {
        if (DockingManager.isFloating(dockable)) {
            perspective.updateFloatingRestorationLayoutNode((IFloatingDockingPort)DockingManager.getRootDockingPort(dockable.getComponent()), DockingManager.getFloatingGroup(dockable));
        } else {
            perspective.updateRestorationLayoutNode(DockingManager.getRootDockingPort(dockable.getComponent()));
        }
    }

    static void toggleMaximized(IDockable dockable, Perspective perspective) {
        JComponent c = dockable.getComponent();
        boolean isFloating = DockingManager.isFloating(dockable);
        IDockingPort rootPort = DockingManager.getRootDockingPort(c);
        boolean maxInOwner = false;
        IDockable maximizedDockable = DockingManager.getMaximizedDockable(rootPort);
        if (maximizedDockable == null) {
            Window w = c == null ? null : SwingUtilities.getWindowAncestor(c);
            boolean bl = maxInOwner = DockingManager.getMaximizeManager().getWindow(c) != w;
            if (DockingManager.isMinimized(dockable, perspective)) {
                DockingManager.setMinimized(dockable, perspective, false);
            } else if (isFloating && maxInOwner) {
                DockingPath path = DockingManager.getDockingState(dockable, perspective).getFloatingRestorePath();
                IDockable maximizedDockable_ = DockingManager.getMaximizedDockable(path.getRootDockingPort());
                DockingManager.setFloating(dockable, perspective, false, null);
                if (maximizedDockable_ == null) {
                    DockingManager.getDockingState(dockable, perspective).setPath((DockingPath)path.clone());
                }
            }
        }
        boolean maximized = false;
        if (maximizedDockable != null) {
            if (maximizedDockable != dockable) {
                DockingManager.setMaximized(maximizedDockable, perspective, false);
                DockingManager.setMaximized(dockable, perspective, true);
                return;
            }
            DockingManager.restore(dockable);
        } else {
            IDockingPort dockingPort = dockable.getDockingPort();
            MaximizedState state = new MaximizedState(dockable, dockingPort);
            if (dockingPort != null) {
                dockingPort.releaseForMaximization(dockable);
                if (maxInOwner && isFloating) {
                    rootPort = perspective.getDockingState(dockable, false).getFloatingRestorePath().getRootDockingPort();
                }
            } else {
                rootPort = DockingPortTracker.getRootDockingPort(SwingUtilities.getWindowAncestor(c), false);
            }
            rootPort.installMaximizedDockable(dockable);
            maximizedStatesByRootPort.put(rootPort, state);
            maximized = true;
        }
        DockingState dockingState = perspective.getDockingState(dockable, false);
        dockingState.setMaximized(maximized);
        if (c.isShowing()) {
            rootPort.getComponent().repaint();
        }
    }

    public static FloatingMode getFloatingMode() {
        return floatingMode;
    }

    public static void setFloatingMode(FloatingMode mode) {
        floatingMode = mode;
    }

    public static void setFloating(IDockable dockable, boolean floating) {
        DockingManager.setFloating(dockable, floating, null);
    }

    public static void setFloating(IDockable dockable, boolean floatDockable, Rectangle windowBounds) {
        DockingManager.setFloating(dockable, DockingManager.getPerspective(dockable), floatDockable, windowBounds);
    }

    static void setFloating(IDockable dockable, Perspective perspective, boolean floatDockable, Rectangle windowBounds) {
        DockingManager.setFloating(dockable, perspective, floatDockable, windowBounds, true);
    }

    static void setFloating(IDockable dockable, Perspective perspective, boolean floatDockable, Rectangle windowBounds, boolean modifyState) {
        if (floatDockable) {
            RootWindow rw;
            Window owner;
            JComponent c = dockable.getComponent();
            if (c.isShowing() && windowBounds == null) {
                Point p = c.getLocationOnScreen();
                windowBounds = new Rectangle(p.x, p.y, c.getWidth(), c.getHeight());
            }
            if (modifyState) {
                if (DockingManager.isMaximized(dockable)) {
                    DockingManager.setMaximized(dockable, perspective, false);
                } else if (DockingManager.isMinimized(dockable, perspective)) {
                    DockingManager.setMinimized(dockable, perspective, false);
                }
            }
            Window window = owner = (rw = RootWindow.getRootWindow(c)) != null ? rw.getWindow() : RootWindow.getMainWindow();
            if (windowBounds == null) {
                DockingManager.floatDockable(dockable, owner, perspective);
            } else {
                DockingManager.floatDockable(dockable, owner, perspective, windowBounds);
            }
        } else {
            if (modifyState) {
                boolean minimized;
                IDockable maximizedDockable;
                DockingPath path;
                IDockable maximizedDockable_;
                boolean maxInOwner;
                JComponent c = dockable.getComponent();
                Window w = c == null ? null : SwingUtilities.getWindowAncestor(c);
                boolean bl = maxInOwner = DockingManager.getMaximizeManager().getWindow(c) != w;
                if (maxInOwner && (maximizedDockable_ = DockingManager.getMaximizedDockable((path = DockingManager.getDockingState(dockable, perspective).getFloatingRestorePath()).getRootDockingPort())) != null) {
                    DockingState state = DockingManager.getDockingState(maximizedDockable_, perspective);
                    state.setPath((DockingPath)state.getFloatingRestorePath().clone());
                }
                if ((maximizedDockable = DockingManager.getMaximizedDockable((path = DockingManager.getDockingState(dockable, perspective).getPath()).getRootDockingPort())) != null) {
                    DockingManager.setMaximized(maximizedDockable, perspective, false);
                    perspective.getDockingState(maximizedDockable, false).setMaximized(false);
                }
                if ((maximizedDockable = DockingManager.getMaximizedDockable((path = DockingManager.getDockingState(dockable, perspective).getFloatingRestorePath()).getRootDockingPort())) != null) {
                    DockingManager.setMaximized(maximizedDockable, perspective, false);
                    perspective.getDockingState(maximizedDockable, false).setMaximized(false);
                }
                if ((minimized = DockingManager.isMinimized(dockable, perspective)) && DockingManager.getFloatingMode() == FloatingMode.MIN_MAX_OWNER) {
                    LOG.warning("Invalid docking state!\n  " + dockable);
                } else if (minimized) {
                    DockingManager.setMinimized(dockable, perspective, false);
                }
            }
            Component oldFocusOwner = SwingUtilities.getWindowAncestor(dockable.getComponent()).getFocusOwner();
            DockingManager.undock(dockable);
            DockingPath path = DockingManager.getDockingState(dockable, perspective).getFloatingRestorePath();
            if (path != null) {
                path.restore(dockable, perspective);
            }
            DockingManager.removeFromFloatingGroup(dockable);
            ActiveDockableTracker.requestDockableActivation(dockable.getComponent(), oldFocusOwner, true);
            dockable.getComponent().firePropertyChange("floating", true, false);
        }
    }

    static void addToFloatingGroup(IDockable dockable, String groupID) {
        FloatingGroup group = DockingManager.getFloatingGroup(groupID);
        if (dockable != null && group != null && !group.hasDockable(dockable.getID())) {
            DockingManager.removeFromFloatingGroup(dockable);
            group.addDockable(dockable.getID());
            DockingManager.setCurrentFloatingGroupID(dockable, group.getID());
        }
    }

    static void removeFromFloatingGroup(IDockable dockable) {
        FloatingGroup group = DockingManager.getFloatingGroup(dockable);
        if (dockable != null) {
            if (group != null) {
                group.removeDockable(dockable.getID());
            }
            DockingManager.setCurrentFloatingGroupID(dockable, null);
        }
        if (group != null && group.getDockableCount() == 0) {
            DockingManager.getPerspective(dockable).getModel().removeFloatingGroup(group.getID());
            group.destroy();
        }
    }

    static Window floatDockable(IDockable dockable, Window owner, Perspective perspective) {
        Rectangle bounds;
        FloatingGroup group = DockingManager.getFloatingGroup(dockable);
        Rectangle rectangle = bounds = group == null ? null : group.getBounds();
        if (bounds == null) {
            bounds = dockable.getComponent().isValid() ? dockable.getComponent().getBounds() : new Rectangle(0, 0, 200, 200);
            boolean isFloatingWindow = owner instanceof FloatingDialog || owner instanceof FloatingFrame;
            Window owner_ = null;
            if (isFloatingWindow) {
                owner_ = owner.getOwner();
            }
            Rectangle ownerBounds = owner_ != null && owner_.getBounds() != null ? owner_.getBounds() : RootWindow.getRootWindow(owner).getWindow().getBounds();
            int x = ownerBounds.x + ownerBounds.width / 2 - bounds.width / 2;
            int y = ownerBounds.y + ownerBounds.height / 2 - bounds.height / 2;
            bounds.setLocation(x, y);
        }
        return DockingManager.floatDockable(dockable, owner, perspective, bounds);
    }

    static Window floatDockable(IDockable dockable, Window owner, Perspective perspective, Rectangle windowBounds) {
        if (dockable == null || windowBounds == null) {
            return null;
        }
        Window floatingWindow = DockingManager.getDockingWindow(dockable, owner);
        if (windowBounds != null) {
            windowBounds = SyntheticaLookAndFeel.validateWindowBounds((Rectangle)windowBounds);
            floatingWindow.setBounds(windowBounds);
        }
        DockingManager.undock(dockable);
        if (floatingWindow instanceof FloatingDialog) {
            ((FloatingDialog)floatingWindow).addDockable(dockable, perspective);
        }
        if (floatingWindow instanceof FloatingFrame) {
            ((FloatingFrame)floatingWindow).addDockable(dockable, perspective);
        }
        dockable.getComponent().firePropertyChange("floatingWindowAncestor", false, true);
        if (!floatingWindow.isVisible()) {
            floatingWindow.setVisible(true);
        }
        RootWindow.getRootWindow(dockable.getComponent()).setPerspectiveID(perspective.getID());
        dockable.getComponent().firePropertyChange("floating", false, true);
        return floatingWindow;
    }

    private static Window getDockingWindow(IDockable dockable, Window owner) {
        Perspective p = DockingManager.getPerspective(dockable);
        FloatingGroup group = DockingManager.getFloatingGroup(dockable);
        if (group == null) {
            group = new FloatingGroup(p.getModel().getDockingState(dockable, false).getFloatingGroupID());
        } else if (group != null && !p.isLoading()) {
            group.removeDockable(dockable.getID());
            group = new FloatingGroup(null);
        }
        Window w = group.getFloatingWindow();
        if (w == null) {
            boolean floatingWinIsDialog = SyntheticaLookAndFeel.getBoolean((String)"JYDocking.floatingWindow.isDialog", null, (boolean)true);
            w = DockingManager.createFloatingWindow(owner, group.getID(), floatingWinIsDialog);
            group.setFloatingWindow(w);
            p.getModel().addFloatingGroup(group);
        }
        return w;
    }

    private static Window createFloatingWindow(Window owner, String groupName, boolean asDialog) {
        RootWindow rootWindow = RootWindow.getRootWindow(owner);
        Window window = rootWindow.getWindow();
        if (window instanceof FloatingDialog || window instanceof FloatingFrame) {
            Window window2 = window = window.getOwner() == null ? window : window.getOwner();
        }
        if (window instanceof Frame) {
            return asDialog ? new FloatingDialog((Frame)window, groupName) : new FloatingFrame((Frame)window, groupName);
        }
        if (window instanceof Dialog) {
            return asDialog ? new FloatingDialog((Dialog)window, groupName) : new FloatingFrame(groupName);
        }
        return null;
    }

    public static FloatingGroup getFloatingGroup(IDockable dockable) {
        Perspective p = DockingManager.getPerspectiveManager().getCurrentPerspective();
        DockingState state = p.getModel().getDockingState(dockable, false);
        return state == null ? null : DockingManager.getFloatingGroup(state.getFloatingGroupID());
    }

    static FloatingGroup getFloatingGroup(String groupID) {
        return DockingManager.getPerspectiveManager().getCurrentPerspective().getModel().getFloatingGroup(groupID);
    }

    private static void setCurrentFloatingGroupID(IDockable dockable, String groupID) {
        DockingState state = DockingManager.getPerspectiveManager().getCurrentPerspective().getModel().getDockingState(dockable, false);
        if (state != null) {
            state.setFloatingGroupID(groupID);
        }
    }

    public static boolean restore(IDockable dockable) {
        return RestorationManager.getInstance().restore(dockable, DockingManager.getPerspective(dockable));
    }

    public static boolean isComponentDocked(JComponent c) {
        return DockingManager.getDockingPort(c) != null;
    }

    public static boolean isDocked(IDockable dockable) {
        return DockingManager.getDockingPort(dockable) != null;
    }

    public static boolean isDocked(IDockingPort dockingPort, IDockable dockable) {
        return dockingPort == null || dockable == null ? false : dockingPort.isParentDockingPort(dockable.getComponent());
    }

    public static boolean isMaximized(IDockable dockable) {
        IDockingPort rootPort = DockingManager.getRootDockingPort(dockable.getComponent());
        IDockable d = DockingManager.getMaximizedDockable(rootPort);
        return d != null && d.equals(dockable);
    }

    public static boolean isMinimized(IDockable dockable) {
        return DockingManager.isMinimized(dockable, DockingManager.getPerspective(dockable));
    }

    static boolean isMinimized(IDockable dockable, Perspective perspective) {
        DockingState state = DockingManager.getDockingState(dockable, perspective);
        return state == null ? false : state.isMinimized();
    }

    public static boolean isFloating(IDockable dockable) {
        return DockingManager.getRootDockingPort(dockable.getComponent()) instanceof IFloatingDockingPort;
    }

    public static boolean isFloatingEnabled() {
        return FloatPolicyManager.getInstance().isGlobalFloatingEnabled();
    }

    public static void setFloatingEnabled(boolean enabled) {
        FloatPolicyManager.getInstance().setGlobalFloatingEnabled(enabled);
    }

    public static boolean isTabReorderByDraggingEnabled() {
        return tabReorderEnabled;
    }

    public static void setTabReorderByDraggingEnabled(boolean enabled) {
        tabReorderEnabled = enabled;
    }

    public static IPerspectiveManager getPerspectiveManager() {
        return PerspectiveManager.getInstance();
    }

    private static Perspective getPerspective(IDockable dockable) {
        RootWindow rootWindow = RootWindow.getRootWindow(dockable.getComponent());
        if (rootWindow != null) {
            return DockingManager.getPerspectiveManager().getPerspective(rootWindow.getPerspectiveID());
        }
        return DockingManager.getPerspectiveManager().getCurrentPerspective();
    }

    public static void setDockingStrategy(Class<?> clazz, IDockingStrategy strategy) {
        if (strategy == null) {
            DOCKING_STRATEGIES.removeStrategyClassMapping(clazz);
        } else {
            DOCKING_STRATEGIES.addStrategyClassMapping(clazz, strategy.getClass(), strategy);
        }
    }

    public static IDockingStrategy getDockingStrategy(Object obj) {
        Class<?> key = obj == null ? null : obj.getClass();
        return DockingManager.getDockingStrategy(key);
    }

    public static IDockingStrategy getDockingStrategy(Class<?> clazz) {
        IDockingStrategy strategy = DOCKING_STRATEGIES.getStrategy(clazz);
        return strategy;
    }

    private static IDockingStrategy findDockingStrategy(IDockable dockable) {
        IDockingStrategy strategy;
        IDockingPort port = dockable.getDockingPort();
        IDockingStrategy iDockingStrategy = strategy = port == null ? null : port.getDockingStrategy();
        if (strategy == null) {
            strategy = DockingManager.getDockingStrategy(DockingStrategy.class);
        }
        return strategy;
    }

    public static void updateDragListeners(IDockable dockable) {
        DragManager dragListener = DockingManager.getDragListener(dockable);
        if (dragListener == null) {
            dragListener = new DragManager(dockable);
        }
        for (JComponent c : dockable.getDragSources()) {
            DockingManager.updateDragListeners(c, dragListener);
        }
    }

    private static void updateDragListeners(JComponent dragSrc, DragManager listener) {
        MouseMotionListener motionListener = null;
        MouseMotionListener[] mouseMotionListenerArray = dragSrc.getMouseMotionListeners();
        int n = mouseMotionListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            MouseMotionListener l = mouseMotionListenerArray[n2];
            if (l instanceof DragManager) {
                motionListener = l;
                break;
            }
            ++n2;
        }
        if (motionListener != listener) {
            if (motionListener != null) {
                dragSrc.removeMouseMotionListener(motionListener);
            }
            dragSrc.addMouseMotionListener(listener);
        }
        MouseListener mouseListener = null;
        MouseListener[] mouseListenerArray = dragSrc.getMouseListeners();
        int n3 = mouseListenerArray.length;
        n = 0;
        while (n < n3) {
            MouseListener l = mouseListenerArray[n];
            if (l instanceof DragManager) {
                mouseListener = l;
                break;
            }
            ++n;
        }
        if (mouseListener != listener) {
            if (mouseListener != null) {
                dragSrc.removeMouseListener(mouseListener);
            }
            dragSrc.addMouseListener(listener);
        }
    }

    public static void removeDragListeners(JComponent c) {
        EventListener l;
        EventListener[] eventListenerArray = c.getMouseMotionListeners();
        int n = eventListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            l = eventListenerArray[n2];
            if (l instanceof DragManager) {
                c.removeMouseMotionListener((MouseMotionListener)l);
                break;
            }
            ++n2;
        }
        eventListenerArray = c.getMouseListeners();
        n = eventListenerArray.length;
        n2 = 0;
        while (n2 < n) {
            l = eventListenerArray[n2];
            if (l instanceof DragManager) {
                c.removeMouseListener((MouseListener)l);
                break;
            }
            ++n2;
        }
    }

    static IDockable getMaximizedDockable(IDockingPort rootPort) {
        MaximizedState state = maximizedStatesByRootPort.get(rootPort);
        return state == null ? null : state.getDockable();
    }

    static void returnFromMaximization(IDockingPort rootPort) {
        MaximizedState state = maximizedStatesByRootPort.get(rootPort);
        if (state != null && state.getOriginalPort() != null) {
            state.getOriginalPort().returnFromMaximization();
        }
    }

    static void removeMaximizedState(IDockingPort rootPort) {
        maximizedStatesByRootPort.remove(rootPort);
    }

    static IMinimizationManager getMinimizeManager() {
        return DockingManager.getInstance().minimizeManager;
    }

    static IMaximizationManager getMaximizeManager() {
        return DockingManager.getInstance().maximizeManager;
    }

    static DockingState getDockingState(IDockable dockable, Perspective perspective) {
        return perspective.getDockingState(dockable, false);
    }

    public static void setAutoPersist(boolean enabled) {
        DockingManager.getInstance().autoPersister.setEnabled(enabled);
    }

    public static void setDockableComponentSplitProportion(JComponent c, float proportion) {
        DockingManager.setSplitProportion(DockingManager.getDockable(c), proportion);
    }

    public static void setSplitProportion(IDockable dockable, float proportion) {
        DockingUtility.setSplitProportion(dockable, proportion);
    }

    public static void setSplitProportion(IDockingPort port, float proportion) {
        DockingUtility.setSplitProportion(port, proportion);
    }

    static void setMinimizeManager(IMinimizationManager mgr) {
        DockingManager.getInstance().minimizeManager = mgr;
    }

    static void setMinimizeManager(String mgrClass) {
        Object instance = DockingUtility.getInstance(mgrClass);
        DockingManager.setMinimizeManager((IMinimizationManager)instance);
    }

    static void setMaximizeManager(IMaximizationManager mgr) {
        DockingManager.getInstance().maximizeManager = mgr;
    }

    static void setMaximizeManager(String mgrClass) {
        Object instance = DockingUtility.getInstance(mgrClass);
        DockingManager.setMaximizeManager((IMaximizationManager)instance);
    }

    public static void removeDragListeners(IDockable dockable) {
        for (JComponent obj : dockable.getDragSources()) {
            if (!(obj instanceof JComponent)) continue;
            DockingManager.removeDragListeners(obj);
        }
    }

    public static float getDefaultSiblingSize() {
        return DockingManager.getInstance().defaultSiblingSize;
    }

    public static void setDefaultSiblingSize(float size) {
        size = Math.max(size, 0.0f);
        DockingManager.getInstance().defaultSiblingSize = size = Math.min(size, 1.0f);
    }

    public static IDockingPort getRootDockingPort(Component c) {
        return DockingPortTracker.getRootDockingPort(c);
    }

    public static IDockingPort getDockingPort(Component c) {
        return DockingUtility.getParentDockingPort(c);
    }

    public static IDockingPort getDockingPort(IDockable dockable) {
        return DockingUtility.getParentDockingPort(dockable);
    }

    public static IDockable getDockable(Component c) {
        return DOCKABLES_BY_COMPONENT.get(c);
    }

    public static Window getWindow(IDockable dockable) {
        if (dockable == null) {
            return null;
        }
        Window w = SwingUtilities.getWindowAncestor(dockable.getComponent());
        if (w == null) {
            FloatingGroup group = DockingManager.getFloatingGroup(dockable);
            if (group != null) {
                w = group.getFloatingWindow();
            } else if (DockingManager.isMinimized(dockable)) {
                w = RootWindow.getMainWindow();
            } else {
                IDockingPort rootPort = DockingPortTracker.getRootDockingPort(w, false);
                IDockable maximizedDockable = DockingManager.getMaximizedDockable(rootPort);
                if (maximizedDockable != null) {
                    w = SwingUtilities.getWindowAncestor(maximizedDockable.getComponent());
                }
            }
        }
        return w;
    }

    public static List<Window> getFoatingWindows() {
        ArrayList<Window> windows = new ArrayList<Window>();
        RootWindow[] rootWindowArray = RootWindow.getVisibleWindows();
        int n = rootWindowArray.length;
        int n2 = 0;
        while (n2 < n) {
            RootWindow rw = rootWindowArray[n2];
            Window w = rw.getWindow();
            if (w instanceof FloatingFrame || w instanceof FloatingDialog) {
                windows.add(w);
            }
            ++n2;
        }
        return windows;
    }

    public static Window getMainWindow() {
        return RootWindow.getMainWindow();
    }

    public static List<IDockable> getDockables(Window w) {
        ArrayList<IDockable> list = new ArrayList<IDockable>();
        if (w instanceof FloatingDialog) {
            FloatingGroup fg = DockingManager.getFloatingGroup(((FloatingDialog)w).getGroupID());
            return fg == null ? list : fg.getDockables();
        }
        if (w instanceof FloatingFrame) {
            FloatingGroup fg = DockingManager.getFloatingGroup(((FloatingFrame)w).getGroupID());
            return fg == null ? list : fg.getDockables();
        }
        for (String id : DockingManager.getDockableIDs()) {
            IDockable d = DockingManager.getDockable(id);
            if (w != DockingManager.getWindow(d)) continue;
            list.add(d);
        }
        return list;
    }

    public static IDockable getDockable(String id) {
        return DOCKABLES_BY_ID.get(id);
    }

    public static Set<String> getDockableIDs() {
        return new HashSet<String>(DOCKABLES_BY_ID.keySet());
    }

    static void setDockbarManager(String className) {
        DockbarManager.setDockbarManager(className);
    }

    static DockbarManager getDockbarManager() {
        return DockbarManager.getCurrent();
    }

    static DragManager getDragListener(IDockable dockable) {
        if (dockable == null || dockable.getDragSources() == null) {
            return null;
        }
        for (JComponent c : dockable.getDragSources()) {
            DragManager listener = DockingManager.getDragListener(c);
            if (listener == null) continue;
            return listener;
        }
        return null;
    }

    static boolean storeLayoutModel() throws IOException {
        IPerspectiveManager mgr = DockingManager.getPerspectiveManager();
        if (mgr == null) {
            return false;
        }
        mgr.storePerspectives(null, null);
        return true;
    }

    static void dispatchEvent(DockingEvent evt) {
        DockingManager.dispatchEvent(evt, false, false);
    }

    static void dispatchEvent(DockingEvent evt, boolean dispatchToOldPort, boolean dispatchToNewPort) {
        IDockable dockable = evt.getDockable();
        List<IDockingEventListener> listeners = dockable.getDockingListeners();
        DockingManager.dispatchEvent(evt, listeners);
        if (dispatchToOldPort && evt.getOldDockingPort() != null) {
            listeners = evt.getOldDockingPort().getDockingListeners();
            DockingManager.dispatchEvent(evt, listeners);
        }
        if (dispatchToNewPort && evt.getNewDockingPort() != null) {
            listeners = evt.getNewDockingPort().getDockingListeners();
            DockingManager.dispatchEvent(evt, listeners);
        }
    }

    static boolean isValidDockingRegion(String region) {
        return "CENTER".equals(region) || "NORTH".equals(region) || "SOUTH".equals(region) || "EAST".equals(region) || "WEST".equals(region);
    }

    private static String determineTabText(JComponent comp, String persistId) {
        String tabText = null;
        if (tabText == null) {
            tabText = comp.getName();
        }
        if (tabText == null) {
            tabText = persistId;
        }
        String string = tabText = tabText == null ? "null" : tabText.trim();
        if (tabText.length() == 0) {
            tabText = "null";
        }
        return tabText;
    }

    private static boolean hasRegisteredDockableId(String id) {
        return DOCKABLES_BY_ID.containsKey(id);
    }

    private static DragManager getDragListener(JComponent c) {
        MouseMotionListener[] listeners = c.getMouseMotionListeners();
        int i = 0;
        while (i < listeners.length) {
            if (listeners[i] instanceof DragManager) {
                return (DragManager)listeners[i];
            }
            ++i;
        }
        return null;
    }

    private static void dispatchEvent(DockingEvent evt, List<IDockingEventListener> listeners) {
        for (IDockingEventListener l : listeners) {
            switch (evt.getEventType()) {
                case 0: {
                    l.dockableRegistered(evt);
                    break;
                }
                case 1: {
                    l.dockableUnregistered(evt);
                    break;
                }
                case 2: {
                    l.dragStarted(evt);
                    break;
                }
                case 3: {
                    l.dropStarted(evt);
                    break;
                }
                case 4: {
                    l.dockingCompleted(evt);
                    break;
                }
                case 5: {
                    l.dockingCanceled(evt);
                    break;
                }
                case 6: {
                    l.undockingCompleted(evt);
                    break;
                }
                case 7: {
                    l.undockingStarted(evt);
                }
            }
        }
    }

    private static class AutoPersist
    extends Thread {
        private boolean enabled;

        private AutoPersist() {
        }

        @Override
        public void run() {
            this.store();
        }

        private void store() {
            try {
                if (this.isEnabled()) {
                    DockingManager.storeLayoutModel();
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        public boolean isEnabled() {
            return this.enabled;
        }

        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }
    }

    public static enum FloatingMode {
        MIN_MAX_FLOATING,
        MIN_MAX_OWNER;

    }

    private static class MaximizedState {
        private final IDockable dockable;
        private final IDockingPort originalPort;

        public MaximizedState(IDockable dockable, IDockingPort originalDockingPort) {
            this.dockable = dockable;
            this.originalPort = originalDockingPort;
        }

        public IDockable getDockable() {
            return this.dockable;
        }

        public IDockingPort getOriginalPort() {
            return this.originalPort;
        }
    }
}

