/*
 * Decompiled with CFR 0.152.
 */
package de.javasoft.docking.controls;

import de.javasoft.docking.controls.DockingManager;
import de.javasoft.docking.controls.Event;
import de.javasoft.docking.controls.IDockable;
import de.javasoft.docking.controls.IDockingPort;
import de.javasoft.docking.controls.Perspective;
import java.awt.AWTEvent;
import java.awt.Component;
import java.util.Map;

public class DockingEvent
extends Event {
    private static final long serialVersionUID = 6068788655735960200L;
    public static final int DOCKABLE_REGISTERED = 0;
    public static final int DOCKABLE_UNREGISTERED = 1;
    public static final int DRAG_STARTED = 2;
    public static final int DROP_STARTED = 3;
    public static final int DOCKING_COMPLETED = 4;
    public static final int DOCKING_CANCELED = 5;
    public static final int UNDOCKING_COMPLETED = 6;
    public static final int UNDOCKING_STARTED = 7;
    private IDockingPort oldPort;
    private IDockingPort newPort;
    private boolean consumed;
    private AWTEvent trigger;
    private String region;
    private boolean overWindow;
    private Map<Object, Object> dragContext;
    private Perspective perspective;

    public DockingEvent(IDockable source, int eventType) {
        this(source, null, null, eventType, null, null);
    }

    public DockingEvent(IDockable source, IDockingPort oldPort, IDockingPort newPort, int eventType, Map<Object, Object> context) {
        this(source, oldPort, newPort, eventType, null, context);
    }

    public DockingEvent(IDockable source, IDockingPort oldPort, IDockingPort newPort, int eventType, AWTEvent trigger, Map<Object, Object> context) {
        super(source, eventType);
        this.oldPort = oldPort;
        this.newPort = newPort;
        this.trigger = trigger;
        this.region = "UNKNOWN";
        this.dragContext = context;
        this.setOverWindow(true);
    }

    public IDockingPort getOldDockingPort() {
        return this.oldPort;
    }

    public IDockingPort getNewDockingPort() {
        return this.newPort;
    }

    public boolean isConsumed() {
        return this.consumed;
    }

    public void consume() {
        this.consumed = true;
    }

    public AWTEvent getTrigger() {
        return this.trigger;
    }

    public void setTrigger(AWTEvent trigger) {
        this.trigger = trigger;
    }

    public Object getTriggerSource() {
        return this.trigger == null ? null : this.trigger.getSource();
    }

    public String getRegion() {
        return this.region;
    }

    public void setRegion(String region) {
        if (!DockingManager.isValidDockingRegion(region)) {
            region = "UNKNOWN";
        }
        this.region = region;
    }

    public boolean isOverWindow() {
        return this.overWindow;
    }

    public void setOverWindow(boolean overWindow) {
        this.overWindow = overWindow;
    }

    public IDockable getDockable() {
        return (IDockable)this.getSource();
    }

    public Component getComponent() {
        return this.getDockable().getComponent();
    }

    public Map<Object, Object> getDragContext() {
        return this.dragContext;
    }

    public void setPerspective(Perspective perspective) {
        this.perspective = perspective;
    }

    public Perspective getPerspective() {
        return this.perspective;
    }
}

