/*
 * Decompiled with CFR 0.152.
 */
package de.javasoft.docking.controls;

import de.javasoft.docking.controls.DockbarManager;
import de.javasoft.docking.controls.IDockable;
import de.javasoft.docking.controls.ResizeListener;
import de.javasoft.plaf.synthetica.SyntheticaLookAndFeel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.event.MouseInputAdapter;

public class DockbarSlidePanel
extends JPanel {
    private static final long serialVersionUID = 4911695333060445893L;
    public static final String uiClassID = "JYDockingDockbarSlidePanelUI";
    public static final int UNSPECIFIED_PREFERRED_SIZE = -1;
    private static final Dimension RESIZE_DIMENSION = SyntheticaLookAndFeel.getInstance().scaleDimension(3, 3);
    private DockbarManager manager;
    private JPanel dragEdge;
    private int prefSize;
    private boolean locked;
    private int placement = 2;

    public DockbarSlidePanel(DockbarManager mgr) {
        super(new BorderLayout(0, 0));
        this.manager = mgr;
        this.prefSize = -1;
        this.dragEdge = new JPanel();
        this.dragEdge.setOpaque(false);
        this.dragEdge.setPreferredSize(RESIZE_DIMENSION);
        ResizeListener listener = new ResizeListener(mgr);
        this.dragEdge.addMouseListener(listener);
        this.dragEdge.addMouseMotionListener(listener);
        this.updatePlacement();
        MouseInputAdapter mouseListener = new MouseInputAdapter(){};
        this.addMouseListener(mouseListener);
        this.addMouseMotionListener(mouseListener);
    }

    @Override
    public String getUIClassID() {
        return uiClassID;
    }

    public void updateContents() {
        JComponent c;
        Component[] componentArray = this.getComponents();
        int n = componentArray.length;
        int n2 = 0;
        while (n2 < n) {
            Component c2 = componentArray[n2];
            if (c2 != this.dragEdge) {
                this.remove(c2);
            }
            ++n2;
        }
        IDockable d = this.manager.getActiveDockable();
        JComponent jComponent = c = d == null ? null : d.getComponent();
        if (c != null) {
            this.add((Component)c, "Center");
        }
    }

    public void updatePlacement() {
        this.setPlacement(this.manager.getActivePlacement());
        this.remove(this.dragEdge);
        this.add((Component)this.dragEdge, this.getEdgeRegion());
        this.dragEdge.setCursor(this.getResizeCursor());
        this.revalidate();
    }

    private void setPlacement(int placement) {
        int oldValue = this.placement;
        this.placement = placement;
        this.firePropertyChange("placement", oldValue, placement);
    }

    public int getPlacement() {
        return this.placement;
    }

    private String getEdgeRegion() {
        int orientation = this.manager.getActivePlacement();
        switch (orientation) {
            case 1: {
                return "South";
            }
            case 3: {
                return "North";
            }
            case 4: {
                return "West";
            }
        }
        return "East";
    }

    public Cursor getResizeCursor() {
        int orientation = this.manager.getActivePlacement();
        return orientation == 3 ? Cursor.getPredefinedCursor(8) : Cursor.getPredefinedCursor(11);
    }

    public int getPrefSize() {
        return this.prefSize;
    }

    public void setPrefSize(int prefSize) {
        this.prefSize = prefSize;
    }

    public boolean isLocked() {
        return this.locked;
    }

    public void setLocked(boolean locked) {
        this.locked = locked;
    }
}

