/*
 * Decompiled with CFR 0.152.
 */
package de.javasoft.docking.controls;

import de.javasoft.docking.controls.Dockbar;
import de.javasoft.docking.controls.DockingManager;
import de.javasoft.docking.controls.IDockable;
import de.javasoft.label.JYLabel;
import de.javasoft.widgets.IRotatableComponent;
import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.SwingUtilities;

public class DockbarLabel
extends JYLabel {
    private static final long serialVersionUID = 2965469910633138220L;
    public static final String uiClassID = "JYDockingDockbarLabelUI";
    private String dockingId;
    private int placement;

    public DockbarLabel(String dockableID, int placement) {
        this.dockingId = dockableID;
        this.setPlacement(placement);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                if (evt.getButton() != 1) {
                    return;
                }
                DockbarLabel.this.activate(true);
            }

            @Override
            public void mouseEntered(MouseEvent evt) {
                DockbarLabel.this.activate(false);
            }
        });
        this.updateLabel();
    }

    public String getUIClassID() {
        return uiClassID;
    }

    private void activate(boolean lock) {
        Dockbar dockbar = (Dockbar)SwingUtilities.getAncestorOfClass(Dockbar.class, (Component)((Object)this));
        if (dockbar != null) {
            dockbar.activate(this.dockingId, lock);
        }
    }

    private void updateLabel() {
        IDockable d = this.getDockable();
        this.setText(d.getTabText());
        this.setIcon(d.getDockbarIcon());
    }

    private IRotatableComponent.Rotation placementToRotation(int placement) {
        if (placement == 3) {
            return IRotatableComponent.Rotation.NONE;
        }
        if (placement == 4) {
            return IRotatableComponent.Rotation.RIGHT;
        }
        return IRotatableComponent.Rotation.LEFT;
    }

    public IDockable getDockable() {
        return DockingManager.getDockable(this.dockingId);
    }

    private void setPlacement(int placement) {
        int oldValue = this.placement;
        this.placement = placement;
        this.setRotation(this.placementToRotation(this.getPlacement()));
        this.firePropertyChange("placement", oldValue, placement);
    }

    public int getPlacement() {
        return this.placement;
    }
}

