/*
 * Decompiled with CFR 0.152.
 */
package de.javasoft.docking.controls;

import de.javasoft.docking.controls.Dockbar;
import de.javasoft.docking.controls.DockbarManager;
import de.javasoft.docking.controls.DockingUtility;
import java.awt.EventQueue;
import java.awt.Point;
import javax.swing.SwingUtilities;

class DockbarDeactivator {
    private DockbarManager manager;
    private Deactivator deactivator;
    private boolean mouseOver;

    public DockbarDeactivator(DockbarManager mgr) {
        this.manager = mgr;
    }

    public void mouseEntered(Point mousePoint) {
        if (this.mouseOver) {
            return;
        }
        this.mouseOver = true;
        if (this.deactivator != null) {
            this.deactivator.interrupt();
        }
        this.deactivator = null;
    }

    public void mouseExited(Point mousePoint) {
        if (!this.mouseOver) {
            return;
        }
        this.mouseOver = false;
        if (!this.isOverDockbars(mousePoint)) {
            this.deactivator = new Deactivator(this.manager.getActiveDockableId());
            this.deactivator.start();
        }
    }

    public void mousePressed(Point mousePoint, boolean mouseOver) {
        if (mouseOver) {
            if (!this.manager.isSlidePanelLocked()) {
                this.manager.lockSlidePanel();
            }
        } else if (!this.isOverDockbars(mousePoint)) {
            if (this.deactivator != null) {
                this.deactivator.interrupt();
            }
            this.manager.setActiveDockable((String)null);
        }
    }

    public boolean isMouseOver() {
        return this.mouseOver;
    }

    private boolean isOverDockbars(Point mousePoint) {
        Dockbar leftBar = this.manager.getLeftBar();
        Dockbar bottomBar = this.manager.getBottomBar();
        Dockbar rightBar = this.manager.getRightBar();
        return SwingUtilities.convertRectangle(leftBar.getParent(), leftBar.getBounds(), leftBar.getRootPane()).contains(mousePoint) || SwingUtilities.convertRectangle(bottomBar.getParent(), bottomBar.getBounds(), bottomBar.getRootPane()).contains(mousePoint) || SwingUtilities.convertRectangle(rightBar.getParent(), rightBar.getBounds(), rightBar.getRootPane()).contains(mousePoint);
    }

    private class Deactivator
    extends Thread {
        private String dockableID;

        private Deactivator(String id) {
            this.dockableID = id;
            this.setDaemon(true);
        }

        @Override
        public void run() {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                this.interrupt();
            }
            if (!this.isInterrupted()) {
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        String activeId = DockbarDeactivator.this.manager.getActiveDockableId();
                        if (!(DockingUtility.isChanged(activeId, Deactivator.this.dockableID) || DockbarDeactivator.this.manager.isSlidePanelLocked() || DockbarDeactivator.this.manager.isAnimating())) {
                            DockbarDeactivator.this.manager.setActiveDockable((String)null);
                        }
                    }
                });
            }
        }
    }
}

