/*
 * Decompiled with CFR 0.152.
 */
package de.javasoft.docking.controls;

import de.javasoft.docking.controls.DockbarLabel;
import de.javasoft.docking.controls.DockbarManager;
import de.javasoft.docking.controls.IDockable;
import de.javasoft.plaf.synthetica.SyntheticaLookAndFeel;
import de.javasoft.syntheticaaddons.SyntheticaAddonsUtilities;
import de.javasoft.widgets.IUIPropertySupport;
import de.javasoft.widgets.ui.UIValue;
import de.javasoft.widgets.util.WidgetUtils;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.util.ArrayList;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;

public class Dockbar
extends JPanel
implements IUIPropertySupport {
    private static final long serialVersionUID = -5801730631751358416L;
    public static final String uiClassID = "JYDockingDockbarUI";
    protected int placement;
    protected DockbarManager manager;
    protected ArrayList<DockbarLabel> dockbarLabels = new ArrayList();
    private UIValue<Integer> dockbarItemGap;

    public Dockbar(DockbarManager manager, int placement) {
        this.manager = manager;
        this.setPlacement(placement);
        this.addAncestorListener(new AncestorListener(){

            @Override
            public void ancestorRemoved(AncestorEvent event) {
                DockbarManager.removeDockbarManager(Dockbar.this.manager);
            }

            @Override
            public void ancestorMoved(AncestorEvent event) {
            }

            @Override
            public void ancestorAdded(AncestorEvent event) {
            }
        });
    }

    @Override
    public String getUIClassID() {
        return uiClassID;
    }

    @Override
    public String getName() {
        String name = super.getName();
        return name == null ? "JYDocking.Dockbar" : name;
    }

    @Override
    public void updateUI() {
        super.updateUI();
        if (this.manager == null) {
            return;
        }
        for (IDockable d : this.manager.getDockables(this.placement)) {
            SyntheticaAddonsUtilities.updateChildrenUI((JComponent)d.getComponent());
        }
    }

    public void dock(IDockable dockable) {
        DockbarLabel newLabel = new DockbarLabel(dockable.getID(), this.getPlacement());
        this.add((Component)((Object)newLabel));
        this.add(this.createItemGap(dockable.getID()));
        this.dockbarLabels.add(newLabel);
    }

    void undock(IDockable dockable) {
        DockbarLabel label = this.getLabel(dockable);
        this.remove((Component)((Object)label));
        this.dockbarLabels.remove((Object)label);
        this.remove(SyntheticaLookAndFeel.findComponent((String)dockable.getID(), (Container)this));
    }

    int getDockableCount() {
        return this.dockbarLabels.size();
    }

    public boolean contains(IDockable dockable) {
        return this.getLabel(dockable) != null;
    }

    public DockbarLabel getLabel(IDockable dockable) {
        for (DockbarLabel label : this.dockbarLabels) {
            if (label.getDockable() != dockable) continue;
            return label;
        }
        return null;
    }

    private Component createItemGap(String id) {
        int gap = this.getDockbarItemGap();
        Component c = this.placement == 3 ? Box.createHorizontalStrut(gap) : Box.createVerticalStrut(gap);
        c.setName(id);
        return c;
    }

    public int getPlacement() {
        return this.placement;
    }

    private void setPlacement(int placement) {
        int oldValue = this.placement;
        this.placement = placement;
        int boxConstraint = placement == 1 || placement == 3 ? 2 : 3;
        this.setLayout(new BoxLayout(this, boxConstraint));
        this.firePropertyChange("placement", oldValue, placement);
    }

    @Override
    public Dimension getPreferredSize() {
        if (this.dockbarLabels.size() == 0) {
            return new Dimension(0, 0);
        }
        return super.getPreferredSize();
    }

    void activate(String dockableID, boolean lock) {
        if (this.manager != null) {
            this.manager.setActiveDockable(dockableID);
            if (lock) {
                this.manager.lockSlidePanel();
            }
        }
    }

    public static String placementAsString(int placement) {
        return placement == 3 ? "bottom" : (placement == 4 ? "right" : "left");
    }

    public void setDockbarItemGap(Integer gap) {
        this.setDockbarItemGap(gap, false);
    }

    public void setDockbarItemGap(Integer gap, boolean isUIResource) {
        WidgetUtils.setUIProperty((JComponent)this, (String)"dockbarItemGap", this.dockbarItemGap, (Object)this.getDockbarItemGap(), (Object)gap, (boolean)isUIResource, (boolean)false, (boolean)false);
    }

    public boolean dockbarItemGapIsUIResource() {
        return this.getDockbarItemGapUIValue().isUIResource();
    }

    public Integer getDockbarItemGap() {
        return (Integer)this.getDockbarItemGapUIValue().get();
    }

    private UIValue<Integer> getDockbarItemGapUIValue() {
        if (this.dockbarItemGap == null) {
            this.dockbarItemGap = new UIValue();
        }
        return this.dockbarItemGap;
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }
}

