/*
 * Decompiled with CFR 0.152.
 */
package de.javasoft.docking.controls;

import de.javasoft.docking.JYDockingPort;
import de.javasoft.docking.controls.DockingEvent;
import de.javasoft.docking.controls.DockingManager;
import de.javasoft.docking.controls.IDockable;
import de.javasoft.docking.controls.IDockableAcceptor;
import de.javasoft.docking.controls.IDockingConstants;
import de.javasoft.docking.controls.IDockingEventListener;
import de.javasoft.docking.controls.IDockingPort;
import de.javasoft.docking.controls.Perspective;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;

public class DockableComponentWrapper
implements IDockable,
IDockingConstants {
    private JComponent component;
    private String id;
    protected ArrayList<JComponent> dragSources;
    protected ArrayList<IDockingEventListener> dockingListeners;
    private boolean dockingEnabled;
    private boolean active;
    private boolean activeStateLocked;
    private String tabText;
    private Icon dockbarIcon;
    private Icon tabIcon;
    private HashMap<String, Float> regionInset;
    private HashMap<String, Float> siblingSize;
    private HashMap<String, Boolean> territoryBlocked;
    private float dragThreshold;
    private float previewSize;
    private boolean mouseMotionListenersBlockedWhileDragging;
    private IDockableAcceptor dockableAcceptor;

    public DockableComponentWrapper(JComponent c, String id, String tabText, boolean componentIsDraggable) {
        if (id == null) {
            throw new IllegalArgumentException("The 'id' parameter cannot be null.");
        }
        this.component = c;
        this.id = id;
        this.setTabText(tabText);
        this.dragSources = new ArrayList(1);
        this.dockingListeners = new ArrayList(1);
        this.initDefaults();
        if (componentIsDraggable) {
            this.getDragSources().add(c);
        }
    }

    private void initDefaults() {
        this.dockingEnabled = true;
        if (this.tabText == null) {
            this.tabText = "-------";
        }
        this.dragThreshold = 4.0f;
        this.previewSize = 0.3f;
        this.mouseMotionListenersBlockedWhileDragging = true;
        this.regionInset = new HashMap();
        this.regionInset.put("NORTH", Float.valueOf(0.25f));
        this.regionInset.put("SOUTH", Float.valueOf(0.25f));
        this.regionInset.put("EAST", Float.valueOf(0.25f));
        this.regionInset.put("WEST", Float.valueOf(0.25f));
        this.siblingSize = new HashMap();
        this.siblingSize.put("NORTH", Float.valueOf(DockingManager.getDefaultSiblingSize()));
        this.siblingSize.put("SOUTH", Float.valueOf(DockingManager.getDefaultSiblingSize()));
        this.siblingSize.put("EAST", Float.valueOf(DockingManager.getDefaultSiblingSize()));
        this.siblingSize.put("WEST", Float.valueOf(DockingManager.getDefaultSiblingSize()));
        this.territoryBlocked = new HashMap();
        this.territoryBlocked.put("NORTH", Boolean.FALSE);
        this.territoryBlocked.put("SOUTH", Boolean.FALSE);
        this.territoryBlocked.put("EAST", Boolean.FALSE);
        this.territoryBlocked.put("WEST", Boolean.FALSE);
        this.territoryBlocked.put("CENTER", Boolean.FALSE);
        this.dockableAcceptor = new IDockableAcceptor(){

            @Override
            public boolean acceptDockable(IDockable dockable, String region) {
                IDockingPort port = DockableComponentWrapper.this.getDockingPort();
                return (!(port instanceof JYDockingPort) || !((JYDockingPort)port).isRegionBlocked(region)) && !DockableComponentWrapper.this.isTerritoryBlocked(region);
            }
        };
    }

    @Override
    public JComponent getComponent() {
        return this.component;
    }

    @Override
    public String getID() {
        return this.id;
    }

    @Override
    public IDockingPort getDockingPort() {
        return DockingManager.getDockingPort(this);
    }

    @Override
    public List<JComponent> getDragSources() {
        return this.dragSources;
    }

    @Override
    public boolean dock(IDockable dockable, Perspective perspective, String relativeRegion, float ratio) {
        return DockingManager.dock(dockable, this, perspective, relativeRegion, ratio);
    }

    @Override
    public void addDockingListener(IDockingEventListener listener) {
        this.dockingListeners.add(listener);
    }

    @Override
    public void removeDockingListener(IDockingEventListener listener) {
        this.dockingListeners.remove(listener);
    }

    @Override
    public List<IDockingEventListener> getDockingListeners() {
        return this.dockingListeners;
    }

    @Override
    public void setDockingEnabled(boolean enabled) {
        boolean oldValue = this.isDockingEnabled();
        this.dockingEnabled = enabled;
        this.component.firePropertyChange("dockingEnabled", oldValue, enabled);
    }

    @Override
    public boolean isDockingEnabled() {
        return this.dockingEnabled;
    }

    @Override
    public void setActive(boolean active) {
        if (!this.isActiveStateLocked() && active != this.isActive()) {
            boolean oldValue = this.isActive();
            this.active = active;
            this.component.firePropertyChange("active", oldValue, active);
            this.component.repaint();
        }
    }

    @Override
    public boolean isActive() {
        return this.active;
    }

    @Override
    public void setActiveStateLocked(boolean locked) {
        boolean oldValue = this.isActiveStateLocked();
        this.activeStateLocked = locked;
        this.component.firePropertyChange("activeStateLocked", oldValue, locked);
    }

    @Override
    public boolean isActiveStateLocked() {
        return this.activeStateLocked;
    }

    @Override
    public void setTabText(String text) {
        this.tabText = text;
    }

    @Override
    public String getTabText() {
        return this.tabText;
    }

    @Override
    public void setDockbarIcon(Icon icon) {
        this.dockbarIcon = icon;
    }

    @Override
    public Icon getDockbarIcon() {
        return this.dockbarIcon;
    }

    @Override
    public void setTabIcon(Icon icon) {
        this.tabIcon = icon;
    }

    @Override
    public Icon getTabIcon() {
        return this.tabIcon;
    }

    @Override
    public void setRegionInset(String region, float inset) {
        this.regionInset.put(region, Float.valueOf(inset));
    }

    @Override
    public float getRegionInset(String region) {
        Float inset = this.regionInset.get(region);
        return inset == null ? 0.0f : inset.floatValue();
    }

    @Override
    public void setSiblingSize(String region, float size) {
        this.siblingSize.put(region, Float.valueOf(size));
    }

    @Override
    public float getSiblingSize(String region) {
        Float size = this.siblingSize.get(region);
        return size == null ? 0.0f : size.floatValue();
    }

    @Override
    public void setTerritoryBlocked(String region, boolean blocked) {
        this.territoryBlocked.put(region, blocked);
    }

    @Override
    public boolean isTerritoryBlocked(String region) {
        Boolean blocked = this.territoryBlocked.get(region);
        return blocked == null ? false : blocked;
    }

    @Override
    public void setDragTheshold(float threshold) {
        float oldValue = this.getDragThreshold();
        this.dragThreshold = threshold;
        this.component.firePropertyChange("dragThreshold", oldValue, threshold);
    }

    @Override
    public float getDragThreshold() {
        return this.dragThreshold;
    }

    @Override
    public void setPreviewSize(float size) {
        float oldValue = this.getPreviewSize();
        this.previewSize = size;
        this.component.firePropertyChange("previewSize", oldValue, size);
    }

    @Override
    public float getPreviewSize() {
        return this.previewSize;
    }

    @Override
    public void setMouseMotionListenersBlockedWhileDragging(boolean blocked) {
        boolean oldValue = this.isMouseMotionListenersBlockedWhileDragging();
        this.mouseMotionListenersBlockedWhileDragging = blocked;
        this.component.firePropertyChange("mouseMotionListenersBlockedWhileDragging", oldValue, blocked);
    }

    @Override
    public boolean isMouseMotionListenersBlockedWhileDragging() {
        return this.mouseMotionListenersBlockedWhileDragging;
    }

    @Override
    public void setDockableAcceptor(IDockableAcceptor acceptor) {
        this.dockableAcceptor = acceptor;
    }

    @Override
    public IDockableAcceptor getDockableAcceptor() {
        return this.dockableAcceptor;
    }

    @Override
    public void dockableRegistered(DockingEvent evt) {
    }

    @Override
    public void dockableUnregistered(DockingEvent evt) {
    }

    @Override
    public void dockingCanceled(DockingEvent evt) {
    }

    @Override
    public void dockingCompleted(DockingEvent evt) {
    }

    @Override
    public void dragStarted(DockingEvent evt) {
    }

    @Override
    public void dropStarted(DockingEvent evt) {
    }

    @Override
    public void undockingStarted(DockingEvent evt) {
    }

    @Override
    public void undockingCompleted(DockingEvent evt) {
    }
}

